/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.management.project.validation;

import com.topcoder.management.project.Project;
import com.topcoder.management.project.ProjectValidator;
import com.topcoder.management.project.ValidationException;
import java.util.Map;

public class DefaultProjectValidator
implements ProjectValidator {
    private static final int MAX_LENGTH_OF_NAME = 64;
    private static final int MAX_LENGTH_OF_PROPERTY_KEY = 64;
    private static final int MAX_LENGTH_OF_DESCRIPTION = 256;
    private static final int MAX_LENGTH_OF_PROPERTY_VALUE = 4096;

    public DefaultProjectValidator(String namespace) {
    }

    public void validateProject(Project project) throws ValidationException {
        if (project == null) {
            throw new IllegalArgumentException("project can not be null.");
        }
        DefaultProjectValidator.validateStringLength(project.getProjectStatus().getName(), "project status's name", 64);
        DefaultProjectValidator.validateStringLength(project.getProjectCategory().getName(), "project category's name", 64);
        DefaultProjectValidator.validateStringLength(project.getProjectCategory().getProjectType().getName(), "project type's name", 64);
        DefaultProjectValidator.validateStringLength(project.getProjectStatus().getDescription(), "project status's description", 256);
        DefaultProjectValidator.validateStringLength(project.getProjectCategory().getDescription(), "project category's description", 256);
        DefaultProjectValidator.validateStringLength(project.getProjectCategory().getProjectType().getDescription(), "project type's description", 256);
        for (Map.Entry entry : project.getAllProperties().entrySet()) {
            DefaultProjectValidator.validateStringLength((String)entry.getKey(), "property key", 64);
            DefaultProjectValidator.validateStringLength(entry.getValue().toString(), "property value", 4096);
        }
    }

    private static void validateStringLength(String str, String name, int length) throws ValidationException {
        if (str.length() > length) {
            throw new ValidationException(name + "length must be less than or equal to " + length);
        }
    }
}

