/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.management.project.link;

import com.topcoder.management.project.Project;
import com.topcoder.util.errorhandling.BaseRuntimeException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLinkCycleException
extends BaseRuntimeException {
    private List<Project> cycle;

    public ProjectLinkCycleException(List<Project> cycle) {
        super("There is a cyclic dependency in project links. The following projects are in cycle: " + ProjectLinkCycleException.buildCycleText(cycle));
        this.cycle = cycle;
    }

    public ProjectLinkCycleException(String message) {
        super(message);
    }

    public ProjectLinkCycleException(String message, Throwable cause) {
        super(message, cause);
    }

    public ProjectLinkCycleException(Throwable cause) {
        super(cause);
    }

    public List<Project> getCycle() {
        return this.cycle;
    }

    private static String buildCycleText(List<Project> cycle) {
        StringBuilder b = new StringBuilder();
        for (Project project : cycle) {
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(project.getProperty("Project Name"));
            b.append(" ").append(project.getProperty("Project Version"));
            b.append(" (").append(project.getId()).append(")");
        }
        return b.toString();
    }
}

