/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.management.project.link;

import com.topcoder.db.connectionfactory.DBConnectionException;
import com.topcoder.db.connectionfactory.DBConnectionFactory;
import com.topcoder.management.project.ConfigurationException;
import com.topcoder.management.project.PersistenceException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.log.Level;
import com.topcoder.util.log.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;

class Helper {
    static final DataType STRING_TYPE = new StringType();
    static final DataType LONG_TYPE = new LongType();
    static final DataType DATE_TYPE = new DateType();

    private Helper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object doSingleValueQuery(Connection connection, String queryString, Object[] queryArgs, DataType columnType) throws PersistenceException {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block12: {
            Helper.assertObjectNotNull(connection, "connection");
            Helper.assertStringNotNullNorEmpty(queryString, "queryString");
            Helper.assertObjectNotNull(columnType, "columnType");
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement(queryString);
            for (int i = 0; i < queryArgs.length; ++i) {
                preparedStatement.setObject(i + 1, queryArgs[i]);
            }
            resultSet = preparedStatement.executeQuery();
            int columnCount = resultSet.getMetaData().getColumnCount();
            if (columnCount != 1 || !resultSet.next()) break block12;
            Object object = columnType.getValue(resultSet, 1);
            try {
                Helper.closeResultSet(resultSet);
            }
            finally {
                Helper.closeStatement(preparedStatement);
            }
            return object;
        }
        try {
            try {
                throw new IllegalArgumentException("The given query [" + queryString + "] did not return ONE result row containing " + "ONE value using the query arguments [" + Arrays.asList(queryArgs).toString() + "].");
            }
            catch (SQLException e) {
                throw new PersistenceException("Error occurs while executing query [" + queryString + "] using the query arguments " + Arrays.asList(queryArgs).toString() + ".", e);
            }
        }
        catch (Throwable throwable) {
            try {
                Helper.closeResultSet(resultSet);
            }
            finally {
                Helper.closeStatement(preparedStatement);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object[][] doQuery(Connection connection, String queryString, Object[] queryArgs, DataType[] columnTypes) throws PersistenceException {
        Object[][] objectArray;
        Helper.assertObjectNotNull(connection, "connection");
        Helper.assertStringNotNullNorEmpty(queryString, "queryString");
        Helper.assertArrayNotNullNorHasNull(columnTypes, "columnTypes");
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(queryString);
            for (int i = 0; i < queryArgs.length; ++i) {
                preparedStatement.setObject(i + 1, queryArgs[i]);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Object[]> ret = new ArrayList<Object[]>();
            int columnCount = resultSet.getMetaData().getColumnCount();
            if (columnTypes.length != columnCount) {
                throw new IllegalArgumentException("The column types length [" + columnTypes.length + "] does not match the result set column count[" + columnCount + "].");
            }
            while (resultSet.next()) {
                Object[] rowData = new Object[columnCount];
                for (int i = 0; i < rowData.length; ++i) {
                    rowData[i] = columnTypes[i].getValue(resultSet, i + 1);
                }
                ret.add(rowData);
            }
            objectArray = (Object[][])ret.toArray((T[])new Object[0][]);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException("Error occurs while executing query [" + queryString + "] using the query arguments " + Arrays.asList(queryArgs).toString() + ".", e);
            }
            catch (Throwable throwable) {
                try {
                    Helper.closeResultSet(resultSet);
                    throw throwable;
                }
                finally {
                    Helper.closeStatement(preparedStatement);
                }
            }
        }
        try {
            Helper.closeResultSet(resultSet);
            return objectArray;
        }
        finally {
            Helper.closeStatement(preparedStatement);
        }
    }

    static int doDMLQuery(Connection connection, String queryString, Object[] queryArgs) throws PersistenceException {
        Helper.assertObjectNotNull(connection, "connection");
        Helper.assertStringNotNullNorEmpty(queryString, "queryString");
        Helper.assertObjectNotNull(queryArgs, "queryArgs");
        PreparedStatement preparedStatement = null;
        try {
            int i;
            preparedStatement = connection.prepareStatement(queryString);
            for (i = 0; i < queryArgs.length; ++i) {
                preparedStatement.setObject(i + 1, queryArgs[i]);
            }
            preparedStatement.execute();
            i = preparedStatement.getUpdateCount();
            return i;
        }
        catch (SQLException e) {
            throw new PersistenceException("Error occurs while executing query [" + queryString + "] using the query arguments " + Arrays.asList(queryArgs).toString() + ".", e);
        }
        finally {
            Helper.closeStatement(preparedStatement);
        }
    }

    static int doDMLQuery(PreparedStatement statement, Object[] queryArgs) throws PersistenceException {
        Helper.assertObjectNotNull(statement, "statement");
        Helper.assertObjectNotNull(queryArgs, "queryArgs");
        try {
            statement.clearParameters();
            for (int i = 0; i < queryArgs.length; ++i) {
                statement.setObject(i + 1, queryArgs[i]);
            }
            statement.execute();
            return statement.getUpdateCount();
        }
        catch (SQLException e) {
            throw new PersistenceException("Error occurs while executing prepared statement using the query arguments " + Arrays.asList(queryArgs).toString() + ".", e);
        }
    }

    static void closeConnection(Connection conn) throws PersistenceException {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException("Error occurs when closing the connection.", e);
            }
        }
    }

    static void closeStatement(PreparedStatement ps) throws PersistenceException {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new PersistenceException("Error occurs when closing the prepared statement.", e);
            }
        }
    }

    static void closeResultSet(ResultSet rs) throws PersistenceException {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException("Error occurs when closing the result set.", e);
            }
        }
    }

    static void commitTransaction(Connection conn) throws PersistenceException {
        if (conn != null) {
            try {
                conn.commit();
            }
            catch (SQLException e) {
                throw new PersistenceException("Error occurs when doing commit.", e);
            }
        }
    }

    static void rollBackTransaction(Connection conn) throws PersistenceException {
        if (conn != null) {
            try {
                conn.rollback();
            }
            catch (SQLException e) {
                throw new PersistenceException("Error occurs when doing rollback.", e);
            }
        }
    }

    static boolean checkEntityExists(String tableName, String columnName, long id, Connection conn) throws PersistenceException {
        Helper.assertStringNotNullNorEmpty(tableName, "tableName");
        Helper.assertStringNotNullNorEmpty(columnName, "columnName");
        Helper.assertLongPositive(id, "id");
        Helper.assertObjectNotNull(conn, "conn");
        Long entryCount = (Long)Helper.doSingleValueQuery(conn, "SELECT COUNT(*) FROM " + tableName + " WHERE " + columnName + "=?", new Object[]{new Long(id)}, LONG_TYPE);
        return entryCount > 0L;
    }

    static void assertObjectNotNull(Object obj, String name) {
        if (obj == null) {
            throw new IllegalArgumentException(name + " should not be null.");
        }
    }

    static void assertArrayNotNullNorHasNull(Object[] array, String name) {
        Helper.assertObjectNotNull(array, name);
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            throw new IllegalArgumentException(name + " should not contain null.");
        }
    }

    static void assertStringNotNullNorEmpty(String str, String name) {
        Helper.assertObjectNotNull(str, name);
        if (str.trim().length() == 0) {
            throw new IllegalArgumentException(name + " should not be empty (trimmed).");
        }
    }

    static void assertLongPositive(long val, String name) {
        if (val <= 0L) {
            throw new IllegalArgumentException(name + " [" + val + "] should be positive.");
        }
    }

    static String getConfigurationParameterValue(ConfigManager cm, String namespace, String name, boolean required, Log logger) throws ConfigurationException {
        String value;
        Helper.assertObjectNotNull(cm, "cm");
        Helper.assertStringNotNullNorEmpty(namespace, "namespace");
        Helper.assertStringNotNullNorEmpty(name, "name");
        try {
            value = cm.getString(namespace, name);
        }
        catch (UnknownNamespaceException e) {
            logger.log(Level.FATAL, (Object)("Configuration namespace [" + namespace + "] does not exist."));
            throw new ConfigurationException("Configuration namespace [" + namespace + "] does not exist.", e);
        }
        if (value == null) {
            if (required) {
                logger.log(Level.FATAL, (Object)("Configuration parameter [" + name + "] under namespace [" + namespace + "] is not specified."));
                throw new ConfigurationException("Configuration parameter [" + name + "] under namespace [" + namespace + "] is not specified.");
            }
        } else if (value.trim().length() == 0) {
            logger.log(Level.FATAL, (Object)("Configuration parameter [" + name + "] under namespace [" + namespace + "] is empty (trimmed)."));
            throw new ConfigurationException("Configuration parameter [" + name + "] under namespace [" + namespace + "] is empty (trimmed).");
        }
        logger.log(Level.INFO, (Object)("Read propery[" + name + "] which is " + (required ? " required " : " optional ") + " with value[" + value + "] from namespace [" + namespace + "]."));
        return value;
    }

    static Connection createConnection(DBConnectionFactory factory, String connectionName) throws PersistenceException {
        try {
            return connectionName == null ? factory.createConnection() : factory.createConnection(connectionName);
        }
        catch (DBConnectionException e) {
            throw new PersistenceException("Error occurs when getting " + (connectionName == null ? "the default connection." : "the connection '" + connectionName + "'."), e);
        }
    }

    private static class DateType
    extends DataType {
        private DateType() {
        }

        protected Object getValue(ResultSet resultSet, int index) throws SQLException {
            Helper.assertObjectNotNull(resultSet, "resultSet");
            return resultSet.getTimestamp(index);
        }
    }

    private static class LongType
    extends DataType {
        private LongType() {
        }

        protected Object getValue(ResultSet resultSet, int index) throws SQLException {
            Helper.assertObjectNotNull(resultSet, "resultSet");
            long aLong = resultSet.getLong(index);
            return resultSet.wasNull() ? null : new Long(aLong);
        }
    }

    private static class StringType
    extends DataType {
        private StringType() {
        }

        protected Object getValue(ResultSet resultSet, int index) throws SQLException {
            Helper.assertObjectNotNull(resultSet, "resultSet");
            return resultSet.getString(index);
        }
    }

    static abstract class DataType {
        private DataType() {
        }

        protected abstract Object getValue(ResultSet var1, int var2) throws SQLException;
    }
}

