/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.management.project;

import com.topcoder.management.project.ConfigurationException;
import com.topcoder.management.project.Helper;
import com.topcoder.management.project.PersistenceException;
import com.topcoder.management.project.Project;
import com.topcoder.management.project.ProjectCategory;
import com.topcoder.management.project.ProjectFilterUtility;
import com.topcoder.management.project.ProjectManager;
import com.topcoder.management.project.ProjectPersistence;
import com.topcoder.management.project.ProjectPropertyType;
import com.topcoder.management.project.ProjectStatus;
import com.topcoder.management.project.ProjectType;
import com.topcoder.management.project.ProjectValidator;
import com.topcoder.management.project.ValidationException;
import com.topcoder.search.builder.SearchBuilderConfigurationException;
import com.topcoder.search.builder.SearchBuilderException;
import com.topcoder.search.builder.SearchBundle;
import com.topcoder.search.builder.SearchBundleManager;
import com.topcoder.search.builder.filter.Filter;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.datavalidator.IntegerValidator;
import com.topcoder.util.datavalidator.LongValidator;
import com.topcoder.util.datavalidator.StringValidator;
import com.topcoder.util.sql.databaseabstraction.CustomResultSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;

public class ProjectManagerImpl
implements ProjectManager {
    public static final String NAMESPACE = "com.topcoder.management.project";
    private static final String PROJECT_SEARCH_BUNDLE = "ProjectSearchBundle";
    private static final String PERSISTENCE_CLASS = "PersistenceClass";
    private static final String PERSISTENCE_NAMESPACE = "PersistenceNamespace";
    private static final String VALIDATOR_CLASS = "ValidatorClass";
    private static final String VALIDATOR_NAMESPACE = "ValidatorNamespace";
    private static final String SEARCH_BUILDER_NAMESPACE = "SearchBuilderNamespace";
    private static final int MAX_LENGTH_OF_NAME = 64;
    private static final int MAX_LENGTH_OF_VALUE = 4096;
    private final ProjectPersistence persistence;
    private final SearchBundle searchBundle;
    private final ProjectValidator validator;

    public ProjectManagerImpl() throws ConfigurationException {
        this(NAMESPACE);
    }

    public ProjectManagerImpl(String ns) throws ConfigurationException {
        Helper.checkStringNotNullOrEmpty(ns, "ns");
        ConfigManager cm = ConfigManager.getInstance();
        try {
            String persistenceClass = cm.getString(ns, PERSISTENCE_CLASS);
            Helper.checkObjectNotNull(persistenceClass, "persistenceClass");
            String persistenceNamespace = cm.getString(ns, PERSISTENCE_NAMESPACE);
            if (persistenceNamespace == null) {
                persistenceNamespace = persistenceClass;
            }
            String validatorClass = cm.getString(ns, VALIDATOR_CLASS);
            Helper.checkObjectNotNull(validatorClass, "validatorClass");
            String validatorNamespace = cm.getString(ns, VALIDATOR_NAMESPACE);
            if (validatorNamespace == null) {
                validatorNamespace = validatorClass;
            }
            this.persistence = (ProjectPersistence)ProjectManagerImpl.createObject(persistenceClass, persistenceNamespace);
            this.validator = (ProjectValidator)ProjectManagerImpl.createObject(validatorClass, validatorNamespace);
            String searchBuilderNamespace = cm.getString(ns, SEARCH_BUILDER_NAMESPACE);
            Helper.checkObjectNotNull(searchBuilderNamespace, "searchBuilderNamespace");
            SearchBundleManager manager = new SearchBundleManager(searchBuilderNamespace);
            this.searchBundle = manager.getSearchBundle(PROJECT_SEARCH_BUNDLE);
            Helper.checkObjectNotNull(this.searchBundle, "searchBundle");
        }
        catch (IllegalArgumentException iae) {
            throw new ConfigurationException("some property is missed", iae);
        }
        catch (UnknownNamespaceException une) {
            throw new ConfigurationException(ns + " namespace is unknown.", une);
        }
        catch (ClassCastException cce) {
            throw new ConfigurationException("error occurs", cce);
        }
        catch (SearchBuilderConfigurationException sbce) {
            throw new ConfigurationException("error occurs when creating SearchBundleManager", sbce);
        }
        this.setValidationMap();
    }

    public void createProject(Project project, String operator) throws PersistenceException, ValidationException {
        this.validator.validateProject(project);
        this.persistence.createProject(project, operator);
    }

    public void updateProject(Project project, String reason, String operator) throws PersistenceException, ValidationException {
        this.validator.validateProject(project);
        this.persistence.updateProject(project, reason, operator);
    }

    public Project getProject(long id) throws PersistenceException {
        return this.persistence.getProject(id);
    }

    public Project[] getProjectsByCreateDate(int days) throws PersistenceException {
        return this.persistence.getProjectsByCreateDate(days);
    }

    public Project[] getProjects(long[] ids) throws PersistenceException {
        return this.persistence.getProjects(ids);
    }

    public Project[] searchProjects(Filter filter) throws PersistenceException {
        Helper.checkObjectNotNull(filter, "filter");
        try {
            CustomResultSet result = (CustomResultSet)this.searchBundle.search(filter);
            return this.persistence.getProjects(result);
        }
        catch (SearchBuilderException sbe) {
            throw new PersistenceException("error occurs when getting search result.", sbe);
        }
        catch (ClassCastException cce) {
            throw new PersistenceException("error occurs when trying to get ids.", cce);
        }
    }

    public Project[] getUserProjects(long user) throws PersistenceException {
        Filter resourcePropFilter = ProjectFilterUtility.buildProjectPropertyResourceEqualFilter("External Reference ID", String.valueOf(user));
        Filter activeStatusFilter = ProjectFilterUtility.buildStatusNameEqualFilter("Active");
        return this.searchProjects(ProjectFilterUtility.buildAndFilter(resourcePropFilter, activeStatusFilter));
    }

    public ProjectType[] getAllProjectTypes() throws PersistenceException {
        return this.persistence.getAllProjectTypes();
    }

    public ProjectCategory[] getAllProjectCategories() throws PersistenceException {
        return this.persistence.getAllProjectCategories();
    }

    public ProjectStatus[] getAllProjectStatuses() throws PersistenceException {
        return this.persistence.getAllProjectStatuses();
    }

    public ProjectPropertyType[] getAllProjectPropertyTypes() throws PersistenceException {
        return this.persistence.getAllProjectPropertyTypes();
    }

    private static Object createObject(String className, String namespace) throws ConfigurationException {
        try {
            Constructor<?> constructor = Class.forName(className).getConstructor(String.class);
            return constructor.newInstance(namespace);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ConfigurationException("error occurs when trying to create object via reflection.", cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ConfigurationException("error occurs when trying to create object via reflection.", nsme);
        }
        catch (InstantiationException ie) {
            throw new ConfigurationException("error occurs when trying to create object via reflection.", ie);
        }
        catch (IllegalAccessException iae) {
            throw new ConfigurationException("error occurs when trying to create object via reflection.", iae);
        }
        catch (InvocationTargetException ite) {
            throw new ConfigurationException("error occurs when trying to create object via reflection.", ite);
        }
    }

    private void setValidationMap() {
        HashMap<String, Object> validationMap = new HashMap<String, Object>();
        validationMap.put("ProjectTypeID", LongValidator.isPositive());
        validationMap.put("ProjectCategoryID", LongValidator.isPositive());
        validationMap.put("ProjectStatusID", LongValidator.isPositive());
        validationMap.put("ProjectTypeName", StringValidator.hasLength((IntegerValidator)IntegerValidator.lessThanOrEqualTo((int)64)));
        validationMap.put("ProjectCategoryName", StringValidator.hasLength((IntegerValidator)IntegerValidator.lessThanOrEqualTo((int)64)));
        validationMap.put("ProjectStatusName", StringValidator.hasLength((IntegerValidator)IntegerValidator.lessThanOrEqualTo((int)64)));
        validationMap.put("ProjectPropertyName", StringValidator.hasLength((IntegerValidator)IntegerValidator.lessThanOrEqualTo((int)64)));
        validationMap.put("ProjectPropertyValue", StringValidator.hasLength((IntegerValidator)IntegerValidator.lessThanOrEqualTo((int)4096)));
        validationMap.put("ProjectResourcePropertyName", StringValidator.hasLength((IntegerValidator)IntegerValidator.lessThanOrEqualTo((int)64)));
        validationMap.put("ProjectResourcePropertyValue", StringValidator.hasLength((IntegerValidator)IntegerValidator.lessThanOrEqualTo((int)4096)));
        this.searchBundle.setSearchableFields(validationMap);
    }
}

