/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.management.project;

import com.topcoder.management.project.Helper;
import com.topcoder.search.builder.SearchBundle;
import com.topcoder.search.builder.filter.Filter;
import java.util.List;

public class ProjectFilterUtility {
    public static final String PROJECT_TYPE_ID = "ProjectTypeID";
    public static final String PROJECT_TYPE_NAME = "ProjectTypeName";
    public static final String PROJECT_CATEGORY_ID = "ProjectCategoryID";
    public static final String PROJECT_CATEGORY_NAME = "ProjectCategoryName";
    public static final String PROJECT_STATUS_ID = "ProjectStatusID";
    public static final String PROJECT_STATUS_NAME = "ProjectStatusName";
    public static final String PROJECT_PROPERTY_NAME = "ProjectPropertyName";
    public static final String PROJECT_PROPERTY_VALUE = "ProjectPropertyValue";
    public static final String PROJECT_RESOURCE_PROPERTY_NAME = "ProjectResourcePropertyName";
    public static final String PROJECT_RESOURCE_PROPERTY_VALUE = "ProjectResourcePropertyValue";

    private ProjectFilterUtility() {
    }

    public static Filter buildTypeIdEqualFilter(long typeId) {
        Helper.checkNumberPositive(typeId, "typeId");
        return SearchBundle.buildEqualToFilter((String)PROJECT_TYPE_ID, (Comparable)new Long(typeId));
    }

    public static Filter buildTypeIdInFilter(List typeIds) {
        ProjectFilterUtility.assertLongListValid(typeIds, "typeIds");
        return SearchBundle.buildInFilter((String)PROJECT_TYPE_ID, (List)typeIds);
    }

    public static Filter buildTypeNameEqualFilter(String name) {
        Helper.checkStringNotNullOrEmpty(name, "name");
        return SearchBundle.buildEqualToFilter((String)PROJECT_TYPE_NAME, (Comparable)((Object)name));
    }

    public static Filter buildTypeNameInFilter(List names) {
        ProjectFilterUtility.assertStringListValid(names, "names");
        return SearchBundle.buildInFilter((String)PROJECT_TYPE_NAME, (List)names);
    }

    public static Filter buildCategoryIdEqualFilter(long categoryId) {
        Helper.checkNumberPositive(categoryId, "categoryId");
        return SearchBundle.buildEqualToFilter((String)PROJECT_CATEGORY_ID, (Comparable)new Long(categoryId));
    }

    public static Filter buildCategoryIdInFilter(List categoryIds) {
        ProjectFilterUtility.assertLongListValid(categoryIds, "categoryIds");
        return SearchBundle.buildInFilter((String)PROJECT_CATEGORY_ID, (List)categoryIds);
    }

    public static Filter buildCategoryNameEqualFilter(String name) {
        Helper.checkStringNotNullOrEmpty(name, "name");
        return SearchBundle.buildEqualToFilter((String)PROJECT_CATEGORY_NAME, (Comparable)((Object)name));
    }

    public static Filter buildCategoryNameInFilter(List names) {
        ProjectFilterUtility.assertStringListValid(names, "names");
        return SearchBundle.buildInFilter((String)PROJECT_CATEGORY_NAME, (List)names);
    }

    public static Filter buildStatusIdEqualFilter(long statusId) {
        Helper.checkNumberPositive(statusId, "statusId");
        return SearchBundle.buildEqualToFilter((String)PROJECT_STATUS_ID, (Comparable)new Long(statusId));
    }

    public static Filter buildStatusIdInFilter(List statusIds) {
        ProjectFilterUtility.assertLongListValid(statusIds, "statusIds");
        return SearchBundle.buildInFilter((String)PROJECT_STATUS_ID, (List)statusIds);
    }

    public static Filter buildStatusNameEqualFilter(String name) {
        Helper.checkStringNotNullOrEmpty(name, "name");
        return SearchBundle.buildEqualToFilter((String)PROJECT_STATUS_NAME, (Comparable)((Object)name));
    }

    public static Filter buildStatusNameInFilter(List names) {
        ProjectFilterUtility.assertStringListValid(names, "names");
        return SearchBundle.buildInFilter((String)PROJECT_STATUS_NAME, (List)names);
    }

    public static Filter buildProjectPropertyNameEqualFilter(String name) {
        Helper.checkStringNotNullOrEmpty(name, "name");
        return SearchBundle.buildEqualToFilter((String)PROJECT_PROPERTY_NAME, (Comparable)((Object)name));
    }

    public static Filter buildProjectPropertyNameInFilter(List names) {
        ProjectFilterUtility.assertStringListValid(names, "names");
        return SearchBundle.buildInFilter((String)PROJECT_PROPERTY_NAME, (List)names);
    }

    public static Filter buildProjectPropertyValueEqualFilter(String value) {
        Helper.checkStringNotNullOrEmpty(value, "value");
        return SearchBundle.buildEqualToFilter((String)PROJECT_PROPERTY_VALUE, (Comparable)((Object)value));
    }

    public static Filter buildProjectPropertyValueInFilter(List values) {
        ProjectFilterUtility.assertStringListValid(values, "values");
        return SearchBundle.buildInFilter((String)PROJECT_PROPERTY_VALUE, (List)values);
    }

    public static Filter buildProjectPropertyEqualFilter(String name, String value) {
        return ProjectFilterUtility.buildAndFilter(ProjectFilterUtility.buildProjectPropertyNameEqualFilter(name), ProjectFilterUtility.buildProjectPropertyValueEqualFilter(value));
    }

    public static Filter buildProjectResourcePropertyNameEqualFilter(String name) {
        Helper.checkStringNotNullOrEmpty(name, "name");
        return SearchBundle.buildEqualToFilter((String)PROJECT_RESOURCE_PROPERTY_NAME, (Comparable)((Object)name));
    }

    public static Filter buildProjectResourcePropertyNameInFilter(List names) {
        ProjectFilterUtility.assertStringListValid(names, "names");
        return SearchBundle.buildInFilter((String)PROJECT_RESOURCE_PROPERTY_NAME, (List)names);
    }

    public static Filter buildProjectResourcePropertyValueEqualFilter(String value) {
        Helper.checkStringNotNullOrEmpty(value, "value");
        return SearchBundle.buildEqualToFilter((String)PROJECT_RESOURCE_PROPERTY_VALUE, (Comparable)((Object)value));
    }

    public static Filter buildProjectResourcePropertyValueInFilter(List values) {
        ProjectFilterUtility.assertStringListValid(values, "values");
        return SearchBundle.buildInFilter((String)PROJECT_RESOURCE_PROPERTY_VALUE, (List)values);
    }

    public static Filter buildProjectPropertyResourceEqualFilter(String name, String value) {
        return ProjectFilterUtility.buildAndFilter(ProjectFilterUtility.buildProjectResourcePropertyNameEqualFilter(name), ProjectFilterUtility.buildProjectResourcePropertyValueEqualFilter(value));
    }

    public static Filter buildAndFilter(Filter f1, Filter f2) {
        Helper.checkObjectNotNull(f1, "f1");
        Helper.checkObjectNotNull(f2, "f2");
        return SearchBundle.buildAndFilter((Filter)f1, (Filter)f2);
    }

    public static Filter buildOrFilter(Filter f1, Filter f2) {
        Helper.checkObjectNotNull(f1, "f1");
        Helper.checkObjectNotNull(f2, "f2");
        return SearchBundle.buildOrFilter((Filter)f1, (Filter)f2);
    }

    public static Filter buildNotFilter(Filter f1) {
        Helper.checkObjectNotNull(f1, "f1");
        return SearchBundle.buildNotFilter((Filter)f1);
    }

    private static void assertLongListValid(List list, String name) {
        Helper.checkObjectNotNull(list, name);
        Helper.checkNumberPositive(list.size(), name + "'s size");
        for (Object element : list) {
            if (!(element instanceof Long)) {
                throw new IllegalArgumentException(name + "has a element that is not Long");
            }
            Helper.checkNumberPositive((Long)element, name + "'s element");
        }
    }

    private static void assertStringListValid(List list, String name) {
        Helper.checkObjectNotNull(list, name);
        Helper.checkNumberPositive(list.size(), name + "'s size");
        for (Object element : list) {
            if (!(element instanceof String)) {
                throw new IllegalArgumentException(name + "has a element that is not String.");
            }
            Helper.checkStringNotNullOrEmpty((String)element, name + "'s element");
        }
    }
}

