/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.management.project;

import com.topcoder.management.project.AuditableObject;
import com.topcoder.management.project.Helper;
import com.topcoder.management.project.ProjectCategory;
import com.topcoder.management.project.ProjectStatus;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Project
extends AuditableObject
implements Serializable {
    private long id = 0L;
    private ProjectCategory projectCategory = null;
    private ProjectStatus projectStatus = null;
    private Map properties = new HashMap();

    public Project(ProjectCategory projectCategory, ProjectStatus projectStatus) {
        this(0L, projectCategory, projectStatus);
    }

    public Project(long projectId, ProjectCategory projectCategory, ProjectStatus projectStatus) {
        this(projectId, projectCategory, projectStatus, new HashMap());
    }

    public Project(long projectId, ProjectCategory projectCategory, ProjectStatus projectStatus, Map properties) {
        if (projectId < 0L) {
            throw new IllegalArgumentException("id can not less than zero.");
        }
        this.id = projectId;
        this.setProjectCategory(projectCategory);
        this.setProjectStatus(projectStatus);
        Helper.checkObjectNotNull(properties, "properties");
        for (Map.Entry entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String)) {
                throw new IllegalArgumentException("properties contains some key that is not String.");
            }
            Helper.checkStringNotNullOrEmpty((String)entry.getKey(), "properties's key");
            Helper.checkObjectNotNull(entry.getValue(), "properties's value");
        }
        this.properties = new HashMap(properties);
    }

    public void setId(long id) {
        Helper.checkNumberPositive(id, "id");
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setProjectStatus(ProjectStatus projectStatus) {
        Helper.checkObjectNotNull(projectStatus, "projectStatus");
        this.projectStatus = projectStatus;
    }

    public ProjectStatus getProjectStatus() {
        return this.projectStatus;
    }

    public void setProjectCategory(ProjectCategory projectCategory) {
        Helper.checkObjectNotNull(projectCategory, "projectCategory");
        this.projectCategory = projectCategory;
    }

    public ProjectCategory getProjectCategory() {
        return this.projectCategory;
    }

    public void setProperty(String name, Object value) {
        Helper.checkStringNotNullOrEmpty(name, "name");
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public Object getProperty(String name) {
        Helper.checkStringNotNullOrEmpty(name, "name");
        return this.properties.get(name);
    }

    public Map getAllProperties() {
        return new HashMap(this.properties);
    }
}

