/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.format;

import com.topcoder.util.format.PlainPrimitiveFormatter;
import com.topcoder.util.format.PrettyPrimitiveFormatter;
import com.topcoder.util.format.PrimitiveFormatter;
import java.text.DecimalFormat;

public class PrimitiveFormatterFactory {
    private PrimitiveFormatterFactory() {
    }

    public static PrimitiveFormatter getPlainFormatter() {
        return new PlainPrimitiveFormatter();
    }

    public static PrimitiveFormatter getPrettyFormatter() {
        return new PrettyPrimitiveFormatter();
    }

    public static PrimitiveFormatter getFormatter(String format) throws IllegalArgumentException {
        return PrimitiveFormatterFactory.getFormatter(format, null);
    }

    public static PrimitiveFormatter getFormatter(String format, DecimalFormat df) throws IllegalArgumentException {
        return new PrettyPrimitiveFormatter(format, df);
    }
}

