/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.format;

import com.topcoder.util.format.PrimitiveFormatter;
import java.text.DecimalFormat;

class PrettyPrimitiveFormatter
implements PrimitiveFormatter {
    private String format;
    private DecimalFormat intDF;
    private DecimalFormat shortDF;
    private DecimalFormat longDF;
    private DecimalFormat byteDF;
    private DecimalFormat charDF;
    private DecimalFormat floatDF;
    private DecimalFormat doubleDF;
    private static final String DEFAULT_INTEGER_FORMAT = "##,###";
    private static final String DEFAULT_SHORT_FORMAT = "###";
    private static final String DEFAULT_LONG_FORMAT = "##,###";
    private static final String DEFAULT_BYTE_FORMAT = "#";
    private static final String DEFAULT_CHAR_FORMAT = "#";
    private static final String DEFAULT_FLOAT_FORMAT = "##,###.00";
    private static final String DEFAULT_DOUBLE_FORMAT = "##,###.00";

    PrettyPrimitiveFormatter() {
        this(null, null);
    }

    PrettyPrimitiveFormatter(String format, DecimalFormat df) throws IllegalArgumentException {
        this.format = format;
        if (format == null && df == null) {
            this.byteDF = new DecimalFormat("#");
            this.charDF = new DecimalFormat("#");
            this.shortDF = new DecimalFormat(DEFAULT_SHORT_FORMAT);
            this.intDF = new DecimalFormat("##,###");
            this.longDF = new DecimalFormat("##,###");
            this.floatDF = new DecimalFormat("##,###.00");
            this.doubleDF = new DecimalFormat("##,###.00");
        } else {
            if (format == null) {
                this.intDF = df;
            } else if (df == null) {
                this.intDF = new DecimalFormat(format);
            } else {
                this.intDF = (DecimalFormat)df.clone();
                this.intDF.applyPattern(format);
            }
            this.floatDF = this.doubleDF = this.intDF;
            this.charDF = this.doubleDF;
            this.byteDF = this.doubleDF;
            this.longDF = this.doubleDF;
            this.shortDF = this.doubleDF;
        }
    }

    public String format(byte b) {
        return this.byteDF.format(b);
    }

    public String format(char ch) {
        return this.charDF.format(ch);
    }

    public String format(short s) {
        return this.shortDF.format(s);
    }

    public String format(int i) {
        return this.intDF.format(i);
    }

    public String format(long l) {
        return this.longDF.format(l);
    }

    public String format(float r) {
        return this.floatDF.format(r);
    }

    public String format(double lr) {
        return this.doubleDF.format(lr);
    }
}

