/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.format;

import com.topcoder.util.format.ObjectFormatMethod;
import com.topcoder.util.format.ObjectFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class ObjectFormatterImplementer
implements ObjectFormatter {
    private HashMap classMap = new HashMap();

    ObjectFormatterImplementer() {
    }

    public ObjectFormatMethod getFormatMethodForClass(Class type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        ObjectFormatMethod ofm = null;
        Vector v = (Vector)this.classMap.get(type);
        if (v != null) {
            ofm = (ObjectFormatMethod)v.get(0);
        }
        return ofm;
    }

    public void setFormatMethodForClass(Class type, ObjectFormatMethod ofm, boolean fFormatSubtypes) throws IllegalArgumentException, NullPointerException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        if (ofm == null) {
            throw new NullPointerException();
        }
        Vector<Object> v = new Vector<Object>();
        v.add(ofm);
        v.add(new Boolean(fFormatSubtypes));
        this.classMap.put(type, v);
    }

    public void unsetFormatMethodForClass(Class type) throws IllegalArgumentException {
        if (!this.classMap.containsKey(type)) {
            throw new IllegalArgumentException();
        }
        this.classMap.remove(type);
    }

    public ObjectFormatMethod getFormatMethodForObject(Object obj) throws IllegalArgumentException {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        Vector<Class> superTypes = new Vector<Class>();
        int count = 0;
        Class curType = null;
        Class<?> objType = obj.getClass();
        ObjectFormatMethod ofm = this.getFormatMethodForClass(objType);
        if (ofm == null) {
            Set entries = this.classMap.entrySet();
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                curType = (Class)entry.getKey();
                Vector v = (Vector)entry.getValue();
                boolean fFormatSubtypes = (Boolean)v.get(1);
                if (!curType.isAssignableFrom(objType) || !fFormatSubtypes) continue;
                superTypes.add(curType);
            }
            int superTypesCount = superTypes.size();
            for (int i = 0; i < superTypesCount && count != superTypesCount; ++i) {
                curType = (Class)superTypes.get(i);
                count = 0;
                for (int j = 0; j < superTypesCount; ++j) {
                    Class tempType = (Class)superTypes.get(j);
                    if (!tempType.isAssignableFrom(curType)) continue;
                    ++count;
                }
            }
            if (count != 0 && count == superTypesCount) {
                ofm = this.getFormatMethodForClass(curType);
            }
        }
        return ofm;
    }

    public String format(Object obj) throws IllegalArgumentException {
        ObjectFormatMethod ofm = this.getFormatMethodForObject(obj);
        if (ofm != null) {
            return ofm.format(obj);
        }
        throw new IllegalArgumentException();
    }
}

