/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.format;

import com.topcoder.util.format.DateFormatMethod;
import java.text.SimpleDateFormat;
import java.util.Date;

class DefaultDateFormatMethod
implements DateFormatMethod {
    private String format;
    private SimpleDateFormat sdf;
    private static final String DEFAULT_DATE_FORMAT = "MM/dd/yyyy";

    DefaultDateFormatMethod() {
        this(DEFAULT_DATE_FORMAT, null);
    }

    DefaultDateFormatMethod(String format, SimpleDateFormat sdf) throws IllegalArgumentException {
        this.format = format;
        if (format == null && sdf == null) {
            this.sdf = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
        } else if (format == null) {
            this.sdf = sdf;
        } else if (sdf == null) {
            this.sdf = new SimpleDateFormat(format);
        } else {
            this.sdf = (SimpleDateFormat)sdf.clone();
            this.sdf.applyPattern(format);
        }
    }

    public String format(Date date) {
        return this.sdf.format(date);
    }

    public String format(Object obj) throws IllegalArgumentException {
        if (!(obj instanceof Date)) {
            throw new IllegalArgumentException("expected Date");
        }
        return this.format((Date)obj);
    }
}

