/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.errorhandling;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ExceptionUtils {
    protected ExceptionUtils() {
    }

    public static String getMessage(ResourceBundle bundle, String key, String defaultMessage) {
        if (bundle == null || key == null) {
            return defaultMessage;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException mre) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return defaultMessage;
    }

    public static String getMessage(ResourceBundle bundle, String appCode, String moduleCode, String errorCode) {
        int lastNonEmptyNull = 0;
        if (errorCode != null && errorCode.length() != 0) {
            lastNonEmptyNull = 2;
        } else if (moduleCode != null && moduleCode.length() != 0) {
            lastNonEmptyNull = 1;
        }
        StringBuffer keyBuffer = new StringBuffer();
        if (appCode != null && appCode.length() != 0) {
            keyBuffer.append(appCode);
            if (lastNonEmptyNull > 0) {
                keyBuffer.append("-");
            }
        }
        if (moduleCode != null && moduleCode.length() != 0) {
            keyBuffer.append(moduleCode);
            if (lastNonEmptyNull > 1) {
                keyBuffer.append("-");
            }
        }
        if (errorCode != null && errorCode.length() != 0) {
            keyBuffer.append(errorCode);
        }
        String key = keyBuffer.toString();
        String message = ExceptionUtils.getMessage(bundle, key, key);
        StringBuffer resultBuffer = new StringBuffer();
        if (key.length() != 0) {
            resultBuffer.append(key);
            if (message.length() != 0) {
                resultBuffer.append(": ");
            }
        }
        if (message.length() != 0) {
            resultBuffer.append(message);
        }
        return key.equals(message) ? key : resultBuffer.toString();
    }

    public static void checkNull(Object item, ResourceBundle bundle, String key, String defaultMessage) {
        if (item != null) {
            return;
        }
        throw new IllegalArgumentException(ExceptionUtils.getMessage(bundle, key, defaultMessage));
    }

    public static void checkNullOrEmpty(String item, ResourceBundle bundle, String key, String defaultMessage) {
        if (item != null && item.trim().length() > 0) {
            return;
        }
        throw new IllegalArgumentException(ExceptionUtils.getMessage(bundle, key, defaultMessage));
    }
}

