/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.collection.typesafeenum;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Enum
implements Comparable,
Serializable {
    private static final Map enumsByClass = Collections.synchronizedMap(new HashMap());
    private static final Map stringSearchByClass = Collections.synchronizedMap(new HashMap());
    private static final Map nameSearchByClass = Collections.synchronizedMap(new HashMap());
    private static final Map enumNamesByClass = Collections.synchronizedMap(new HashMap());
    private final int ordinal;
    private final Class declaringClass;
    static /* synthetic */ Class class$com$topcoder$util$collection$typesafeenum$Enum;

    protected Enum() {
        this.ordinal = this.init(this.getClass());
        this.declaringClass = this.getClass();
    }

    protected Enum(Class declaringClass) {
        Enum.validateEnumClass(declaringClass);
        this.ordinal = this.init(declaringClass);
        this.declaringClass = declaringClass;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEnumName() throws IllegalAccessException {
        String ret;
        List allEnums = (List)enumsByClass.get(this.declaringClass);
        Hashtable<Object, String> instanceToName = (Hashtable<Object, String>)enumNamesByClass.get(this.declaringClass);
        if (instanceToName == null) {
            Map map = enumNamesByClass;
            synchronized (map) {
                if (enumNamesByClass.containsKey(this.declaringClass)) {
                    instanceToName = (Map)enumNamesByClass.get(this.declaringClass);
                } else {
                    instanceToName = new Hashtable<Object, String>(allEnums.size());
                    enumNamesByClass.put(this.declaringClass, instanceToName);
                }
            }
        }
        if ((ret = (String)instanceToName.get(this)) != null) {
            return ret;
        }
        Hashtable<Object, String> hashtable = instanceToName;
        synchronized (hashtable) {
            if (instanceToName.size() != allEnums.size()) {
                Field[] fields = this.declaringClass.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    try {
                        Object value = fields[i].get(null);
                        if (!(value instanceof Enum) || ((Enum)value).getDeclaringClass() != this.declaringClass) continue;
                        instanceToName.put(value, fields[i].getName());
                        continue;
                    }
                    catch (NullPointerException e) {
                        // empty catch block
                    }
                }
            }
        }
        return (String)instanceToName.get(this);
    }

    public static Enum getEnumByOrdinal(int ordinal, Class enumClass) {
        Enum.validateEnumClass(enumClass);
        List allEnums = (List)enumsByClass.get(enumClass);
        if (allEnums == null) {
            return null;
        }
        if (ordinal >= allEnums.size() || ordinal < 0) {
            return null;
        }
        return (Enum)allEnums.get(ordinal);
    }

    public static Enum getEnumByStringValue(String stringValue, Class enumClass) {
        if (stringValue == null) {
            throw new IllegalArgumentException("Argument [stringValue] should not be null.");
        }
        try {
            return Enum.getEnum(stringValue, enumClass, false);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static Enum getEnumByName(String name, Class enumClass) throws IllegalAccessException {
        if (name == null) {
            throw new IllegalArgumentException("Argument [name] should not be null.");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("Argument [name] should not be empty (trimed).");
        }
        return Enum.getEnum(name, enumClass, true);
    }

    public static List getEnumList(Class enumClass) {
        Enum.validateEnumClass(enumClass);
        List allEnums = (List)enumsByClass.get(enumClass);
        if (allEnums == null) {
            return Collections.unmodifiableList(new ArrayList());
        }
        ArrayList retList = new ArrayList(allEnums);
        Collections.sort(retList);
        return Collections.unmodifiableList(retList);
    }

    public int compareTo(Object o) {
        if (!(o instanceof Enum) || ((Enum)o).declaringClass != this.declaringClass) {
            throw new ClassCastException("Unable to compare Enum for different types.");
        }
        int ret = this.ordinal - ((Enum)o).ordinal;
        return ret == 0 ? 0 : (ret < 0 ? -1 : 1);
    }

    protected final Object readResolve() {
        try {
            return Enum.getEnumByOrdinal(this.ordinal, this.declaringClass);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int init(Class declaringClass) {
        Map map = enumsByClass;
        synchronized (map) {
            if (!enumsByClass.containsKey(declaringClass)) {
                enumsByClass.put(declaringClass, new ArrayList());
            }
        }
        List allEnums = (List)enumsByClass.get(declaringClass);
        allEnums.add(this);
        return allEnums.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Enum getEnum(String key, Class enumClass, boolean byName) throws IllegalAccessException {
        Enum ret;
        Enum.validateEnumClass(enumClass);
        List allEnums = (List)enumsByClass.get(enumClass);
        if (allEnums == null) {
            return null;
        }
        Map nameOrStringearchByClass = byName ? nameSearchByClass : stringSearchByClass;
        Hashtable<String, Enum> searchTable = (Hashtable<String, Enum>)nameOrStringearchByClass.get(enumClass);
        if (searchTable == null) {
            Map map = nameOrStringearchByClass;
            synchronized (map) {
                if (nameOrStringearchByClass.containsKey(enumClass)) {
                    searchTable = (Map)nameOrStringearchByClass.get(enumClass);
                } else {
                    searchTable = new Hashtable<String, Enum>(allEnums.size());
                    nameOrStringearchByClass.put(enumClass, searchTable);
                }
            }
        }
        if ((ret = (Enum)searchTable.get(key)) != null) {
            return ret;
        }
        Hashtable<String, Enum> hashtable = searchTable;
        synchronized (hashtable) {
            if (searchTable.size() != allEnums.size()) {
                Iterator itr = allEnums.iterator();
                while (itr.hasNext()) {
                    Enum elem = (Enum)itr.next();
                    String elemKey = byName ? elem.getEnumName() : elem.toString();
                    if (elemKey == null) continue;
                    searchTable.put(elemKey, elem);
                }
            }
        }
        return (Enum)searchTable.get(key);
    }

    private static final void validateEnumClass(Class enumClass) {
        if (enumClass == null) {
            throw new IllegalArgumentException("Argument [enumClass] should not be null.");
        }
        if (!(class$com$topcoder$util$collection$typesafeenum$Enum == null ? (class$com$topcoder$util$collection$typesafeenum$Enum = Enum.class$("com.topcoder.util.collection.typesafeenum.Enum")) : class$com$topcoder$util$collection$typesafeenum$Enum).isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("Argument [enumClass] is not a subclass of Enum.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

