/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.log.log4j;

import com.topcoder.util.log.AbstractLog;
import com.topcoder.util.log.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Log4jLog
extends AbstractLog {
    private final boolean useLoggerLayout;
    private final Logger logger;

    Log4jLog(String name, boolean useLoggerLayout) {
        super(name);
        this.logger = name == null ? Logger.getRootLogger() : Logger.getLogger((String)name);
        this.useLoggerLayout = useLoggerLayout;
    }

    public final boolean isEnabled(Level level) {
        if (level == null) {
            return false;
        }
        return this.logger.isEnabledFor((Priority)this.getLog4jEquivalentLevel(level));
    }

    public void log(Level level, Object message) {
        this.log(level, (Throwable)null, message);
    }

    public void log(Level level, Throwable t, Object message) {
        if (this.useLoggerLayout) {
            this.logMessage(level, t, message);
            return;
        }
        super.log(level, t, message);
    }

    protected final void log(Level level, Throwable t, String message) {
        this.logMessage(level, t, message);
    }

    private final org.apache.log4j.Level getLog4jEquivalentLevel(Level level) {
        if (level.equals((Object)Level.FINEST)) {
            return org.apache.log4j.Level.TRACE;
        }
        if (level.equals((Object)Level.TRACE)) {
            return org.apache.log4j.Level.TRACE;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return org.apache.log4j.Level.DEBUG;
        }
        if (level.equals((Object)Level.CONFIG)) {
            return org.apache.log4j.Level.INFO;
        }
        if (level.equals((Object)Level.INFO)) {
            return org.apache.log4j.Level.INFO;
        }
        if (level.equals((Object)Level.WARN)) {
            return org.apache.log4j.Level.WARN;
        }
        if (level.equals((Object)Level.ERROR)) {
            return org.apache.log4j.Level.ERROR;
        }
        if (level.equals((Object)Level.FATAL)) {
            return org.apache.log4j.Level.FATAL;
        }
        if (level.equals((Object)Level.ALL)) {
            return org.apache.log4j.Level.ALL;
        }
        if (level.equals((Object)Level.OFF)) {
            return org.apache.log4j.Level.OFF;
        }
        return null;
    }

    private void logMessage(Level level, Throwable t, Object message) {
        if (level == null || level.equals((Object)Level.OFF)) {
            return;
        }
        org.apache.log4j.Level log4jLevel = this.getLog4jEquivalentLevel(level);
        if (log4jLevel == null) {
            return;
        }
        this.logger.log((Priority)log4jLevel, message, t);
    }
}

