/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.log.jdk14;

import com.topcoder.util.log.AbstractLog;
import com.topcoder.util.log.Level;
import java.util.logging.Logger;

public class Jdk14Log
extends AbstractLog {
    private final Logger logger;

    Jdk14Log(String name) {
        super(name);
        if (name == null) {
            name = "";
        }
        this.logger = Logger.getLogger(name);
    }

    public final boolean isEnabled(Level level) {
        if (level == null) {
            return false;
        }
        return this.logger.isLoggable(this.getJdk14EquivalentLevel(level));
    }

    public void log(Level level, String messageFormat, Object arg1) {
        this.log(level, messageFormat, new Object[]{arg1});
    }

    public void log(Level level, String messageFormat, Object[] args) {
        if (messageFormat == null) {
            return;
        }
        java.util.logging.Level jdkLevel = this.getJdk14Level(level);
        if (jdkLevel == null) {
            return;
        }
        this.logger.log(jdkLevel, messageFormat, args);
    }

    protected final void log(Level level, Throwable t, String message) {
        if (message == null) {
            return;
        }
        java.util.logging.Level jdkLevel = this.getJdk14Level(level);
        if (jdkLevel == null) {
            return;
        }
        if (t == null) {
            this.logger.log(jdkLevel, message);
        } else {
            this.logger.log(jdkLevel, message, t);
        }
    }

    private final java.util.logging.Level getJdk14EquivalentLevel(Level level) {
        if (level.equals((Object)Level.FINEST)) {
            return java.util.logging.Level.FINEST;
        }
        if (level.equals((Object)Level.TRACE)) {
            return java.util.logging.Level.FINER;
        }
        if (level.equals((Object)Level.DEBUG)) {
            return java.util.logging.Level.FINE;
        }
        if (level.equals((Object)Level.CONFIG)) {
            return java.util.logging.Level.CONFIG;
        }
        if (level.equals((Object)Level.INFO)) {
            return java.util.logging.Level.INFO;
        }
        if (level.equals((Object)Level.WARN)) {
            return java.util.logging.Level.WARNING;
        }
        if (level.equals((Object)Level.ERROR)) {
            return java.util.logging.Level.SEVERE;
        }
        if (level.equals((Object)Level.FATAL)) {
            return java.util.logging.Level.SEVERE;
        }
        if (level.equals((Object)Level.ALL)) {
            return java.util.logging.Level.ALL;
        }
        if (level.equals((Object)Level.OFF)) {
            return java.util.logging.Level.OFF;
        }
        return null;
    }

    private java.util.logging.Level getJdk14Level(Level level) {
        if (level == null || level.equals((Object)Level.OFF)) {
            return null;
        }
        return this.getJdk14EquivalentLevel(level);
    }
}

