/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.log;

import com.topcoder.util.format.ObjectFormatter;
import com.topcoder.util.format.ObjectFormatterFactory;
import com.topcoder.util.log.Log;
import com.topcoder.util.log.LogException;
import com.topcoder.util.log.LogFactory;
import com.topcoder.util.log.basic.BasicLogFactory;

public class LogManager {
    public static final String DEFAULT_NAME = "SystemLog";
    private static final ObjectFormatter OBJECT_FORMATTER = ObjectFormatterFactory.getPlainFormatter();
    private static LogFactory logFactory = new BasicLogFactory();

    private LogManager() {
    }

    public static final void setLogFactory(LogFactory logFactory) {
        if (logFactory == null) {
            throw new IllegalArgumentException("logFactory should not be null.");
        }
        LogManager.logFactory = logFactory;
    }

    public static ObjectFormatter getObjectFormatter() {
        return OBJECT_FORMATTER;
    }

    public static final Log getLog() {
        return LogManager.getLog(DEFAULT_NAME);
    }

    public static final Log getLog(String name) {
        try {
            return LogManager.getLogWithExceptions(name);
        }
        catch (LogException e) {
            System.err.println("An error occurred while trying to retrieve the " + name + " log:");
            e.printStackTrace();
            System.err.println("The BasicLogFactory will be used instead.");
            return new BasicLogFactory().createLog(name);
        }
    }

    public static final Log getLogWithExceptions() throws LogException {
        return LogManager.getLogWithExceptions(DEFAULT_NAME);
    }

    public static final Log getLogWithExceptions(String name) throws LogException {
        try {
            return logFactory.createLog(name);
        }
        catch (LogException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LogException("Exception occurs while creating a Log instance using LogFactory.", e);
        }
    }
}

