/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.log;

import com.topcoder.util.collection.typesafeenum.Enum;
import java.util.HashMap;
import java.util.Map;

public final class Level
extends Enum {
    private static final int OFF_LEVEL = 0;
    private static final int FINEST_LEVEL = 100;
    private static final int TRACE_LEVEL = 200;
    private static final int DEBUG_LEVEL = 300;
    private static final int CONFIG_LEVEL = 400;
    private static final int INFO_LEVEL = 500;
    private static final int WARN_LEVEL = 600;
    private static final int ERROR_LEVEL = 700;
    private static final int FATAL_LEVEL = 800;
    private static final int ALL_LEVEL = 900;
    private static final String[] LEVEL_NAMES = new String[]{"OFF", "FINEST", "TRACE", "DEBUG", "CONFIG", "INFO", "WARN", "ERROR", "FATAL", "ALL"};
    private static final int[] LEVEL_VALUES = new int[]{0, 100, 200, 300, 400, 500, 600, 700, 800, 900};
    public static final Level OFF = new Level(0);
    public static final Level FINEST = new Level(100);
    public static final Level TRACE = new Level(200);
    public static final Level DEBUG = new Level(300);
    public static final Level CONFIG = new Level(400);
    public static final Level INFO = new Level(500);
    public static final Level WARN = new Level(600);
    public static final Level ERROR = new Level(700);
    public static final Level FATAL = new Level(800);
    public static final Level ALL = new Level(900);
    private static final Level[] LEVELS = new Level[]{OFF, FINEST, TRACE, DEBUG, CONFIG, INFO, WARN, ERROR, FATAL, ALL};
    private static final Map LEVEL_MAP = new HashMap();
    private final int level;

    private Level(int level) {
        this.level = level;
    }

    public final int intValue() {
        return this.level;
    }

    public final boolean equals(Object level) {
        if (level == this) {
            return true;
        }
        if (!(level instanceof Level)) {
            return false;
        }
        Level comparisonLevel = (Level)((Object)level);
        return comparisonLevel.intValue() == this.level;
    }

    public final int hashCode() {
        return this.level;
    }

    public final String toString() {
        if (this == OFF) {
            return "OFF";
        }
        if (this == FINEST) {
            return "FINEST";
        }
        if (this == TRACE) {
            return "TRACE";
        }
        if (this == DEBUG) {
            return "DEBUG";
        }
        if (this == CONFIG) {
            return "CONFIG";
        }
        if (this == INFO) {
            return "INFO";
        }
        if (this == WARN) {
            return "WARN";
        }
        if (this == ERROR) {
            return "ERROR";
        }
        if (this == FATAL) {
            return "FATAL";
        }
        if (this == ALL) {
            return "ALL";
        }
        return "INVALID LEVEL";
    }

    public static Level parseLevel(String level) {
        if (level == null) {
            return null;
        }
        if ((level = level.trim()).length() == 0) {
            return null;
        }
        try {
            int value = Integer.parseInt(level);
            return (Level)((Object)LEVEL_MAP.get(new Integer(value)));
        }
        catch (NumberFormatException e) {
            return (Level)((Object)LEVEL_MAP.get(level.toUpperCase()));
        }
    }

    static {
        for (int i = 0; i < LEVEL_VALUES.length; ++i) {
            LEVEL_MAP.put(new Integer(LEVEL_VALUES[i]), LEVELS[i]);
            LEVEL_MAP.put(LEVEL_NAMES[i], LEVELS[i]);
        }
    }
}

