/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.log;

import com.topcoder.util.format.ObjectFormatter;
import com.topcoder.util.log.Level;
import com.topcoder.util.log.Log;
import com.topcoder.util.log.LogManager;
import java.text.MessageFormat;

public abstract class AbstractLog
implements Log {
    private static final String NULL = "null";
    private final String name;

    protected AbstractLog(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void log(Level level, Object message) {
        this.log(level, (Throwable)null, message, LogManager.getObjectFormatter());
    }

    public void log(Level level, Object message, ObjectFormatter objectFormatter) {
        this.log(level, (Throwable)null, message, objectFormatter);
    }

    public void log(Level level, String messageFormat, Object arg1) {
        this.log(level, (Throwable)null, messageFormat, new Object[]{arg1});
    }

    public void log(Level level, String messageFormat, Object arg1, Object arg2) {
        this.log(level, (Throwable)null, messageFormat, new Object[]{arg1, arg2});
    }

    public void log(Level level, String messageFormat, Object arg1, Object arg2, Object arg3) {
        this.log(level, (Throwable)null, messageFormat, new Object[]{arg1, arg2, arg3});
    }

    public void log(Level level, String messageFormat, Object[] args) {
        this.log(level, (Throwable)null, messageFormat, args);
    }

    public void log(Level level, Throwable cause, Object message) {
        this.log(level, cause, message, LogManager.getObjectFormatter());
    }

    public void log(Level level, Throwable cause, Object message, ObjectFormatter objectFormatter) {
        if (!this.isEnabled(level)) {
            return;
        }
        if (objectFormatter == null) {
            objectFormatter = LogManager.getObjectFormatter();
        }
        String formattedMessage = null;
        if (message != null) {
            try {
                formattedMessage = objectFormatter.format(message);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (formattedMessage == null) {
                formattedMessage = message.toString();
            }
        } else {
            formattedMessage = NULL;
        }
        this.log(level, cause, formattedMessage);
    }

    public void log(Level level, Throwable cause, String messageFormat, Object arg1) {
        this.log(level, cause, messageFormat, new Object[]{arg1});
    }

    public void log(Level level, Throwable cause, String messageFormat, Object arg1, Object arg2) {
        this.log(level, cause, messageFormat, new Object[]{arg1, arg2});
    }

    public void log(Level level, Throwable cause, String messageFormat, Object arg1, Object arg2, Object arg3) {
        this.log(level, cause, messageFormat, new Object[]{arg1, arg2, arg3});
    }

    public void log(Level level, Throwable cause, String messageFormat, Object[] args) {
        if (messageFormat == null || !this.isEnabled(level)) {
            return;
        }
        try {
            this.log(level, cause, MessageFormat.format(messageFormat, args));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    protected abstract void log(Level var1, Throwable var2, String var3);
}

