/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.management.phase;

import com.topcoder.management.phase.ConfigurationException;
import com.topcoder.management.phase.HandlerRegistryInfo;
import com.topcoder.management.phase.PhaseHandler;
import com.topcoder.management.phase.PhaseHandlingException;
import com.topcoder.management.phase.PhaseManagementException;
import com.topcoder.management.phase.PhaseManager;
import com.topcoder.management.phase.PhaseOperationEnum;
import com.topcoder.management.phase.PhasePersistence;
import com.topcoder.management.phase.PhasePersistenceException;
import com.topcoder.management.phase.PhaseStatusEnum;
import com.topcoder.management.phase.PhaseValidationException;
import com.topcoder.management.phase.PhaseValidator;
import com.topcoder.management.phase.validation.DefaultPhaseValidator;
import com.topcoder.project.phases.Phase;
import com.topcoder.project.phases.PhaseStatus;
import com.topcoder.project.phases.PhaseType;
import com.topcoder.project.phases.Project;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.errorhandling.BaseException;
import com.topcoder.util.idgenerator.IDGenerationException;
import com.topcoder.util.idgenerator.IDGenerator;
import com.topcoder.util.idgenerator.IDGeneratorFactory;
import com.topcoder.util.objectfactory.InvalidClassSpecificationException;
import com.topcoder.util.objectfactory.ObjectFactory;
import com.topcoder.util.objectfactory.SpecificationFactory;
import com.topcoder.util.objectfactory.impl.ConfigManagerSpecificationFactory;
import com.topcoder.util.objectfactory.impl.IllegalReferenceException;
import com.topcoder.util.objectfactory.impl.SpecificationConfigurationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public class DefaultPhaseManager
implements PhaseManager {
    private final Map handlers = new HashMap();
    private final PhasePersistence persistence;
    private final IDGenerator idGenerator;
    private PhaseValidator phaseValidator = new DefaultPhaseValidator();
    static /* synthetic */ Class class$java$lang$String;

    public DefaultPhaseManager(String namespace) throws ConfigurationException {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace must be a non-null string");
        }
        if (namespace.trim().length() == 0) {
            throw new IllegalArgumentException("namespace must be a non-empty string");
        }
        ConfigManager manager = ConfigManager.getInstance();
        try {
            String persistenceClass = manager.getString(namespace, "PhasePersistence.className");
            if (persistenceClass == null) {
                throw new ConfigurationException("PhasePersistence.className does not exist");
            }
            try {
                Class<?> pclass = Class.forName(persistenceClass);
                Constructor<?> ctor = pclass.getConstructor(class$java$lang$String == null ? (class$java$lang$String = DefaultPhaseManager.class$("java.lang.String")) : class$java$lang$String);
                this.persistence = (PhasePersistence)ctor.newInstance(namespace);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("no such class: " + persistenceClass, ex);
            }
            catch (NoSuchMethodException ex) {
                throw new ConfigurationException("class " + persistenceClass + " does not have the correct constructor", ex);
            }
            catch (IllegalAccessException ex) {
                throw new ConfigurationException("failed to instantiate persistence: " + persistenceClass, ex);
            }
            catch (InstantiationException ex) {
                throw new ConfigurationException("error instantiating class " + persistenceClass, ex);
            }
            catch (InvocationTargetException ex) {
                throw new ConfigurationException("error instantiating class " + persistenceClass, ex);
            }
            catch (ClassCastException ex) {
                throw new ConfigurationException("error casting persistence class " + persistenceClass, ex);
            }
            String validatorClass = manager.getString(namespace, "PhaseValidator.className");
            if (validatorClass != null) {
                try {
                    Class<?> vclass = Class.forName(validatorClass);
                    this.phaseValidator = (PhaseValidator)vclass.newInstance();
                }
                catch (ClassNotFoundException ex) {
                    throw new ConfigurationException("no such class: " + validatorClass, ex);
                }
                catch (IllegalAccessException ex) {
                    throw new ConfigurationException("failed to instantiate ID generator: " + validatorClass, ex);
                }
                catch (InstantiationException ex) {
                    throw new ConfigurationException("error instantiating class " + validatorClass, ex);
                }
                catch (ClassCastException ex) {
                    throw new ConfigurationException("error casting validator class " + validatorClass, ex);
                }
            }
            String idSequence = manager.getString(namespace, "Idgenerator.sequenceName");
            String idClass = manager.getString(namespace, "Idgenerator.className");
            this.idGenerator = this.instantiateIDGenerator(idSequence, idClass);
            String[] handlerNames = manager.getStringArray(namespace, "Handlers");
            if (handlerNames != null && handlerNames.length > 0) {
                String factoryNamespace = manager.getString(namespace, "ObjectFactoryNamespace");
                if (factoryNamespace == null || factoryNamespace.trim().length() == 0) {
                    throw new ConfigurationException("The namespace for object factory is missing.");
                }
                ObjectFactory factory = new ObjectFactory((SpecificationFactory)new ConfigManagerSpecificationFactory(factoryNamespace), "both");
                for (int i = 0; i < handlerNames.length; ++i) {
                    PhaseType type = (PhaseType)factory.createObject(this.getRequiredValue(namespace, handlerNames[i] + ".phaseType"));
                    PhaseOperationEnum op = this.getOperation(this.getRequiredValue(namespace, handlerNames[i] + ".operation"));
                    if (op == null) {
                        throw new ConfigurationException("There is an error in the configurations,operation is not set or set incorrectly. It should be one of start, end and cancel.");
                    }
                    PhaseHandler handler = (PhaseHandler)factory.createObject(this.getRequiredValue(namespace, handlerNames[i] + ".handler"));
                    this.registerHandler(handler, type, op);
                }
            }
        }
        catch (UnknownNamespaceException ex) {
            throw new ConfigurationException("no such namespace '" + namespace + "'", ex);
        }
        catch (SpecificationConfigurationException ex) {
            throw new ConfigurationException("bad specification in configurations", ex);
        }
        catch (IllegalReferenceException ex) {
            throw new ConfigurationException("illegal references", ex);
        }
        catch (InvalidClassSpecificationException ex) {
            throw new ConfigurationException("invalid class specification", ex);
        }
    }

    private PhaseOperationEnum getOperation(String name) {
        if (PhaseOperationEnum.START.getName().equals(name)) {
            return PhaseOperationEnum.START;
        }
        if (PhaseOperationEnum.END.getName().equals(name)) {
            return PhaseOperationEnum.END;
        }
        if (PhaseOperationEnum.CANCEL.getName().equals(name)) {
            return PhaseOperationEnum.CANCEL;
        }
        return null;
    }

    private String getRequiredValue(String namespace, String name) throws UnknownNamespaceException, ConfigurationException {
        ConfigManager manager = ConfigManager.getInstance();
        String value = manager.getString(namespace, name);
        if (value == null || value.trim().length() == 0) {
            throw new ConfigurationException("The '" + name + "' is required.");
        }
        return value;
    }

    public DefaultPhaseManager(PhasePersistence persistence, IDGenerator idGenerator) {
        if (persistence == null) {
            throw new IllegalArgumentException("persistence must be non-null");
        }
        if (idGenerator == null) {
            throw new IllegalArgumentException("idGenerator must be non-null");
        }
        this.persistence = persistence;
        this.idGenerator = idGenerator;
    }

    private IDGenerator instantiateIDGenerator(String idSequence, String idClass) throws ConfigurationException {
        if (idSequence == null) {
            throw new ConfigurationException("Idgenerator.sequenceName does not exist");
        }
        if (idClass == null) {
            throw new ConfigurationException("Idgenerator.className does not exist");
        }
        try {
            return IDGeneratorFactory.getIDGenerator((String)idSequence, (String)idClass);
        }
        catch (BaseException ex) {
            throw new ConfigurationException("failed to instantiate ID generator: " + idClass, ex);
        }
        catch (IllegalAccessException ex) {
            throw new ConfigurationException("failed to instantiate ID generator: " + idClass, ex);
        }
        catch (IllegalStateException ex) {
            throw new ConfigurationException("failed to instantiate ID generator: " + idClass, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationException("failed to instantiate ID generator: " + idClass, ex);
        }
        catch (NoSuchMethodException ex) {
            throw new ConfigurationException("class " + idClass + " does not have the correct constructor", ex);
        }
        catch (InvocationTargetException ex) {
            throw new ConfigurationException("error instantiating class " + idClass, ex);
        }
        catch (InstantiationException ex) {
            throw new ConfigurationException("class " + idClass + " does not have the correct constructor", ex);
        }
        catch (ClassCastException ex) {
            throw new ConfigurationException("error casting ID generator class " + idClass, ex);
        }
    }

    public void updatePhases(Project project, String operator) throws PhaseManagementException {
        int i;
        this.checkUpdatePhasesArguments(project, operator);
        Phase[] phases = project.getAllPhases();
        PhaseValidator validator = this.getPhaseValidator();
        if (validator != null) {
            for (i = 0; i < phases.length; ++i) {
                try {
                    validator.validate(phases[i]);
                    continue;
                }
                catch (PhaseValidationException ex) {
                    throw new PhaseManagementException("validation failure for phase " + phases[i].getId(), (Throwable)((Object)ex));
                }
            }
        }
        try {
            for (i = 0; i < phases.length; ++i) {
                if (!this.persistence.isNewPhase(phases[i])) continue;
                phases[i].setId(this.idGenerator.getNextID());
            }
            TreeSet<Phase> delete = new TreeSet<Phase>(new PhaseComparator());
            TreeSet<Phase> add = new TreeSet<Phase>(new PhaseComparator());
            TreeSet<Phase> update = new TreeSet<Phase>(new PhaseComparator());
            Project existingProject = this.getPhases(project.getId());
            if (existingProject != null) {
                Phase[] existingPhases = existingProject.getAllPhases();
                for (int i2 = 0; i2 < existingPhases.length; ++i2) {
                    delete.add(existingPhases[i2]);
                }
            }
            for (int i3 = 0; i3 < phases.length; ++i3) {
                if (delete.remove(phases[i3])) {
                    update.add(phases[i3]);
                    continue;
                }
                add.add(phases[i3]);
            }
            if (add.size() > 0) {
                this.persistence.createPhases(add.toArray(new Phase[0]), operator);
            }
            if (update.size() > 0) {
                this.persistence.updatePhases(update.toArray(new Phase[0]), operator);
            }
            if (delete.size() > 0) {
                this.persistence.deletePhases(delete.toArray(new Phase[0]));
            }
        }
        catch (IDGenerationException ex) {
            throw new PhaseManagementException("cannot generate phase IDs", ex);
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    private void checkUpdatePhasesArguments(Project project, String operator) {
        if (project == null) {
            throw new IllegalArgumentException("project must be non-null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator must be non-null");
        }
        if (operator.trim().length() == 0) {
            throw new IllegalArgumentException("operator must be non-empty");
        }
    }

    public Project getPhases(long project) throws PhaseManagementException {
        try {
            return this.persistence.getProjectPhases(project);
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    public Project[] getPhases(long[] projects) throws PhaseManagementException {
        if (projects == null) {
            throw new IllegalArgumentException("arguments to DefaultPhaseManager#getPhases must be non-null");
        }
        try {
            return this.persistence.getProjectPhases(projects);
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    public PhaseType[] getAllPhaseTypes() throws PhaseManagementException {
        try {
            return this.persistence.getAllPhaseTypes();
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    public PhaseStatus[] getAllPhaseStatuses() throws PhaseManagementException {
        try {
            return this.persistence.getAllPhaseStatuses();
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    public boolean canStart(Phase phase) throws PhaseHandlingException {
        if (phase == null) {
            throw new IllegalArgumentException("null argument to DefaultPhaseManager#canStart");
        }
        PhaseHandler handler = this.getPhaseHandler(phase, PhaseOperationEnum.START);
        if (handler != null) {
            return handler.canPerform(phase);
        }
        return phase.calcStartDate().compareTo(new Date()) <= 0;
    }

    public void start(Phase phase, String operator) throws PhaseManagementException {
        PhaseHandler handler;
        if (phase == null) {
            throw new IllegalArgumentException("phase must be non-null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator must be non-null");
        }
        if (operator.trim().length() == 0) {
            throw new IllegalArgumentException("operator must be non-empty");
        }
        if (phase.getPhaseType() != null && (handler = this.getPhaseHandler(phase, PhaseOperationEnum.START)) != null) {
            handler.perform(phase, operator);
        }
        phase.setPhaseStatus(new PhaseStatus((long)PhaseStatusEnum.OPEN.getId(), PhaseStatusEnum.OPEN.getName()));
        phase.setActualStartDate(new Date());
        Phase[] allPhases = phase.getProject().getAllPhases();
        this.recalculateScheduledDates(allPhases);
        try {
            this.persistence.updatePhases(allPhases, operator);
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    public boolean canEnd(Phase phase) throws PhaseHandlingException {
        if (phase == null) {
            throw new IllegalArgumentException("null argument to DefaultPhaseManager#canEnd");
        }
        PhaseHandler handler = this.getPhaseHandler(phase, PhaseOperationEnum.END);
        if (handler != null) {
            return handler.canPerform(phase);
        }
        return phase.calcEndDate().compareTo(new Date()) <= 0;
    }

    public void end(Phase phase, String operator) throws PhaseManagementException {
        PhaseHandler handler;
        if (phase == null) {
            throw new IllegalArgumentException("phase must be non-null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator must be non-null");
        }
        if (operator.trim().length() == 0) {
            throw new IllegalArgumentException("operator must be non-empty");
        }
        if (phase.getPhaseType() != null && (handler = this.getPhaseHandler(phase, PhaseOperationEnum.END)) != null) {
            handler.perform(phase, operator);
        }
        phase.setPhaseStatus(new PhaseStatus((long)PhaseStatusEnum.CLOSED.getId(), PhaseStatusEnum.CLOSED.getName()));
        phase.setActualEndDate(new Date());
        Phase[] allPhases = phase.getProject().getAllPhases();
        this.recalculateScheduledDates(allPhases);
        try {
            this.persistence.updatePhases(allPhases, operator);
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    public boolean canCancel(Phase phase) throws PhaseHandlingException {
        if (phase == null) {
            throw new IllegalArgumentException("null argument to DefaultPhaseManager#canCancel");
        }
        PhaseHandler handler = this.getPhaseHandler(phase, PhaseOperationEnum.CANCEL);
        if (handler != null) {
            return handler.canPerform(phase);
        }
        return true;
    }

    public void cancel(Phase phase, String operator) throws PhaseManagementException {
        PhaseHandler handler;
        if (phase == null) {
            throw new IllegalArgumentException("phase must be non-null");
        }
        if (operator == null) {
            throw new IllegalArgumentException("operator must be non-null");
        }
        if (operator.trim().length() == 0) {
            throw new IllegalArgumentException("operator must be non-empty");
        }
        if (phase.getPhaseType() != null && (handler = this.getPhaseHandler(phase, PhaseOperationEnum.CANCEL)) != null) {
            handler.perform(phase, operator);
        }
        phase.setPhaseStatus(new PhaseStatus((long)PhaseStatusEnum.CLOSED.getId(), PhaseStatusEnum.CLOSED.getName()));
        phase.setActualEndDate(new Date());
        Phase[] allPhases = phase.getProject().getAllPhases();
        this.recalculateScheduledDates(allPhases);
        try {
            this.persistence.updatePhases(allPhases, operator);
        }
        catch (PhasePersistenceException ex) {
            throw new PhaseManagementException("phase persistence error", (Throwable)((Object)ex));
        }
    }

    public void registerHandler(PhaseHandler handler, PhaseType type, PhaseOperationEnum operation) {
        if (handler == null) {
            throw new IllegalArgumentException("handler must be non-null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("operation must be non-null");
        }
        this.handlers.put(new HandlerRegistryInfo(type, operation), handler);
    }

    public PhaseHandler unregisterHandler(PhaseType type, PhaseOperationEnum operation) {
        if (type == null) {
            throw new IllegalArgumentException("type must be non-null");
        }
        if (operation == null) {
            throw new IllegalArgumentException("operation must be non-null");
        }
        return (PhaseHandler)this.handlers.remove(new HandlerRegistryInfo(type, operation));
    }

    public PhaseHandler[] getAllHandlers() {
        HashSet allHandlers = new HashSet(this.handlers.values());
        return allHandlers.toArray(new PhaseHandler[0]);
    }

    public HandlerRegistryInfo[] getHandlerRegistrationInfo(PhaseHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        HashSet hri = new HashSet();
        Iterator it = this.handlers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (entry.getValue() != handler) continue;
            hri.add(entry.getKey());
        }
        return hri.toArray(new HandlerRegistryInfo[0]);
    }

    public void setPhaseValidator(PhaseValidator phaseValidator) {
        if (phaseValidator == null) {
            throw new IllegalArgumentException("phase validator cannot be set to null");
        }
        this.phaseValidator = phaseValidator;
    }

    public PhaseValidator getPhaseValidator() {
        return this.phaseValidator;
    }

    private PhaseHandler getPhaseHandler(Phase phase, PhaseOperationEnum operation) {
        HandlerRegistryInfo hri = new HandlerRegistryInfo(phase.getPhaseType(), operation);
        return (PhaseHandler)this.handlers.get(hri);
    }

    private void recalculateScheduledDates(Phase[] allPhases) {
        for (int i = 0; i < allPhases.length; ++i) {
            Phase phase = allPhases[i];
            phase.setScheduledStartDate(phase.calcStartDate());
            phase.setScheduledEndDate(phase.calcEndDate());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class PhaseComparator
    implements Comparator {
        private PhaseComparator() {
        }

        public int compare(Object o1, Object o2) {
            long p2;
            long p1 = ((Phase)o1).getId();
            if (p1 < (p2 = ((Phase)o2).getId())) {
                return -1;
            }
            if (p1 > p2) {
                return 1;
            }
            return 0;
        }
    }
}

