/*
 * Copyright (C) 2011 TopCoder Inc., All Rights Reserved.
 */
package com.csstem.testing;

import java.util.Iterator;

import com.thoughtworks.selenium.DefaultSelenium;
import com.thoughtworks.selenium.Selenium;
import com.topcoder.util.config.ConfigManager;


/**
 * The Helper class for test.
 *
 * @author TCSDEVELOPER
 * @version 1.0
 */
public class TestHelper {
    /** The test config file. */
    private static final String TEST_CONFIG_FILE = "TestsConfig.xml";

    /**
     * <p>Represents the test namespace.</p>
     */
    private static final String TEST_NAMESPACE = "com.csstem.testing";

    /**
     * <p>Represents Domain type.</p>
     */
    private static final String INDEX = "index";

    /**
     * <p>Represents Browser type.</p>
     */
    private static final String BROWSER = "browser";

    /**
     * <p>Represents base context.</p>
     */
    private static final int PORT = 4444;

    /**
     * <p>Represents the parent username.</p>
     */
    private static final String PARENT_USERNAME = "parent_username";

    /**
     * <p>Represents the parent password.</p>
     */
    private static final String PARENT_PASSWORD = "parent_password";

    /**
     * <p>Represents the selenium timeout.</p>
     */
	private static final String TIMEOUT = "timeout";

    /**
     * <p>Represents the parent username.</p>
     */
    private static final String PARENT2_USERNAME = "parent2_username";

    /**
     * <p>Represents the parent password.</p>
     */
    private static final String PARENT2_PASSWORD = "parent2_password";

    /**
     * <p>Represents the parent username.</p>
     */
    private static final String PARENT3_USERNAME = "parent3_username";

    /**
     * <p>Represents the parent password.</p>
     */
    private static final String PARENT3_PASSWORD = "parent3_password";

    /**
     * <p>Represents the student username.</p>
     */
    private static final String STUDENT_USERNAME = "student_username";

    /**
     * <p>Represents the student password.</p>
     */
    private static final String STUDENT_PASSWORD = "student_password";

    /**
     * <p>Default constructor.</p>
     */
    private TestHelper() {
    }

    /**
     * To get the base index URL.
     *
     * @return base index url
     *
     * @throws Exception if any error occurred
     */
    static String getIndex() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, INDEX).toString();
    }

    /**
     * To get the base index URL.
     *
     * @return base index url
     *
     * @throws Exception if any error occurred
     */
    static String getBrowser() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, BROWSER).toString();
    }

    /**
     * To get the parent username.
     *
     * @return the parent username
     *
     * @throws Exception if any error occurred
     */
    static String getParentUsername() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, PARENT_USERNAME).toString();
    }

    /**
     * To get the parent password.
     *
     * @return the parent password
     *
     * @throws Exception if any error occurred
     */
    static String getParentPassword() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, PARENT_PASSWORD).toString();
    }

    /**
     * To get the parent username.
     *
     * @return the parent username
     *
     * @throws Exception if any error occurred
     */
    static String getParent2Username() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, PARENT2_USERNAME).toString();
    }

    /**
     * To get the parent password.
     *
     * @return the parent password
     *
     * @throws Exception if any error occurred
     */
    static String getParent2Password() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, PARENT2_PASSWORD).toString();
    }

    /**
     * To get the parent username.
     *
     * @return the parent username
     *
     * @throws Exception if any error occurred
     */
    static String getParent3Username() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, PARENT3_USERNAME).toString();
    }

    /**
     * To get the parent password.
     *
     * @return the parent password
     *
     * @throws Exception if any error occurred
     */
    static String getParent3Password() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, PARENT3_PASSWORD).toString();
    }

    /**
     * To get the student username.
     *
     * @return the student username
     *
     * @throws Exception if any error occurred
     */
    static String getStudentUsername() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, STUDENT_USERNAME).toString();
    }

    /**
     * To get the student password.
     *
     * @return the student password
     *
     * @throws Exception if any error occurred
     */
    static String getStudentPassword() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, STUDENT_PASSWORD).toString();
    }

    /**
     * To get the student username.
     *
     * @return the student username
     *
     * @throws Exception if any error occurred
     */
    static String getAuthorizedStudentUsername() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, "authorized_student_username").toString();
    }

    /**
     * To get the student password.
     *
     * @return the student password
     *
     * @throws Exception if any error occurred
     */
    static String getAuthorizedStudentPassword() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, "authorized_student_password").toString();
    }

    /**
     * To get the selenium timeout.
     *
     * @return the timeout
     *
     * @throws Exception if any error occurred
     */
    static String getTimeout() throws Exception {
        addConfig(TEST_CONFIG_FILE);

        ConfigManager cm = ConfigManager.getInstance();

        return cm.getProperty(TEST_NAMESPACE, TIMEOUT).toString();
    }

    /**
     * Get the index Page.
     *
     * @return the index page.
     *
     * @throws Exception if any error occurred
     */
    static Selenium getIndexPage() throws Exception {
        Selenium browser = new DefaultSelenium("localhost", PORT, getBrowser(), getIndex());
        browser.start();
        browser.open(getIndex());

        return browser;
    }

    /**
     * Login parent user.
     *
     * @param browser current selenium browser.
     * @return the index page with the logged in user.
     *
     * @throws Exception if any error occurred
     */
    static Selenium getLoggedInAsParent(Selenium browser) throws Exception {
        browser.click("link=Login");
        browser.type("userNameInput", TestHelper.getParentUsername());
        browser.type("passwordInput", TestHelper.getParentPassword());
        browser.click("//div[@id='loginBoxC']/div[1]/a[1]/span/span");
        browser.waitForPageToLoad(getTimeout());
        return browser;
    }

    /**
     * Login student user.
     *
     * @param browser current selenium browser.
     * @return the index page with the logged in user.
     *
     * @throws Exception if any error occurred
     */
    static Selenium getLoggedInAsStudent(Selenium browser) throws Exception {
        browser.click("link=Login");
        browser.type("userNameInput", TestHelper.getAuthorizedStudentUsername());
        browser.type("passwordInput", TestHelper.getAuthorizedStudentPassword());
        browser.click("//div[@id='loginBoxC']/div[1]/a[1]/span/span");
        browser.waitForPageToLoad(getTimeout());
        return browser;
    }

    /**
     * <p>Adds the config of given config file.</p>
     *
     * @param configFile the given config file.
     *
     * @throws Exception if any error occurred
     */
    private static void addConfig(final String configFile)
        throws Exception {
        clearConfig();

        ConfigManager configManager = ConfigManager.getInstance();
        configManager.add(configFile);
    }

    /**
     * <p>Clears the config.</p>
     *
     * @throws Exception if any error occurred
     */
    private static void clearConfig() throws Exception {
        ConfigManager cm = ConfigManager.getInstance();

        for (Iterator iter = cm.getAllNamespaces(); iter.hasNext();) {
            cm.removeNamespace((String) iter.next());
        }
    }
}
