/*
 * Copyright (C) 2011 TopCoder Inc., All Rights Reserved.
 */
package com.csstem.testing;

import com.thoughtworks.selenium.Selenium;


/**
 * Performance test for CS-Stem Parent module.
 *
 * @author TCSDEVELOPER
 * @version 1.0
 */
public class ParentPerformanceTests extends BaseStressTest {
    /** Represents the Selenium Instance. */
    private Selenium browser;

    /**
     * Sets up the testing environment.
     *
     * @throws Exception if any error occurs.
     */
    public void setUp() throws Exception {
        browser = TestHelper.getIndexPage();
        super.setUp();
    }

    /**
     * Tears down the testing environment.
     *
     * @throws Exception if any error occurs.
     */
    public void tearDown() throws Exception {
        browser.stop();
        super.tearDown();
    }

    /**
     * P1,P2: Performance tests of 10000 users accessing web pages.
     *
     * @throws Throwable if any error
     */
    public void testPerformanceTests1() throws Throwable {
        Thread[] thread = new Thread[testCount];

        for (int i = 0; i < testCount; i++) {
            thread[i] = new Thread() {
                        public void run() {
                            try {
                                long start = System.currentTimeMillis();
                                browser = TestHelper.getIndexPage();

                                long duration = System.currentTimeMillis() - start;
                                assertTrue("duration should within 2 seconds", duration < 12000);
                            } catch (Throwable e) {
                                lastError = e;
                            }
                        }
                    };
            thread[i].start();
        }

        for (int i = 0; i < testCount; i++) {
            // wait to end
            thread[i].join();
        }

        if (lastError != null) {
            throw lastError;
        }
    }

    /**
     * P4: Verify the high response speed of the application.
     *
     * @throws Exception if any error
     */
    public void testPerformanceTests2() throws Exception {
        long start = System.currentTimeMillis();
        browser = TestHelper.getIndexPage();

        long duration = System.currentTimeMillis() - start;
        assertTrue("duration should within 1 seconds", duration < 6000);
    }
}
