/*
 * Copyright (C) 2011 TopCoder Inc., All Rights Reserved.
 */
package com.csstem.testing;

import com.thoughtworks.selenium.Selenium;


/**
 * Integration test for CS-Stem Parent module.
 *
 * @author TCSDEVELOPER
 * @version 1.0
 */
public class ParentIntegrationTests extends BaseStressTest {
    /** Represents the Selenium Instance. */
    private Selenium browser;

    /**
     * Sets up the testing environment.
     *
     * @throws Exception if any error occurs.
     */
    public void setUp() throws Exception {
        browser = TestHelper.getIndexPage();
        super.setUp();
    }

    /**
     * Tears down the testing environment.
     *
     * @throws Exception if any error occurs.
     */
    public void tearDown() throws Exception {
        browser.stop();
        super.tearDown();
    }

    /**
     * I1-4: Verify the application is fine integrated.
     *
     * @throws Exception if any error
     */
    public void testPerformanceTests1() throws Exception {
        browser = TestHelper.getLoggedInAsParent(browser);
        assertTrue("user is not logged in", browser.isTextPresent("Welcome csstemford"));
    }
}
