/*
 * Copyright (C) 2011 TopCoder Inc., All Rights Reserved.
 */
package com.csstem.testing;

import junit.framework.TestCase;

/**
 * <p>
 * BaseStressTest class for the stress tests.
 * </p>
 * <p>
 * Thread safe: This class has no state, and thus it is thread safe.
 * </p>
 * 
 * @author TCSDEVELOPER
 * @version 1.0
 */
public class BaseStressTest extends TestCase {

    /** The test count. */
    protected static final int testCount = 10000;

    /** The last error occurred */
    protected Throwable lastError;

    /**
     * Initialize variables.
     * 
     * @throws Exception
     *             if anything goes wrong
     */
    public void setUp() throws Exception {
        lastError = null;
    }

    /**
     * Test Thread
     * @author TCSDEVLOPER
     */
    class TestThread extends Thread {
        private int index;

        /**
         * The constructor
         * @param index the thread index
         */
        public TestThread(int index) {
            super();
            this.index = index;
        }

        /**
         * Get the index.
         * @return the index
         */
        public int getIndex() {
            return index;
        }
    }
}
