/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.InclusiveByteRange;
import org.mortbay.http.MultiPartResponse;
import org.mortbay.http.ResourceCache;
import org.mortbay.http.handler.AbstractHttpHandler;
import org.mortbay.log.LogFactory;
import org.mortbay.util.CachedResource;
import org.mortbay.util.IO;
import org.mortbay.util.LogSupport;
import org.mortbay.util.Resource;
import org.mortbay.util.StringMap;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URI;

public class ResourceHandler
extends AbstractHttpHandler {
    private static Log log = LogFactory.getLog(ResourceHandler.class);
    private boolean _acceptRanges = true;
    private boolean _redirectWelcomeFiles;
    private String[] _methods = null;
    private String _allowed;
    private boolean _dirAllowed = true;
    private int _minGzipLength = -1;
    private StringMap _methodMap = new StringMap();

    public ResourceHandler() {
        this.setAllowedMethods(new String[]{"GET", "POST", "HEAD", "OPTIONS", "TRACE"});
    }

    public synchronized void start() throws Exception {
        super.start();
    }

    public void stop() throws InterruptedException {
        super.stop();
    }

    public String[] getAllowedMethods() {
        return this._methods;
    }

    public void setAllowedMethods(String[] methods) {
        StringBuffer b = new StringBuffer();
        this._methods = methods;
        this._methodMap.clear();
        for (int i = 0; i < methods.length; ++i) {
            this._methodMap.put(methods[i], (Object)methods[i]);
            if (i > 0) {
                b.append(',');
            }
            b.append(methods[i]);
        }
        this._allowed = b.toString();
    }

    public boolean isMethodAllowed(String method) {
        return this._methodMap.get(method) != null;
    }

    public String getAllowedString() {
        return this._allowed;
    }

    public boolean isDirAllowed() {
        return this._dirAllowed;
    }

    public void setDirAllowed(boolean dirAllowed) {
        this._dirAllowed = dirAllowed;
    }

    public boolean isAcceptRanges() {
        return this._acceptRanges;
    }

    public boolean getRedirectWelcome() {
        return this._redirectWelcomeFiles;
    }

    public void setRedirectWelcome(boolean redirectWelcome) {
        this._redirectWelcomeFiles = redirectWelcome;
    }

    public void setAcceptRanges(boolean ar) {
        this._acceptRanges = ar;
    }

    public int getMinGzipLength() {
        return this._minGzipLength;
    }

    public void setMinGzipLength(int minGzipLength) {
        this._minGzipLength = minGzipLength;
    }

    protected Resource getResource(String pathInContext) throws IOException {
        return this.getHttpContext().getResource(pathInContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        block21: {
            Resource resource = this.getResource(pathInContext);
            if (resource == null) {
                return;
            }
            if (!this.isMethodAllowed(request.getMethod())) {
                if (log.isDebugEnabled()) {
                    log.debug("Method not allowed: " + request.getMethod());
                }
                if (resource.exists()) {
                    this.setAllowHeader(response);
                    response.sendError(405);
                }
                return;
            }
            try {
                String method;
                if (log.isDebugEnabled()) {
                    log.debug("PATH=" + pathInContext + " RESOURCE=" + resource);
                }
                if ((method = request.getMethod()).equals("GET") || method.equals("POST") || method.equals("HEAD")) {
                    this.handleGet(request, response, pathInContext, pathParams, resource);
                    break block21;
                }
                if (method.equals("PUT")) {
                    this.handlePut(request, response, pathInContext, resource);
                    break block21;
                }
                if (method.equals("DELETE")) {
                    this.handleDelete(request, response, pathInContext, resource);
                    break block21;
                }
                if (method.equals("OPTIONS")) {
                    this.handleOptions(response, pathInContext);
                    break block21;
                }
                if (method.equals("MOVE")) {
                    this.handleMove(request, response, pathInContext, resource);
                    break block21;
                }
                if (method.equals("TRACE")) {
                    this.handleTrace(request, response);
                    break block21;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Unknown action:" + method);
                }
                try {
                    if (resource.exists()) {
                        response.sendError(501);
                    }
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
            }
            catch (IllegalArgumentException e) {
                LogSupport.ignore(log, e);
            }
            finally {
                if (resource != null && !(resource instanceof CachedResource)) {
                    resource.release();
                }
            }
        }
    }

    public void handleGet(HttpRequest request, HttpResponse response, String pathInContext, String pathParams, Resource resource) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Looking for " + resource);
        }
        if (resource != null && resource.exists()) {
            if (resource.isDirectory()) {
                if (!pathInContext.endsWith("/") && !pathInContext.equals("/")) {
                    log.debug("Redirect to directory/");
                    String q = request.getQuery();
                    StringBuffer buf = request.getRequestURL();
                    if (q != null && q.length() != 0) {
                        buf.append('?');
                        buf.append(q);
                    }
                    response.setField("Location", URI.addPaths(buf.toString(), "/"));
                    response.setStatus(302);
                    request.setHandled(true);
                    return;
                }
                String welcome = this.getHttpContext().getWelcomeFile(resource);
                if (welcome != null) {
                    String ipath = URI.addPaths(pathInContext, welcome);
                    if (this._redirectWelcomeFiles) {
                        ipath = URI.addPaths(this.getHttpContext().getContextPath(), ipath);
                        response.setContentLength(0);
                        response.sendRedirect(ipath);
                    } else {
                        URI uri = request.getURI();
                        uri.setPath(URI.addPaths(uri.getPath(), welcome));
                        this.getHttpContext().handle(ipath, pathParams, request, response);
                    }
                    return;
                }
                if (!this.passConditionalHeaders(request, response, resource)) {
                    return;
                }
                this.sendDirectory(request, response, resource, pathInContext.length() > 1);
            } else if (resource.exists()) {
                if (!this.passConditionalHeaders(request, response, resource)) {
                    return;
                }
                this.sendData(request, response, pathInContext, resource, true);
            } else {
                log.warn("Unknown file type");
            }
        }
    }

    private boolean passConditionalHeaders(HttpRequest request, HttpResponse response, Resource resource) throws IOException {
        if (!request.getMethod().equals("HEAD")) {
            ResourceCache.ResourceMetaData metaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
            if (metaData != null) {
                String ifms = request.getField("If-Modified-Since");
                String mdlm = metaData.getLastModified();
                if (ifms != null && mdlm != null && ifms.equals(mdlm)) {
                    response.setStatus(304);
                    request.setHandled(true);
                    return false;
                }
            }
            long date = 0L;
            date = request.getDateField("If-Unmodified-Since");
            if (date > 0L && resource.lastModified() / 1000L > date / 1000L) {
                response.sendError(412);
                return false;
            }
            date = request.getDateField("If-Modified-Since");
            if (date > 0L && resource.lastModified() / 1000L <= date / 1000L) {
                response.setStatus(304);
                request.setHandled(true);
                return false;
            }
        }
        return true;
    }

    void handlePut(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        boolean exists;
        if (log.isDebugEnabled()) {
            log.debug("PUT " + pathInContext + " in " + resource);
        }
        boolean bl = exists = resource != null && resource.exists();
        if (exists && !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        if (pathInContext.endsWith("/")) {
            if (!exists) {
                if (!resource.getFile().mkdirs()) {
                    response.sendError(403, "Directories could not be created");
                } else {
                    request.setHandled(true);
                    response.setStatus(201);
                    response.commit();
                }
            } else {
                request.setHandled(true);
                response.setStatus(200);
                response.commit();
            }
        } else {
            try {
                int toRead = request.getContentLength();
                InputStream in = request.getInputStream();
                OutputStream out = resource.getOutputStream();
                if (toRead >= 0) {
                    IO.copy(in, out, (long)toRead);
                } else {
                    IO.copy(in, out);
                }
                out.close();
                request.setHandled(true);
                response.setStatus(exists ? 200 : 201);
                response.commit();
            }
            catch (Exception ex) {
                log.warn("EXCEPTION ", ex);
                response.sendError(403, ex.getMessage());
            }
        }
    }

    void handleDelete(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("DELETE " + pathInContext + " from " + resource);
        }
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        try {
            if (resource.delete()) {
                response.setStatus(204);
            } else {
                response.sendError(403);
            }
            request.setHandled(true);
        }
        catch (SecurityException sex) {
            log.warn("EXCEPTION ", sex);
            response.sendError(403, sex.getMessage());
        }
    }

    void handleMove(HttpRequest request, HttpResponse response, String pathInContext, Resource resource) throws IOException {
        if (!resource.exists() || !this.passConditionalHeaders(request, response, resource)) {
            return;
        }
        String newPath = URI.canonicalPath(request.getField("New-uri"));
        if (newPath == null) {
            response.sendError(405, "Bad new uri");
            return;
        }
        String contextPath = this.getHttpContext().getContextPath();
        if (contextPath != null && !newPath.startsWith(contextPath)) {
            response.sendError(405, "Not in context");
            return;
        }
        try {
            String newInfo = newPath;
            if (contextPath != null) {
                newInfo = newInfo.substring(contextPath.length());
            }
            Resource newFile = this.getHttpContext().getBaseResource().addPath(newInfo);
            if (log.isDebugEnabled()) {
                log.debug("Moving " + resource + " to " + newFile);
            }
            resource.renameTo(newFile);
            response.setStatus(204);
            request.setHandled(true);
        }
        catch (Exception ex) {
            log.warn("EXCEPTION ", ex);
            this.setAllowHeader(response);
            response.sendError(405, "Error:" + ex);
            return;
        }
    }

    void handleOptions(HttpResponse response, String pathInContext) throws IOException {
        if ("*".equals(pathInContext)) {
            return;
        }
        this.setAllowHeader(response);
        response.commit();
    }

    void setAllowHeader(HttpResponse response) {
        response.setField("Allow", this.getAllowedString());
    }

    public void writeHeaders(HttpResponse response, Resource resource, long count) throws IOException {
        ResourceCache.ResourceMetaData metaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
        response.setContentType(metaData.getMimeType());
        if (count != -1L) {
            if (count == resource.length()) {
                response.setField("Content-Length", metaData.getLength());
            } else {
                response.setContentLength((int)count);
            }
        }
        response.setField("Last-Modified", metaData.getLastModified());
        if (this._acceptRanges && response.getHttpRequest().getDotVersion() > 0) {
            response.setField("Accept-Ranges", "bytes");
        }
    }

    public void sendData(HttpRequest request, HttpResponse response, String pathInContext, Resource resource, boolean writeHeaders) throws IOException {
        Enumeration reqRanges;
        long resLength = resource.length();
        Enumeration enumeration = reqRanges = request.getDotVersion() > 0 ? request.getFieldValues("Range") : null;
        if (!writeHeaders || reqRanges == null || !reqRanges.hasMoreElements()) {
            Resource gz;
            String accept;
            Resource data = resource;
            if (this._minGzipLength > 0 && (accept = request.getField("Accept-Encoding")) != null && resLength > (long)this._minGzipLength && !pathInContext.endsWith(".gz") && (gz = this.getHttpContext().getResource(pathInContext + ".gz")).exists() && accept.indexOf("gzip") >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("gzip=" + gz);
                }
                response.setField("Content-Encoding", "gzip");
                data = gz;
                resLength = data.length();
            }
            this.writeHeaders(response, resource, resLength);
            request.setHandled(true);
            OutputStream out = response.getOutputStream();
            data.writeTo(out, 0L, resLength);
            return;
        }
        List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, resLength);
        if (log.isDebugEnabled()) {
            log.debug("ranges: " + reqRanges + " == " + ranges);
        }
        if (ranges == null || ranges.size() == 0) {
            log.debug("no satisfiable ranges");
            this.writeHeaders(response, resource, resLength);
            response.setStatus(416);
            response.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(416)));
            response.setField("Content-Range", InclusiveByteRange.to416HeaderRangeString(resLength));
            OutputStream out = response.getOutputStream();
            resource.writeTo(out, 0L, resLength);
            request.setHandled(true);
            return;
        }
        if (ranges.size() == 1) {
            InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
            if (log.isDebugEnabled()) {
                log.debug("single satisfiable range: " + singleSatisfiableRange);
            }
            long singleLength = singleSatisfiableRange.getSize(resLength);
            this.writeHeaders(response, resource, singleLength);
            response.setStatus(206);
            response.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(206)));
            response.setField("Content-Range", singleSatisfiableRange.toHeaderRangeString(resLength));
            OutputStream out = response.getOutputStream();
            resource.writeTo(out, singleSatisfiableRange.getFirst(resLength), singleLength);
            request.setHandled(true);
            return;
        }
        ResourceCache.ResourceMetaData metaData = (ResourceCache.ResourceMetaData)resource.getAssociate();
        String encoding = metaData.getMimeType();
        MultiPartResponse multi = new MultiPartResponse(response);
        response.setStatus(206);
        response.setReason((String)HttpResponse.__statusMsg.get(TypeUtil.newInteger(206)));
        String ctp = request.containsField("Request-Range") ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
        response.setContentType(ctp + multi.getBoundary());
        InputStream in = resource instanceof CachedResource ? null : resource.getInputStream();
        OutputStream out = response.getOutputStream();
        long pos = 0L;
        for (int i = 0; i < ranges.size(); ++i) {
            InclusiveByteRange ibr = (InclusiveByteRange)ranges.get(i);
            String header = "Content-Range: " + ibr.toHeaderRangeString(resLength);
            if (log.isDebugEnabled()) {
                log.debug("multi range: " + encoding + " " + header);
            }
            multi.startPart(encoding, new String[]{header});
            long start = ibr.getFirst(resLength);
            long size = ibr.getSize(resLength);
            if (in != null) {
                if (start < pos) {
                    in.close();
                    in = resource.getInputStream();
                    pos = 0L;
                }
                if (pos < start) {
                    in.skip(start - pos);
                    pos = start;
                }
                IO.copy(in, out, size);
                pos += size;
                continue;
            }
            resource.writeTo(out, start, size);
        }
        if (in != null) {
            in.close();
        }
        multi.close();
        request.setHandled(true);
    }

    void sendDirectory(HttpRequest request, HttpResponse response, Resource resource, boolean parent) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        request.setHandled(true);
        if (log.isDebugEnabled()) {
            log.debug("sendDirectory: " + resource);
        }
        byte[] data = null;
        if (resource instanceof CachedResource) {
            data = ((CachedResource)resource).getCachedData();
        }
        if (data == null) {
            String base = URI.addPaths(request.getPath(), "/");
            String dir = resource.getListHTML(URI.encodePath(base), parent);
            if (dir == null) {
                response.sendError(403, "No directory");
                return;
            }
            data = dir.getBytes("UTF8");
            if (resource instanceof CachedResource) {
                ((CachedResource)resource).setCachedData(data);
            }
        }
        response.setContentType("text/html; charset=UTF8");
        response.setContentLength(data.length);
        if (request.getMethod().equals("HEAD")) {
            response.commit();
            return;
        }
        response.getOutputStream().write(data, 0, data.length);
        response.commit();
    }
}

