/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigParserException;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.PropConfigProperties;
import com.topcoder.util.config.Property;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLConfigProperties
extends ConfigProperties
implements ErrorHandler {
    private Document document = null;
    private URL source = null;
    private String namespace = null;
    private PrintWriter writer = null;

    private XMLConfigProperties() {
    }

    XMLConfigProperties(URL source, String namespace) throws ConfigParserException, IOException {
        this.source = source;
        this.namespace = namespace;
        this.load();
    }

    XMLConfigProperties(URL source) throws ConfigParserException, IOException {
        this.source = source;
        this.load();
    }

    static Enumeration getNamespaces(URL url) throws ConfigParserException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigParserException("Error occurred obtaining Document Builder Factory: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new ConfigParserException("The underlying parser does not support the requested features: " + e.getMessage());
        }
        Document doc = null;
        try {
            InputSource is = new InputSource(url.openStream());
            doc = builder.parse(is);
        }
        catch (SAXException saxe) {
            throw new ConfigParserException(saxe.getMessage());
        }
        catch (IOException ioe) {
            throw new ConfigParserException(ioe.getMessage());
        }
        Vector namespaceNodes = new Vector();
        XMLConfigProperties.traverseToGetNamespaceNodes(doc, namespaceNodes);
        Vector<String> namespaces = new Vector<String>();
        Enumeration enu = namespaceNodes.elements();
        while (enu.hasMoreElements()) {
            Attr value = ((Element)enu.nextElement()).getAttributeNode("name");
            if (value == null) {
                throw new ConfigParserException("incorrect xml format");
            }
            namespaces.add(value.getNodeValue());
        }
        return namespaces.elements();
    }

    protected static void traverseToGetNamespaceNodes(Node node, Vector namespaceNodes) {
        if (node.getNodeType() == 1 && node.getNodeName().equals("Config")) {
            namespaceNodes.add(node);
        } else {
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                XMLConfigProperties.traverseToGetNamespaceNodes(list.item(i), namespaceNodes);
            }
        }
    }

    void setDocument(Document doc) {
        this.document = doc;
    }

    Document getDocument() {
        return this.document;
    }

    private void updateProperty(Node node, Property property) {
        List comments = property.getComments();
        if (comments != null) {
            Iterator itr = comments.iterator();
            while (itr.hasNext()) {
                node.appendChild(this.document.createComment((String)itr.next()));
            }
        }
        String[] values = property.getValues();
        List subproperties = property.list();
        if (values != null && values.length > 0 || !subproperties.isEmpty()) {
            Element element = this.document.createElement("Property");
            element.setAttribute("name", property.getName());
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    Element value = this.document.createElement("Value");
                    value.appendChild(this.document.createTextNode(values[i]));
                    element.appendChild(value);
                }
            }
            Iterator itr = subproperties.iterator();
            while (itr.hasNext()) {
                this.updateProperty(element, (Property)itr.next());
            }
            node.appendChild(element);
        }
    }

    private void writeNormalized(String string) {
        block7: for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            switch (ch) {
                case '<': {
                    this.writer.print("&lt;");
                    continue block7;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block7;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block7;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    this.writer.print("&#");
                    this.writer.print(Integer.toString(ch));
                    this.writer.print(';');
                    continue block7;
                }
                default: {
                    this.writer.print(ch);
                }
            }
        }
    }

    private void writeProperty(Node node, int indent) {
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node;
                this.writer.println("<?xml version=\"1.0\"?>");
                if (document.getDoctype() != null) {
                    this.writeProperty(document.getDoctype(), 0);
                }
                if (document.getDocumentElement() == null) break;
                this.writeProperty(document.getDocumentElement(), 0);
                break;
            }
            case 10: {
                DocumentType doctype = (DocumentType)node;
                this.writer.print("<!DOCTYPE ");
                this.writer.print(doctype.getName());
                String publicId = doctype.getPublicId();
                String systemId = doctype.getSystemId();
                if (publicId != null) {
                    this.writer.print(" PUBLIC '");
                    this.writer.print(publicId);
                    this.writer.print("' '");
                    this.writer.print(systemId);
                    this.writer.print('\'');
                } else {
                    this.writer.print(" SYSTEM '");
                    this.writer.print(systemId);
                    this.writer.print('\'');
                }
                String internalSubset = doctype.getInternalSubset();
                if (internalSubset != null) {
                    this.writer.println(" [");
                    this.writer.print(internalSubset);
                    this.writer.print(']');
                }
                this.writer.println('>');
                break;
            }
            case 1: {
                for (int i = 0; i < indent; ++i) {
                    this.writer.print("    ");
                }
                this.writer.print('<');
                this.writer.print(node.getNodeName());
                NamedNodeMap map = node.getAttributes();
                for (int i = 0; i < map.getLength(); ++i) {
                    Attr attr = (Attr)map.item(i);
                    this.writer.print(' ');
                    this.writer.print(attr.getNodeName());
                    this.writer.print("=\"");
                    this.writeNormalized(attr.getNodeValue());
                    this.writer.print('\"');
                }
                this.writer.print('>');
                if (!node.getNodeName().equals("Value") && !node.getNodeName().equals("ListDelimiter")) {
                    this.writer.println();
                }
                for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
                    this.writeProperty(child, indent + 1);
                }
                if (!node.getNodeName().equals("Value") && !node.getNodeName().equals("ListDelimiter")) {
                    for (int i = 0; i < indent; ++i) {
                        this.writer.print("    ");
                    }
                }
                this.writer.print("</");
                this.writer.print(node.getNodeName());
                this.writer.println('>');
                break;
            }
            case 3: {
                Node parent = node.getParentNode();
                if (parent.getNodeType() != 1 || !parent.getNodeName().equals("Value") && !parent.getNodeName().equals("ListDelimiter")) break;
                this.writer.print(node.getNodeValue());
                break;
            }
            case 8: {
                if (this.namespace == null) {
                    this.writer.print("    ");
                } else {
                    this.writer.print("        ");
                }
                this.writer.print("<!--");
                this.writer.print(((Comment)node).getData());
                this.writer.println("-->");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() throws IOException {
        if (!this.source.getProtocol().equals("file")) {
            throw new UnsupportedOperationException("source is not a physical file");
        }
        Node node = this.getNamespaceRootNode(this.document);
        while (node.getFirstChild() != null) {
            node.removeChild(node.getFirstChild());
        }
        if (this.getListDelimiter() != ';') {
            Element delimiter = this.document.createElement("ListDelimiter");
            delimiter.appendChild(this.document.createTextNode("" + this.getListDelimiter()));
            node.appendChild(delimiter);
        }
        Iterator itr = this.getRoot().list().iterator();
        while (itr.hasNext()) {
            this.updateProperty(node, (Property)itr.next());
        }
        try {
            this.writer = new PrintWriter(new FileWriter(ConfigManager.decodeURL(this.source.getFile())));
            this.writeProperty(this.document, 0);
            Object var4_3 = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            throw throwable;
        }
    }

    private Node getNamespaceRootNode(Node node) throws ConfigParserException {
        if (node.getNodeType() == 1) {
            if (this.namespace == null) {
                if (node.getNodeName().equals("CMConfig")) {
                    return node;
                }
            } else if (node.getNodeName().equals("Config")) {
                Attr value = ((Element)node).getAttributeNode("name");
                if (value == null) {
                    throw new ConfigParserException("incorrect xml format");
                }
                if (value.getNodeValue().equals(this.namespace)) {
                    return node;
                }
            }
        }
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node ret = this.getNamespaceRootNode(list.item(i));
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    private void loadNode(Property root, Node node, String prefix) throws IOException {
        ArrayList<String> comments = new ArrayList<String>();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            node = list.item(i);
            if (node.getNodeType() == 8) {
                comments.add(((Comment)node).getData());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("Property")) {
                boolean nested = false;
                Attr value = ((Element)node).getAttributeNode("name");
                if (value == null) {
                    throw new ConfigParserException("incorrect xml format");
                }
                String key = prefix + value.getNodeValue();
                ArrayList<String> valueList = new ArrayList<String>();
                NodeList values = node.getChildNodes();
                for (int j = 0; j < values.getLength(); ++j) {
                    Node subNode = values.item(j);
                    if (subNode.getNodeType() == 8) {
                        comments.add(((Comment)subNode).getData());
                        continue;
                    }
                    if (subNode.getNodeType() != 1) continue;
                    if (subNode.getNodeName().equals("Property")) {
                        nested = true;
                        continue;
                    }
                    if (subNode.getNodeName().equals("Value")) {
                        Node text = subNode.getFirstChild();
                        if (text == null) {
                            valueList.add("");
                        } else if (text.getNodeType() == 3) {
                            valueList.addAll(PropConfigProperties.parseValueString(((Text)text).getData(), this.getListDelimiter()));
                        } else {
                            throw new ConfigParserException("invalid subnode");
                        }
                        if (text == null || text.getNextSibling() == null) continue;
                        throw new ConfigParserException("invalid subnode");
                    }
                    throw new ConfigParserException("unrecognized element " + subNode.getNodeName());
                }
                if (valueList.size() > 0) {
                    Property property = root.find(key);
                    if (property != null && property.getValue() != null) {
                        throw new ConfigParserException("contains duplicate property " + key);
                    }
                    root.setProperty(key, valueList.toArray(new String[valueList.size()]));
                    if (comments.size() > 0) {
                        property = root.find(key);
                        Iterator itr = comments.iterator();
                        while (itr.hasNext()) {
                            property.addComment((String)itr.next());
                        }
                        comments.clear();
                    }
                }
                if (!nested) continue;
                this.loadNode(root, node, key + ".");
                continue;
            }
            if (node.getNodeName().equals("ListDelimiter")) {
                String delim;
                Node text = node.getFirstChild();
                if (text == null) {
                    throw new ConfigParserException("invalid delimiter");
                }
                if (text.getNodeType() == 3) {
                    delim = ((Text)text).getData();
                    if (delim == null || delim.length() != 1) {
                        throw new ConfigParserException("invalid delimiter");
                    }
                } else {
                    throw new ConfigParserException("invalid delimiter");
                }
                this.setListDelimiter(delim.charAt(0));
                if (text.getNextSibling() == null) continue;
                throw new ConfigParserException("invalid subnode");
            }
            if (node.getNodeName().equals("Value")) continue;
            throw new ConfigParserException("unrecognized element " + node.getNodeName());
        }
    }

    protected void load() throws IOException {
        DocumentBuilderFactory factory = null;
        DocumentBuilder builder = null;
        try {
            factory = DocumentBuilderFactory.newInstance();
            builder = factory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError e) {
            throw new ConfigParserException("Error occurred obtaining Document Builder Factory: " + e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new ConfigParserException("The underlying parser does not support the requested features: " + e.getMessage());
        }
        builder.setErrorHandler(this);
        InputSource is = new InputSource(this.source.openStream());
        try {
            this.document = builder.parse(is);
        }
        catch (SAXException saxe) {
            throw new ConfigParserException(saxe.getMessage());
        }
        catch (IOException ioe) {
            throw new ConfigParserException(ioe.getMessage());
        }
        Node node = this.getNamespaceRootNode(this.document);
        if (node == null) {
            throw new ConfigParserException("can not locate namespace " + this.namespace);
        }
        try {
            Property root = new Property();
            this.loadNode(root, node, "");
            this.setRoot(root);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception exception) {
            throw new ConfigParserException(exception.getMessage());
        }
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println("warning : " + e.getMessage());
    }

    public void error(SAXParseException e) throws SAXException {
        System.err.println("error : " + e.getMessage());
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.err.println("fatal error : " + e.getMessage());
        throw e;
    }

    public Object clone() {
        XMLConfigProperties properties = new XMLConfigProperties();
        properties.source = this.source;
        properties.namespace = this.namespace;
        properties.document = this.document;
        properties.setRoot((Property)this.getRoot().clone());
        return properties;
    }
}

