/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.DuplicatePropertyException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class Property
implements Cloneable {
    private String name = null;
    private List comments = null;
    private List subproperties = null;
    private List values = null;
    private String value = null;
    private char separator = (char)61;

    char getSeparator() {
        return this.separator;
    }

    void setSeparator(char separator) {
        this.separator = separator;
    }

    public Property(String name) {
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        if (name.indexOf(46) != -1) {
            throw new IllegalArgumentException("parameter name is a compound name");
        }
        this.name = name;
        this.subproperties = new ArrayList();
        this.values = new ArrayList();
    }

    public Property(String name, String value) {
        this(name);
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        this.value = value;
    }

    public Property(String name, String[] values) {
        this(name);
        int i;
        if (values == null) {
            throw new NullPointerException("paramter values is null");
        }
        for (i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("parameter values contains a null entry");
        }
        if (values.length == 1) {
            this.value = values[0];
        } else {
            for (i = 0; i < values.length; ++i) {
                this.values.add(values[i]);
            }
        }
    }

    Property() {
        this.name = "";
        this.subproperties = new ArrayList();
        this.values = new ArrayList();
    }

    void addProperty(String name, String value) throws DuplicatePropertyException {
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        if (this.find(name) != null) {
            throw new DuplicatePropertyException("property " + name + " already exists");
        }
        this.create(name).setValue(value);
    }

    void addProperty(String name, String[] values) throws DuplicatePropertyException {
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        if (values == null) {
            throw new NullPointerException("parameter values is null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("parameter values contains no entry");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("parameter values contains null entry");
        }
        if (this.find(name) != null) {
            throw new DuplicatePropertyException("property " + name + " already exists");
        }
        this.create(name).setValues(values);
    }

    void addProperty(Property property) throws DuplicatePropertyException {
        if (property == null) {
            throw new NullPointerException("parameter property is null");
        }
        Iterator itr = this.subproperties.iterator();
        while (itr.hasNext()) {
            if (!((Property)itr.next()).name.equals(property.name)) continue;
            throw new DuplicatePropertyException("property " + this.name + " already exists");
        }
        this.subproperties.add(property);
    }

    void addValue(String value) {
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        if (this.value != null) {
            this.values.add(this.value);
            this.values.add(value);
            this.value = null;
        } else if (this.values.size() == 0) {
            this.value = value;
        } else {
            this.values.add(value);
        }
    }

    void removeProperty(String name) {
        Property property;
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        int lastPos = name.lastIndexOf(46);
        if (lastPos == -1) {
            property = this;
        } else {
            property = this.find(name.substring(0, lastPos));
            if (property == null) {
                return;
            }
        }
        name = name.substring(lastPos + 1);
        Iterator itr = property.subproperties.iterator();
        while (itr.hasNext()) {
            if (!((Property)itr.next()).name.equals(name)) continue;
            itr.remove();
        }
    }

    void removeValue(String value) {
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        if (this.value != null) {
            if (this.value.equals(value)) {
                this.value = null;
            }
        } else {
            this.values.remove(value);
            if (this.values.size() == 1) {
                this.value = (String)this.values.get(0);
                this.values.clear();
            }
        }
    }

    void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        this.value = value;
        this.values.clear();
    }

    void setValues(String[] values) {
        int i;
        if (values == null) {
            throw new NullPointerException("parameter values is null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("parameter values contains no entry");
        }
        for (i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("parameter values contains null entry");
        }
        this.value = null;
        this.values.clear();
        if (values.length == 1) {
            this.value = values[0];
        } else {
            for (i = 0; i < values.length; ++i) {
                this.values.add(values[i]);
            }
        }
    }

    void setProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (key.trim().length() == 0) {
            throw new IllegalArgumentException("parameter key is empty");
        }
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        Property property = this.find(key);
        if (property == null) {
            property = this.create(key);
        }
        property.setValue(value);
    }

    void setProperty(String key, String[] values) {
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (key.trim().length() == 0) {
            throw new IllegalArgumentException("parameter key is empty");
        }
        if (values == null) {
            throw new NullPointerException("parameter values is null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("parameter values contains no entry");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != null) continue;
            throw new NullPointerException("parameter values contains null entry");
        }
        Property property = this.find(key);
        if (property == null) {
            property = this.create(key);
        }
        property.setValues(values);
    }

    public boolean containsProperty(String property) {
        if (property == null) {
            throw new NullPointerException("parameter property is null");
        }
        if (property.trim().length() == 0) {
            return false;
        }
        return this.find(property) != null;
    }

    public boolean containsValue(String value) {
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        if (this.value != null) {
            return this.value.equals(value);
        }
        return this.values.contains(value);
    }

    public String getValue() {
        if (this.value != null) {
            return this.value;
        }
        if (this.values.size() > 0) {
            return (String)this.values.get(0);
        }
        return null;
    }

    public String getValue(String name) {
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        Property property = this.find(name);
        if (property == null) {
            return null;
        }
        return property.getValue();
    }

    public String[] getValues(String name) {
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        Property property = this.find(name);
        if (property == null) {
            return null;
        }
        return property.getValues();
    }

    public String[] getValues() {
        if (this.value != null) {
            return new String[]{this.value};
        }
        if (this.values.size() > 0) {
            return this.values.toArray(new String[this.values.size()]);
        }
        return null;
    }

    public Property getProperty(String name) {
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        return this.find(name);
    }

    public List list() {
        return new ArrayList(this.subproperties);
    }

    public Enumeration propertyNames() {
        Vector<String> names = new Vector<String>();
        Iterator itr = this.subproperties.iterator();
        while (itr.hasNext()) {
            names.add(((Property)itr.next()).name);
        }
        return names.elements();
    }

    Property find(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        Property property = this;
        while (tokenizer.hasMoreTokens()) {
            name = tokenizer.nextToken();
            boolean found = false;
            Iterator itr = property.subproperties.iterator();
            while (itr.hasNext()) {
                Property nextProp = (Property)itr.next();
                if (!nextProp.name.equals(name)) continue;
                property = nextProp;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return property;
    }

    private Property create(String name) {
        if (name == null) {
            throw new NullPointerException("parameter name is null");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("parameter name is empty");
        }
        StringTokenizer tokenizer = new StringTokenizer(name, ".");
        Property property = this;
        while (tokenizer.hasMoreTokens()) {
            name = tokenizer.nextToken();
            boolean found = false;
            Iterator itr = property.subproperties.iterator();
            while (itr.hasNext()) {
                Property nextProp = (Property)itr.next();
                if (!nextProp.name.equals(name)) continue;
                property = nextProp;
                found = true;
                break;
            }
            if (found) continue;
            Property newProp = new Property(name);
            try {
                property.addProperty(newProp);
            }
            catch (DuplicatePropertyException dpe) {
                // empty catch block
            }
            property = newProp;
        }
        return property;
    }

    public Object clone() {
        Property property = new Property();
        property.name = this.name;
        property.value = this.value;
        property.values = new ArrayList(this.values);
        property.subproperties = new ArrayList();
        Iterator itr = this.subproperties.iterator();
        while (itr.hasNext()) {
            property.subproperties.add(((Property)itr.next()).clone());
        }
        if (this.comments != null) {
            property.comments = new ArrayList(this.comments);
        }
        return property;
    }

    public void addComment(String comment) {
        if (comment == null) {
            throw new NullPointerException("parameter comment is null");
        }
        if (this.comments == null) {
            this.comments = new ArrayList();
        }
        this.comments.add(comment);
    }

    public void setComments(List comments) {
        if (comments == null) {
            this.comments = null;
        } else {
            Iterator itr = comments.iterator();
            while (itr.hasNext()) {
                if (itr.next() instanceof String) continue;
                throw new IllegalArgumentException("parameter comments contains non String entry");
            }
            this.comments = new ArrayList(comments);
        }
    }

    public List getComments() {
        if (this.comments == null) {
            return null;
        }
        return new ArrayList(this.comments);
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        return o instanceof Property && this.name.equals(((Property)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    String[] getProperties(String key, String defaultValue) {
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (key.trim().length() == 0) {
            throw new IllegalArgumentException("parameter key is empty");
        }
        if (defaultValue == null) {
            throw new NullPointerException("parameter defaultValue is null");
        }
        String[] values = this.getValues(key);
        if (values != null) {
            return values;
        }
        return new String[]{defaultValue};
    }
}

