/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigParserException;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.Property;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class PropConfigProperties
extends ConfigProperties {
    private static final int UNICODE_LENGTH = 4;
    private static final int HEX_LETTER_BASE = 10;
    private static final int HEX_BIT_COUNT = 4;
    private URL source = null;
    private PrintWriter writer = null;

    private PropConfigProperties() {
    }

    PropConfigProperties(URL source) throws IOException {
        this.source = source;
        this.load();
    }

    private void writeProperty(Property property, String key) {
        String[] values;
        key = key.equals("") ? property.getName() : key + "." + property.getName();
        List comments = property.getComments();
        if (comments != null) {
            Iterator itr = comments.iterator();
            while (itr.hasNext()) {
                this.writer.println(itr.next());
            }
        }
        if ((values = property.getValues()) != null && values.length > 0) {
            this.writer.print(key);
            this.writer.print(property.getSeparator());
            this.writer.println(PropConfigProperties.mergeEscaped(values, this.getListDelimiter()));
        }
        List subproperties = property.list();
        Iterator itr = subproperties.iterator();
        while (itr.hasNext()) {
            this.writeProperty((Property)itr.next(), key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() throws IOException {
        if (!this.source.getProtocol().equals("file")) {
            throw new UnsupportedOperationException("source is not a physical file");
        }
        try {
            this.writer = new PrintWriter(new FileWriter(ConfigManager.decodeURL(this.source.getFile())));
            if (this.getListDelimiter() != ';') {
                this.writer.print("ListDelimiter=");
                this.writer.println(this.getListDelimiter());
            }
            this.writeProperty(this.getRoot(), "");
            Object var2_1 = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void load() throws IOException {
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(this.source.openStream()));
                Property root = new Property();
                ArrayList<String> comments = new ArrayList<String>();
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                        this.setRoot(root);
                        break;
                    }
                    String trim = line.trim();
                    if (trim.length() == 0 || trim.charAt(0) == '#' || trim.charAt(0) == '!') {
                        comments.add(line);
                        continue;
                    }
                    int pos = PropConfigProperties.findDelimiter(line, '=');
                    if (pos == -1) {
                        pos = PropConfigProperties.findDelimiter(line, ':');
                    }
                    if (pos == -1) {
                        pos = PropConfigProperties.findDelimiter(line, ' ');
                    }
                    if (pos == -1) {
                        throw new ConfigParserException("unrecognized line : " + line);
                    }
                    String key = line.substring(0, pos);
                    if (key.equals("ListDelimiter")) {
                        String delim = line.substring(pos + 1);
                        if (delim.length() != 1) {
                            throw new ConfigParserException("invalid delimiter");
                        }
                        this.setListDelimiter(delim.charAt(0));
                        continue;
                    }
                    key = PropConfigProperties.parseString(key);
                    List valueList = PropConfigProperties.parseValueString(line.substring(pos + 1), this.getListDelimiter());
                    Property property = root.find(key);
                    if (property != null && property.getValue() != null) {
                        throw new ConfigParserException("contains duplicate property " + key);
                    }
                    root.setProperty(key, valueList.toArray(new String[valueList.size()]));
                    property = root.find(key);
                    property.setSeparator(line.charAt(pos));
                    if (comments.size() <= 0) continue;
                    Iterator itr = comments.iterator();
                    while (itr.hasNext()) {
                        property.addComment((String)itr.next());
                    }
                    comments.clear();
                }
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception exception) {
                throw new ConfigParserException(exception.getMessage());
            }
            Object var12_13 = null;
            if (reader == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (reader != null) {
                reader.close();
                reader = null;
            }
            throw throwable;
        }
        reader.close();
    }

    private static String parseString(String s) throws ConfigParserException {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                if (i + 1 >= s.length()) {
                    throw new ConfigParserException("Missing escaped character after '\\'.");
                }
                if ((ch = s.charAt(++i)) == 't') {
                    buffer.append('\t');
                    continue;
                }
                if (ch == 'r') {
                    buffer.append('\r');
                    continue;
                }
                if (ch == 'n') {
                    buffer.append('\n');
                    continue;
                }
                if (ch == 'u') {
                    if (i + 4 >= s.length()) {
                        throw new ConfigParserException("Invalid escape after '\\u'.");
                    }
                    String hexStr = s.substring(i + 1, i + 1 + 4);
                    i += 4;
                    buffer.append(PropConfigProperties.parseHexString(hexStr));
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private static int findDelimiter(String s, char delimiter) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (s.charAt(i) != delimiter) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private static char parseHexString(String s) throws ConfigParserException {
        s = s.trim().toLowerCase();
        int r = 0;
        for (int i = 0; i < s.length(); ++i) {
            void var3_3;
            int t;
            char ch = s.charAt(i);
            if (ch >= '0' && ch <= '9') {
                t = ch - 48;
            } else if (ch >= 'a' && ch <= 'f') {
                t = ch - 97 + 10;
            } else {
                throw new ConfigParserException("Invalid hex string.");
            }
            r = (r << 4) + var3_3;
        }
        return (char)r;
    }

    static List parseValueString(String value, char listDelimiter) throws ConfigParserException {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                if (i + 1 >= value.length()) {
                    throw new ConfigParserException("Missing escaped character after '\\'.");
                }
                ch = value.charAt(++i);
                String escapes = " !:=\\#";
                if (ch == listDelimiter || escapes.indexOf(ch) >= 0) {
                    buffer.append(ch);
                    continue;
                }
                if (ch == 't') {
                    buffer.append('\t');
                    continue;
                }
                if (ch == 'r') {
                    buffer.append('\r');
                    continue;
                }
                if (ch == 'n') {
                    buffer.append('\n');
                    continue;
                }
                if (ch == 'u') {
                    if (i + 4 >= value.length()) {
                        throw new ConfigParserException("Invalid escape after '\\u'.");
                    }
                    String hexStr = value.substring(i + 1, i + 1 + 4);
                    i += 4;
                    buffer.append(PropConfigProperties.parseHexString(hexStr));
                    continue;
                }
                throw new ConfigParserException("Invalid escape after '\\'.");
            }
            if (ch == listDelimiter) {
                list.add(buffer.toString());
                buffer.delete(0, buffer.length());
                continue;
            }
            buffer.append(ch);
        }
        list.add(buffer.toString());
        return list;
    }

    private static String mergeEscaped(String[] values, char listDelimiter) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                buffer.append(listDelimiter);
            }
            for (int k = 0; k < values[i].length(); ++k) {
                char ch = values[i].charAt(k);
                String escapes = " !:=\\#";
                if (ch == listDelimiter || escapes.indexOf(ch) >= 0) {
                    buffer.append('\\');
                    buffer.append(ch);
                    continue;
                }
                if (ch == '\n') {
                    buffer.append("\\n");
                    continue;
                }
                if (ch == '\r') {
                    buffer.append("\\r");
                    continue;
                }
                if (ch == '\t') {
                    buffer.append("\\t");
                    continue;
                }
                buffer.append(ch);
            }
        }
        return buffer.toString();
    }

    public Object clone() {
        PropConfigProperties properties = new PropConfigProperties();
        properties.source = this.source;
        properties.setRoot((Property)this.getRoot().clone());
        return properties;
    }
}

