/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigLockedException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.config.XMLConfigProperties;
import java.net.URL;
import java.util.Iterator;

class Namespace {
    private String name = null;
    private String format = null;
    private URL file = null;
    private int exceptionLevel = 0;
    private ConfigProperties properties = null;
    private boolean lock = false;
    private String user = null;

    Namespace(String namespace, URL url, String format, int exceptionLevel, ConfigProperties prop) {
        this.name = namespace;
        this.file = url;
        this.format = format;
        this.exceptionLevel = exceptionLevel;
        this.properties = prop;
    }

    String getName() {
        return this.name;
    }

    String getFormat() {
        return this.format;
    }

    URL getFile() {
        return this.file;
    }

    int getExceptionLevel() {
        return this.exceptionLevel;
    }

    ConfigProperties getProperties() {
        return this.properties;
    }

    void setProperties(ConfigProperties properties) {
        if (properties == null) {
            throw new NullPointerException("parameter properties is null");
        }
        this.properties = properties;
    }

    void lock(String newUser) throws ConfigLockedException, UnknownNamespaceException {
        if (this.lock && !this.user.equals(newUser)) {
            throw new ConfigLockedException(newUser + " can not lock namespace " + this.name);
        }
        ConfigManager cm = ConfigManager.getInstance();
        Iterator itr = cm.getAllNamespaces();
        while (itr.hasNext()) {
            String namespace = (String)itr.next();
            String filename = cm.getConfigFilename(namespace);
            if (!this.file.getFile().equals(filename) || cm.canLock(namespace, newUser)) continue;
            throw new ConfigLockedException("the source of " + this.name + " is already locked");
        }
        this.lock = true;
        this.user = newUser;
    }

    void releaseLock() {
        this.lock = false;
        this.user = null;
    }

    boolean canLock(String user) {
        return !this.lock || this.user.equals(user);
    }

    void setDocument(Namespace ns) {
        if ("MXML".equals(this.format) && "MXML".equals(ns.format)) {
            ((XMLConfigProperties)this.properties).setDocument(((XMLConfigProperties)ns.properties).getDocument());
        }
    }
}

