/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigLockedException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.Namespace;
import com.topcoder.util.config.NamespaceAlreadyExistsException;
import com.topcoder.util.config.PluggableConfigProperties;
import com.topcoder.util.config.PropConfigProperties;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownConfigFormatException;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.config.XMLConfigProperties;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

class DefaultConfigManager
extends ConfigManager {
    private Map namespaces = Collections.synchronizedMap(new HashMap());
    private Map tempProperties = Collections.synchronizedMap(new HashMap());

    DefaultConfigManager() {
    }

    public String getNamespace() {
        return "com.topcoder.util.config.ConfigManager";
    }

    public Enumeration getConfigPropNames() {
        return new Vector().elements();
    }

    /*
     * WARNING - void declaration
     */
    private void addURL(String namespace, URL url, String format, int exceptionLevel) throws ConfigManagerException {
        void var5_5;
        block7: {
            if (this.namespaces.containsKey(namespace)) {
                throw new NamespaceAlreadyExistsException(namespace + "already exists");
            }
            try {
                ConfigProperties cp;
                if (format.equals(".xml")) {
                    cp = new XMLConfigProperties(url);
                    break block7;
                }
                if (format.equals(".properties")) {
                    cp = new PropConfigProperties(url);
                    break block7;
                }
                if (format.equals("MXML")) {
                    cp = new XMLConfigProperties(url, namespace);
                    break block7;
                }
                if (format.equals(".config")) {
                    cp = new PluggableConfigProperties(url);
                    break block7;
                }
                throw new UnknownConfigFormatException("parameter format is illegal");
            }
            catch (IOException ioe) {
                throw new ConfigManagerException(ioe.getMessage());
            }
        }
        this.namespaces.put(namespace, new Namespace(namespace, url, format, exceptionLevel, (ConfigProperties)var5_5));
        this.tempProperties.remove(namespace);
    }

    public void add(String namespace, String filename, String format, int exceptionLevel) throws ConfigManagerException {
        if (namespace == null) {
            throw new NullPointerException("parameter filename is null");
        }
        if (namespace.trim().length() == 0) {
            throw new IllegalArgumentException("parameter filename is empty");
        }
        if (filename == null) {
            throw new NullPointerException("parameter filename is null");
        }
        if (filename.trim().length() == 0) {
            throw new IllegalArgumentException("parameter filename is empty");
        }
        if (format == null) {
            throw new NullPointerException("parameter format is null");
        }
        if (!(format.equals(".xml") || format.equals(".properties") || format.equals("MXML") || format.equals(".config"))) {
            throw new UnknownConfigFormatException("parameter format is illegal");
        }
        if (exceptionLevel != 0 && exceptionLevel != 1) {
            throw new IllegalArgumentException("parameter exceptionLevel is illegal");
        }
        this.addURL(namespace, ConfigManager.getURL(filename), format, exceptionLevel);
    }

    public void add(String namespace, String format, int exceptionLevel) throws ConfigManagerException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (namespace.trim().length() == 0) {
            throw new IllegalArgumentException("parameter namespace is empty");
        }
        if (format == null) {
            throw new NullPointerException("parameter format is null");
        }
        if (!(format.equals(".xml") || format.equals(".properties") || format.equals("MXML") || format.equals(".config"))) {
            throw new UnknownConfigFormatException("parameter format is illegal");
        }
        if (exceptionLevel != 0 && exceptionLevel != 1) {
            throw new IllegalArgumentException("parameter exceptionLevel is illegal");
        }
        String filename = namespace.replace('.', '/');
        filename = format.equals("MXML") ? filename + ".xml" : filename + format;
        this.add(namespace, filename, format, exceptionLevel);
    }

    public void add(String filename, int exceptionLevel) throws ConfigManagerException {
        if (filename == null) {
            throw new NullPointerException("parameter filename is null");
        }
        if (filename.trim().length() == 0) {
            throw new IllegalArgumentException("parameter filename is empty");
        }
        if (exceptionLevel != 0 && exceptionLevel != 1) {
            throw new IllegalArgumentException("parameter exceptionLevel is illegal");
        }
        URL url = ConfigManager.getURL(filename);
        Enumeration enu = XMLConfigProperties.getNamespaces(url);
        while (enu.hasMoreElements()) {
            String namespace = (String)enu.nextElement();
            this.addURL(namespace, url, "MXML", exceptionLevel);
        }
    }

    public void add(URL url, int exceptionLevel) throws ConfigManagerException {
        if (url == null) {
            throw new NullPointerException("parameter url is null");
        }
        if (exceptionLevel != 0 && exceptionLevel != 1) {
            throw new IllegalArgumentException("parameter exceptionLevel is illegal");
        }
        this.addURLs(url, exceptionLevel);
    }

    private void addURLs(URL url, int exceptionLevel) throws ConfigManagerException {
        Enumeration enu = XMLConfigProperties.getNamespaces(url);
        while (enu.hasMoreElements()) {
            String namespace = (String)enu.nextElement();
            this.addURL(namespace, url, "MXML", exceptionLevel);
        }
    }

    private void addURL(String namespace, URL url, String format) throws ConfigManagerException {
        this.addURL(namespace, url, format, 0);
    }

    public void add(String namespace, String filename, String format) throws ConfigManagerException {
        this.add(namespace, filename, format, 0);
    }

    public void add(String namespace, String format) throws ConfigManagerException {
        this.add(namespace, format, 0);
    }

    public void add(String filename) throws ConfigManagerException {
        this.add(filename, 0);
    }

    public void add(URL url) throws ConfigManagerException {
        this.add(url, 0);
    }

    public void refreshAll() throws ConfigManagerException {
        String message = "";
        Iterator itr = new HashSet(this.namespaces.keySet()).iterator();
        while (itr.hasNext()) {
            String namespace = (String)itr.next();
            try {
                ((Namespace)this.namespaces.get(namespace)).getProperties().load();
            }
            catch (Exception exception) {
                this.namespaces.remove(namespace);
                this.tempProperties.remove(namespace);
                message = message + exception.getMessage();
            }
        }
        if (message.length() > 0) {
            throw new ConfigManagerException("refresh failed for some namespaces : " + message);
        }
    }

    public void refresh(String namespace) throws ConfigManagerException, UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        try {
            ((Namespace)this.namespaces.get(namespace)).getProperties().load();
        }
        catch (IOException ioe) {
            this.namespaces.remove(namespace);
            this.tempProperties.remove(namespace);
            throw new ConfigManagerException(ioe.getMessage());
        }
    }

    public Object getProperty(String namespace, String key) throws UnknownNamespaceException {
        return this.getString(namespace, key);
    }

    public Property getPropertyObject(String namespace, String key) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        return ((Namespace)this.namespaces.get(namespace)).getProperties().getRoot().getProperty(key);
    }

    public String getString(String namespace, String key) throws UnknownNamespaceException {
        Property property = this.getPropertyObject(namespace, key);
        if (property == null || property.getValue() == null) {
            return null;
        }
        char listDelimiter = ((Namespace)this.namespaces.get(namespace)).getProperties().getListDelimiter();
        String[] values = property.getValues();
        return DefaultConfigManager.mergeEscaped(values, listDelimiter);
    }

    public String[] getStringArray(String namespace, String key) throws UnknownNamespaceException {
        Property property = this.getPropertyObject(namespace, key);
        if (property == null) {
            return null;
        }
        return property.getValues();
    }

    public Enumeration getPropertyNames(String namespace) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        return ((Namespace)this.namespaces.get(namespace)).getProperties().getRoot().propertyNames();
    }

    public boolean existsNamespace(String namespace) {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        return this.namespaces.containsKey(namespace);
    }

    public String getConfigFormat(String namespace) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        return ((Namespace)this.namespaces.get(namespace)).getFormat();
    }

    public String getConfigFilename(String namespace) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        return ((Namespace)this.namespaces.get(namespace)).getFile().getFile();
    }

    public Iterator getAllNamespaces() {
        return new HashSet(this.namespaces.keySet()).iterator();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(String namespace, String user) throws ConfigManagerException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (user == null) {
            throw new NullPointerException("parameter user is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        Namespace ns = (Namespace)this.namespaces.get(namespace);
        if (!ns.canLock(user)) {
            throw new ConfigLockedException(namespace + " is currently locked by another user");
        }
        ns.lock(user);
        try {
            try {
                ((ConfigProperties)this.tempProperties.get(namespace)).save();
            }
            catch (UnsupportedOperationException uoe) {
                throw new ConfigManagerException(uoe.getMessage());
            }
            catch (IOException ioe) {
                throw new ConfigManagerException(ioe.getMessage());
            }
            Object var6_4 = null;
            this.tempProperties.remove(namespace);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.tempProperties.remove(namespace);
            ns.releaseLock();
            Iterator itr = new HashSet(this.namespaces.keySet()).iterator();
            while (true) {
                if (!itr.hasNext()) {
                    throw throwable;
                }
                String shareNamespace = (String)itr.next();
                try {
                    Namespace share = (Namespace)this.namespaces.get(shareNamespace);
                    if (!share.getFile().getFile().equals(ns.getFile().getFile())) continue;
                    share.getProperties().load();
                }
                catch (Exception exception) {}
            }
        }
        ns.releaseLock();
        Iterator itr = new HashSet(this.namespaces.keySet()).iterator();
        while (itr.hasNext()) {
            String shareNamespace = (String)itr.next();
            try {}
            catch (Exception exception) {
                continue;
            }
            Namespace share = (Namespace)this.namespaces.get(shareNamespace);
            if (!share.getFile().getFile().equals(ns.getFile().getFile())) continue;
            share.getProperties().load();
            break;
        }
        return;
    }

    public void lock(String namespace, String user) throws UnknownNamespaceException, ConfigLockedException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (user == null) {
            throw new NullPointerException("parameter user is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        ((Namespace)this.namespaces.get(namespace)).lock(user);
    }

    public boolean canLock(String namespace, String user) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (user == null) {
            throw new NullPointerException("parameter user is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        Namespace ns = (Namespace)this.namespaces.get(namespace);
        Iterator itr = new HashSet(this.namespaces.keySet()).iterator();
        while (itr.hasNext()) {
            String shareNamespace = (String)itr.next();
            try {
                Namespace share = (Namespace)this.namespaces.get(shareNamespace);
                if (!share.getFile().getFile().equals(ns.getFile().getFile()) || share.canLock(user)) continue;
                return false;
            }
            catch (Exception exception) {
            }
        }
        return true;
    }

    public void forceUnlock(String namespace) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        Namespace ns = (Namespace)this.namespaces.get(namespace);
        Iterator itr = new HashSet(this.namespaces.keySet()).iterator();
        while (itr.hasNext()) {
            String shareNamespace = (String)itr.next();
            try {
                Namespace share = (Namespace)this.namespaces.get(shareNamespace);
                if (!share.getFile().getFile().equals(ns.getFile().getFile())) continue;
                share.releaseLock();
            }
            catch (Exception exception) {}
        }
    }

    public void createTemporaryProperties(String namespace) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        this.tempProperties.put(namespace, ((Namespace)this.namespaces.get(namespace)).getProperties().clone());
    }

    public Enumeration getTemporaryPropertyNames(String namespace) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        return ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().propertyNames();
    }

    public String getTemporaryString(String namespace, String key) throws UnknownNamespaceException {
        Property property = this.getTemporaryPropertyObject(namespace, key);
        if (property == null) {
            return null;
        }
        char listDelimiter = ((Namespace)this.namespaces.get(namespace)).getProperties().getListDelimiter();
        String[] values = property.getValues();
        return DefaultConfigManager.mergeEscaped(values, listDelimiter);
    }

    public Property getTemporaryPropertyObject(String namespace, String key) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        return ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().getProperty(key);
    }

    public String[] getTemporaryStringArray(String namespace, String key) throws UnknownNamespaceException {
        Property property = this.getTemporaryPropertyObject(namespace, key);
        if (property == null) {
            return null;
        }
        return property.getValues();
    }

    public void setProperty(String namespace, String key, String value) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().setProperty(key, value);
    }

    public void setProperty(String namespace, String key, String[] values) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (values == null) {
            throw new NullPointerException("parameter values is null");
        }
        ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().setProperty(key, values);
    }

    public void addToProperty(String namespace, String key, String value) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        Property property = ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().getProperty(key);
        if (property != null) {
            property.addValue(value);
        } else {
            ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().setProperty(key, value);
        }
    }

    public void removeProperty(String namespace, String key) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().removeProperty(key);
    }

    public void removeValue(String namespace, String key, String value) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.tempProperties.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        if (key == null) {
            throw new NullPointerException("parameter key is null");
        }
        if (value == null) {
            throw new NullPointerException("parameter value is null");
        }
        Property property = ((ConfigProperties)this.tempProperties.get(namespace)).getRoot().getProperty(key);
        if (property != null) {
            property.removeValue(value);
        }
    }

    public void removeNamespace(String namespace) throws UnknownNamespaceException {
        if (namespace == null) {
            throw new NullPointerException("parameter namespace is null");
        }
        if (!this.namespaces.containsKey(namespace)) {
            throw new UnknownNamespaceException(namespace + " is unknown");
        }
        this.namespaces.remove(namespace);
        this.tempProperties.remove(namespace);
    }

    private static String mergeEscaped(String[] values, char listDelimiter) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (i > 0) {
                buffer.append(listDelimiter);
            }
            for (int k = 0; k < values[i].length(); ++k) {
                char ch = values[i].charAt(k);
                if (ch == listDelimiter) {
                    buffer.append('\\');
                    buffer.append(ch);
                    continue;
                }
                buffer.append(ch);
            }
        }
        return buffer.toString();
    }
}

