/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigLockedException;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.ConfigManagerInterface;
import com.topcoder.util.config.DefaultConfigManager;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.config.XMLConfigProperties;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;

public abstract class ConfigManager
implements ConfigManagerInterface {
    public static final String CONFIG_MANAGER_NAMESPACE = "com.topcoder.util.config.ConfigManager";
    public static final String CONFIG_XML_FORMAT = ".xml";
    public static final String CONFIG_PROPERTIES_FORMAT = ".properties";
    public static final String CONFIG_MULTIPLE_XML_FORMAT = "MXML";
    public static final String CONFIG_PLUGGABLE_FORMAT = ".config";
    public static final int EXCEPTIONS_ALL = 0;
    public static final int EXCEPTIONS_MAJOR = 1;
    private static ConfigManager defaultConfigManager = null;
    static /* synthetic */ Class class$com$topcoder$util$config$ConfigManager;

    static URL getURL(String filename) throws ConfigManagerException {
        if (new File(filename).isAbsolute()) {
            try {
                return new URL("file:" + filename);
            }
            catch (MalformedURLException murle) {
                throw new ConfigManagerException(filename + " is invalid");
            }
        }
        try {
            URL url = (class$com$topcoder$util$config$ConfigManager == null ? (class$com$topcoder$util$config$ConfigManager = ConfigManager.class$(CONFIG_MANAGER_NAMESPACE)) : class$com$topcoder$util$config$ConfigManager).getClassLoader().getResource(filename);
            if (url != null) {
                return url;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        throw new ConfigManagerException("can not locate " + filename);
    }

    static String decodeURL(String url) throws ConfigManagerException {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new ConfigManagerException("The URL is not encoded with UTF-8.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigManager getInstance() {
        if (defaultConfigManager != null) {
            return defaultConfigManager;
        }
        defaultConfigManager = new DefaultConfigManager();
        try {
            InputStream is = ConfigManager.getURL("com/topcoder/util/config/ConfigManager.properties").openStream();
            Properties properties = new Properties();
            try {
                properties.load(is);
            }
            finally {
                is.close();
            }
            Enumeration<?> enu = properties.propertyNames();
            while (enu.hasMoreElements()) {
                String namespace = (String)enu.nextElement();
                String filename = properties.getProperty(namespace);
                try {
                    if (filename == null || filename.length() == 0) {
                        defaultConfigManager.add(namespace, CONFIG_XML_FORMAT);
                        continue;
                    }
                    String lower = filename.toLowerCase();
                    if (lower.endsWith(CONFIG_PROPERTIES_FORMAT)) {
                        defaultConfigManager.add(namespace, filename, CONFIG_PROPERTIES_FORMAT);
                        continue;
                    }
                    if (lower.endsWith(CONFIG_PLUGGABLE_FORMAT)) {
                        defaultConfigManager.add(namespace, filename, CONFIG_PLUGGABLE_FORMAT);
                        continue;
                    }
                    if (lower.endsWith(CONFIG_XML_FORMAT)) {
                        Enumeration test = XMLConfigProperties.getNamespaces(ConfigManager.getURL(filename));
                        if (test != null && test.hasMoreElements()) {
                            defaultConfigManager.add(namespace, filename, CONFIG_MULTIPLE_XML_FORMAT);
                            continue;
                        }
                        defaultConfigManager.add(namespace, filename, CONFIG_XML_FORMAT);
                        continue;
                    }
                    System.err.println("unrecognized file type : " + filename);
                }
                catch (Exception exception) {
                    System.err.println("encounter exception loading " + filename + " : " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return defaultConfigManager;
    }

    public abstract String getNamespace();

    public abstract Enumeration getConfigPropNames();

    public abstract void add(String var1, String var2, String var3, int var4) throws ConfigManagerException;

    public abstract void add(String var1, String var2, int var3) throws ConfigManagerException;

    public abstract void add(URL var1, int var2) throws ConfigManagerException;

    public abstract void add(String var1, int var2) throws ConfigManagerException;

    public abstract void add(String var1, String var2, String var3) throws ConfigManagerException;

    public abstract void add(String var1, String var2) throws ConfigManagerException;

    public abstract void add(String var1) throws ConfigManagerException;

    public abstract void add(URL var1) throws ConfigManagerException;

    public abstract void refreshAll() throws ConfigManagerException;

    public abstract void refresh(String var1) throws ConfigManagerException, UnknownNamespaceException;

    public abstract Object getProperty(String var1, String var2) throws UnknownNamespaceException;

    public abstract Property getPropertyObject(String var1, String var2) throws UnknownNamespaceException;

    public abstract String getString(String var1, String var2) throws UnknownNamespaceException;

    public abstract String[] getStringArray(String var1, String var2) throws UnknownNamespaceException;

    public abstract Enumeration getPropertyNames(String var1) throws UnknownNamespaceException;

    public abstract boolean existsNamespace(String var1);

    public abstract String getConfigFormat(String var1) throws UnknownNamespaceException;

    public abstract String getConfigFilename(String var1) throws UnknownNamespaceException;

    public abstract Iterator getAllNamespaces();

    public abstract void commit(String var1, String var2) throws ConfigManagerException;

    public abstract void lock(String var1, String var2) throws UnknownNamespaceException, ConfigLockedException;

    public abstract boolean canLock(String var1, String var2) throws UnknownNamespaceException;

    public abstract void forceUnlock(String var1) throws UnknownNamespaceException;

    public abstract void createTemporaryProperties(String var1) throws UnknownNamespaceException;

    public abstract Enumeration getTemporaryPropertyNames(String var1) throws UnknownNamespaceException;

    public abstract String getTemporaryString(String var1, String var2) throws UnknownNamespaceException;

    public abstract Property getTemporaryPropertyObject(String var1, String var2) throws UnknownNamespaceException;

    public abstract String[] getTemporaryStringArray(String var1, String var2) throws UnknownNamespaceException;

    public abstract void setProperty(String var1, String var2, String var3) throws UnknownNamespaceException;

    public abstract void setProperty(String var1, String var2, String[] var3) throws UnknownNamespaceException;

    public abstract void addToProperty(String var1, String var2, String var3) throws UnknownNamespaceException;

    public abstract void removeProperty(String var1, String var2) throws UnknownNamespaceException;

    public abstract void removeValue(String var1, String var2, String var3) throws UnknownNamespaceException;

    public abstract void removeNamespace(String var1) throws UnknownNamespaceException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

