/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ImageFromBlocksVis {
    private static long timeLimit = 10L;
    private static final int minSize = 8;
    private static final int maxSize = 20;
    private static final int minImageDimension = 300;
    private static final int maxImageDimension = 800;
    private static final int[][][] pieces;
    private static String imagesFolder;
    private int blockSize;
    private int maxDiscard;
    private int imageHeight;
    private int imageWidth;
    private int boardHeight;
    private int boardWidth;
    private int filled;
    private int discarded;
    private int currPieceIdx;
    private double score;
    private int[] pixels;
    private int[][] boardColors;
    private int[][] boardPieces;
    private int[][] currPiece;
    private BufferedImage image;
    private BufferedImage errorImage;
    private SecureRandom rnd;
    private long timeLeft;
    private JFrame jf;
    private Vis v;
    private static String exec;
    private static boolean vis;
    private static boolean debug;
    private static boolean maximized;
    private static boolean drawBorder;
    private static boolean coloredPieces;
    private static Process proc;
    private InputStream is;
    private OutputStream os;
    private BufferedReader br;
    private static int anim;
    private static int delay;
    private static int paused;

    static {
        int[][][] nArrayArray = new int[10][][];
        nArrayArray[0] = new int[][]{{1, 1}};
        nArrayArray[1] = new int[][]{{1, 1, 1}};
        int[][] nArrayArray2 = new int[2][];
        int[] nArray = new int[2];
        nArray[0] = 1;
        nArrayArray2[0] = nArray;
        nArrayArray2[1] = new int[]{1, 1};
        nArrayArray[2] = nArrayArray2;
        nArrayArray[3] = new int[][]{{1, 1, 1, 1}};
        nArrayArray[4] = new int[][]{{1, 1}, {1, 1}};
        int[][] nArrayArray3 = new int[2][];
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArrayArray3[0] = nArray2;
        nArrayArray3[1] = new int[]{1, 1, 1};
        nArrayArray[5] = nArrayArray3;
        int[][] nArrayArray4 = new int[2][];
        int[] nArray3 = new int[3];
        nArray3[0] = 1;
        nArray3[1] = 1;
        nArrayArray4[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArray4[2] = 1;
        nArrayArray4[1] = nArray4;
        nArrayArray[6] = nArrayArray4;
        int[][] nArrayArray5 = new int[2][];
        int[] nArray5 = new int[3];
        nArray5[1] = 1;
        nArray5[2] = 1;
        nArrayArray5[0] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArrayArray5[1] = nArray6;
        nArrayArray[7] = nArrayArray5;
        int[][] nArrayArray6 = new int[2][];
        int[] nArray7 = new int[3];
        nArray7[0] = 1;
        nArrayArray6[0] = nArray7;
        nArrayArray6[1] = new int[]{1, 1, 1};
        nArrayArray[8] = nArrayArray6;
        int[][] nArrayArray7 = new int[2][];
        int[] nArray8 = new int[3];
        nArray8[2] = 1;
        nArrayArray7[0] = nArray8;
        nArrayArray7[1] = new int[]{1, 1, 1};
        nArrayArray[9] = nArrayArray7;
        pieces = nArrayArray;
        imagesFolder = "images";
    }

    public String generate(String seedStr) {
        try {
            this.rnd = SecureRandom.getInstance("SHA1PRNG");
            long seed = Long.parseLong(seedStr);
            this.rnd.setSeed(seed);
            this.blockSize = this.random(8, 20);
            if (seed == 1L) {
                this.blockSize = 20;
            } else if (seed == 2L) {
                this.blockSize = 8;
            }
            File folder = new File(imagesFolder);
            if (!folder.exists()) {
                this.addFatalError("ERROR: Images folder \"" + imagesFolder + "\" not found!");
                System.exit(-1);
            }
            File[] files = folder.listFiles();
            ArrayList<File> imageFiles = new ArrayList<File>();
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(".jpg")) {
                    imageFiles.add(file);
                }
                ++n2;
            }
            if (imageFiles.isEmpty()) {
                this.addFatalError("ERROR: No JPG images in folder \"" + imagesFolder + "\\\"!");
                System.exit(-1);
            }
            Collections.sort(imageFiles);
            int idx = (int)((seed - 1L) % (long)imageFiles.size());
            if (idx < 0) {
                idx += imageFiles.size();
            }
            File imageFile = (File)imageFiles.get(idx);
            if (debug) {
                System.out.println("Image File = " + imageFile);
            }
            this.image = ImageIO.read(imageFile);
            if (this.image.getHeight() < 300 || this.image.getWidth() < 300) {
                this.addFatalError("ERROR: Invalid image dimensions \"" + imageFile + "\"!");
                System.exit(-1);
            }
            this.boardHeight = Math.min(800, this.image.getHeight()) / this.blockSize;
            this.boardWidth = Math.min(800, this.image.getWidth()) / this.blockSize;
            this.imageHeight = this.boardHeight * this.blockSize;
            this.imageWidth = this.boardWidth * this.blockSize;
            if (vis) {
                this.errorImage = new BufferedImage(this.imageWidth, this.imageHeight, 1);
            }
            this.pixels = new int[this.imageHeight * this.imageWidth];
            int y = 0;
            while (y < this.imageHeight) {
                int yw = y * this.imageWidth;
                int x = 0;
                while (x < this.imageWidth) {
                    this.pixels[yw + x] = this.image.getRGB(x, y) & 0xFFFFFF;
                    if (vis) {
                        this.errorImage.setRGB(x, y, 0xFFFFFF);
                    }
                    ++x;
                }
                ++y;
            }
            this.boardColors = new int[this.boardHeight][this.boardWidth];
            this.boardPieces = new int[this.boardHeight][this.boardWidth];
            int i = 0;
            while (i < this.boardHeight) {
                Arrays.fill(this.boardColors[i], -1);
                Arrays.fill(this.boardPieces[i], -1);
                ++i;
            }
            int numCells = this.boardHeight * this.boardWidth;
            this.maxDiscard = this.random(numCells / 40, numCells / 4);
            StringBuffer sb = new StringBuffer();
            sb.append("BlockSize = " + this.blockSize + '\n');
            sb.append("ImageHeight = " + this.imageHeight + '\n');
            sb.append("ImageWidth = " + this.imageWidth + '\n');
            sb.append("MaxDiscard = " + this.maxDiscard + '\n');
            return sb.toString();
        }
        catch (Exception e) {
            this.addFatalError("An exception occurred while generating test case.");
            e.printStackTrace();
            return "";
        }
    }

    private static int getComponent(int color, int index) {
        return color >>> (index << 3) & 0xFF;
    }

    private static int getDiff(int c1, int c2) {
        int d = 0;
        int i = 0;
        while (i < 3) {
            d += Math.abs(ImageFromBlocksVis.getComponent(c1, i) - ImageFromBlocksVis.getComponent(c2, i));
            ++i;
        }
        return d;
    }

    private static int getRGBDiff(int c1, int c2) {
        int d = Math.abs(ImageFromBlocksVis.getComponent(c1, 0) - ImageFromBlocksVis.getComponent(c2, 0)) << 16;
        d |= Math.abs(ImageFromBlocksVis.getComponent(c1, 1) - ImageFromBlocksVis.getComponent(c2, 1)) << 8;
        return d |= Math.abs(ImageFromBlocksVis.getComponent(c1, 2) - ImageFromBlocksVis.getComponent(c2, 2));
    }

    /*
     * Exception decompiling
     */
    public double runTest(String seed) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[WHILELOOP]], but top level block is 14[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void nextPiece() {
        this.currPieceIdx = this.rnd.nextInt(pieces.length);
        int[][] basePiece = pieces[this.currPieceIdx];
        this.currPiece = new int[basePiece.length][basePiece[0].length];
        int xBase = this.rnd.nextInt(this.imageWidth);
        int yBase = this.rnd.nextInt(this.imageHeight);
        int i = 0;
        while (i < basePiece.length) {
            int j = 0;
            while (j < basePiece[0].length) {
                if (basePiece[i][j] == 0) {
                    this.currPiece[i][j] = -1;
                } else {
                    int xp = this.random(Math.max(0, xBase - this.blockSize), Math.min(this.imageWidth - 1, xBase + this.blockSize));
                    int yp = this.random(Math.max(0, yBase - this.blockSize), Math.min(this.imageHeight - 1, yBase + this.blockSize));
                    this.currPiece[i][j] = this.pixels[yp * this.imageWidth + xp];
                }
                ++j;
            }
            ++i;
        }
    }

    private int canPlacePiece(int xPiece, int rot) {
        int[][] piece = ImageFromBlocksVis.getRotated(this.currPiece, rot);
        int ret = -1000;
        if (xPiece < 0 || xPiece + piece[0].length > this.boardWidth) {
            return ret;
        }
        int y = 1 - piece.length;
        block0: while (y < this.boardHeight) {
            if (y + piece.length > this.boardHeight) break;
            int r = 0;
            while (r < piece.length) {
                if (y + r >= 0) {
                    int c = 0;
                    while (c < piece[0].length) {
                        int color = piece[r][c];
                        if (color != -1 && this.boardColors[y + r][xPiece + c] != -1) break block0;
                        ++c;
                    }
                }
                ++r;
            }
            ret = y++;
        }
        return ret;
    }

    private void doPlacePiece(int xPiece, int yPiece, int rot) {
        int[][] piece = ImageFromBlocksVis.getRotated(this.currPiece, rot);
        int r = 0;
        while (r < piece.length) {
            int c = 0;
            while (c < piece[0].length) {
                int color = piece[r][c];
                if (color != -1) {
                    this.boardColors[yPiece + r][xPiece + c] = color;
                    this.boardPieces[yPiece + r][xPiece + c] = this.currPieceIdx;
                    ++this.filled;
                    double err = 0.0;
                    int i = 0;
                    while (i < this.blockSize) {
                        int py = (r + yPiece) * this.blockSize + i;
                        int j = 0;
                        while (j < this.blockSize) {
                            int px = (xPiece + c) * this.blockSize + j;
                            int pixel = this.pixels[py * this.imageWidth + px];
                            err += (double)ImageFromBlocksVis.getDiff(color, pixel) / 765.0;
                            if (vis) {
                                this.errorImage.setRGB(px, py, ImageFromBlocksVis.getRGBDiff(color, pixel));
                            }
                            ++j;
                        }
                        ++i;
                    }
                    this.score += Math.pow(1.0 - (err /= (double)(this.blockSize * this.blockSize)), 2.0);
                }
                ++c;
            }
            ++r;
        }
    }

    private boolean discardPiece() {
        if (this.discarded == this.maxDiscard) {
            return false;
        }
        ++this.discarded;
        return true;
    }

    private static int[][] getRotated(int[][] piece, int rot) {
        int i = 0;
        while (i < rot) {
            piece = ImageFromBlocksVis.getRotated(piece);
            ++i;
        }
        return piece;
    }

    private static int[][] getRotated(int[][] piece) {
        int r = piece[0].length;
        int c = piece.length;
        int[][] rotated = new int[r][c];
        int i = 0;
        while (i < piece.length) {
            int j = 0;
            while (j < piece[0].length) {
                rotated[j][c - 1 - i] = piece[i][j];
                ++j;
            }
            ++i;
        }
        return rotated;
    }

    private int random(int min, int max) {
        return this.rnd.nextInt(max - min + 1) + min;
    }

    String init(int pImageHeight, int pBlockSize, int pDiscard, int[] pImage) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(pImageHeight).append('\n');
        sb.append(pBlockSize).append('\n');
        sb.append(pDiscard).append('\n');
        sb.append(pImage.length).append('\n');
        int i = 0;
        while (i < pImage.length) {
            sb.append(pImage[i]).append('\n');
            ++i;
        }
        this.os.write(sb.toString().getBytes());
        this.os.flush();
        long startTime = System.nanoTime();
        String ret = this.br.readLine();
        this.timeLeft -= System.nanoTime() - startTime;
        return ret;
    }

    String placePiece(int pPieceHeight, int[] pPiece, long pTimeLeft) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(pPieceHeight).append('\n');
        sb.append(pPiece.length).append('\n');
        int i = 0;
        while (i < pPiece.length) {
            sb.append(pPiece[i]).append('\n');
            ++i;
        }
        sb.append(pTimeLeft).append('\n');
        this.os.write(sb.toString().getBytes());
        this.os.flush();
        long startTime = System.nanoTime();
        String ret = this.br.readLine();
        this.timeLeft -= System.nanoTime() - startTime;
        return ret;
    }

    private void delay(long t) {
        try {
            if (t > 0L) {
                Thread.sleep(t);
            }
            while (paused == 1) {
                Thread.sleep(10L);
            }
            if (paused == 2) {
                paused = 1;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ImageFromBlocksVis(String seed) {
        try {
            if (vis) {
                this.jf = new JFrame();
                this.jf.setTitle("MM 110 - ImageFromBlocks - Seed " + seed);
                this.v = new Vis();
                this.jf.setContentPane(this.v);
            }
            if (exec != null) {
                try {
                    Runtime rt = Runtime.getRuntime();
                    proc = rt.exec(exec);
                    this.os = proc.getOutputStream();
                    this.is = proc.getInputStream();
                    this.br = new BufferedReader(new InputStreamReader(this.is));
                    new ErrorReader(proc.getErrorStream()).start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Score = " + this.runTest(seed));
            if (proc != null) {
                try {
                    proc.destroy();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String seed = "1";
        vis = true;
        drawBorder = true;
        anim = -1;
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase("-seed")) {
                seed = args[++i];
            }
            if (args[i].equalsIgnoreCase("-exec")) {
                exec = args[++i];
            }
            if (args[i].equalsIgnoreCase("-anim")) {
                anim = Integer.parseInt(args[++i]);
            }
            if (args[i].equalsIgnoreCase("-delay")) {
                delay = Integer.parseInt(args[++i]);
            }
            if (args[i].equalsIgnoreCase("-novis")) {
                vis = false;
            }
            if (args[i].equalsIgnoreCase("-noborder")) {
                drawBorder = false;
            }
            if (args[i].equalsIgnoreCase("-colored")) {
                coloredPieces = true;
            }
            if (args[i].equalsIgnoreCase("-time")) {
                timeLimit = Integer.parseInt(args[++i]);
            }
            if (args[i].equalsIgnoreCase("-images")) {
                imagesFolder = args[++i];
            }
            if (args[i].equalsIgnoreCase("-debug")) {
                debug = true;
            }
            if (args[i].equalsIgnoreCase("-paused")) {
                paused = 1;
            }
            if (args[i].equalsIgnoreCase("-max")) {
                maximized = true;
            }
            ++i;
        }
        if (anim == -1 && exec == null) {
            anim = 300;
        }
        if (exec == null && !vis) {
            vis = true;
        }
        if (!vis) {
            System.setProperty("java.awt.headless", "true");
        }
        new ImageFromBlocksVis(seed);
    }

    void addFatalError(String message) {
        System.out.println(message);
    }

    public class Vis
    extends JPanel {
        private static final long serialVersionUID = 2919900099978500636L;
        private static final int border = 8;
        private static final int sh = 18;
        private final Font fontBold = new Font("SansSerif", 1, 15);
        private final Font fontPlain = new Font("SansSerif", 0, 15);
        private final Color grid1 = new Color(250, 250, 250, 150);
        private final Color grid2 = new Color(140, 140, 140, 150);
        private final Color grid3 = new Color(250, 250, 0);
        private final Color grid4 = new Color(140, 140, 0);
        private final Color fillColor = new Color(210, 210, 240);
        private BufferedImage paint1;
        private BufferedImage paint2;
        private int xPiece;
        private int yPiece = 0;
        private int rot;
        private int yPreview = -1;
        private final AtomicBoolean waiting = new AtomicBoolean();
        private final DecimalFormat df = new DecimalFormat("0.000", DecimalFormatSymbols.getInstance(Locale.US));
        private final int[] pieceColors = new int[]{43690, 0xAA5500, 43520, 65535, 0xFFFF00, 0xAA00FF, 0xFF0000, 65280, 255, 0xFFAA00};

        public void init() {
            int pw = ImageFromBlocksVis.this.imageWidth + ImageFromBlocksVis.this.imageWidth / 3 + 24;
            int ph = ImageFromBlocksVis.this.imageHeight + 5 * ImageFromBlocksVis.this.blockSize + 16;
            this.paint1 = new BufferedImage(pw, ph, 1);
            this.paint2 = new BufferedImage(pw, ph, 1);
            this.setPreferredSize(new Dimension(pw, ph));
            this.fullRepaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fullRepaint() {
            BufferedImage bufferedImage = this.paint1;
            synchronized (bufferedImage) {
                Graphics2D g2 = this.paint1.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setColor(Color.lightGray);
                g2.fillRect(0, 0, this.paint1.getWidth(), this.paint1.getHeight());
                this.fill(g2, ImageFromBlocksVis.this.imageWidth + 16, 70, ImageFromBlocksVis.this.imageWidth / 3, 18, (double)ImageFromBlocksVis.this.filled / (double)(ImageFromBlocksVis.this.boardHeight * ImageFromBlocksVis.this.boardWidth));
                this.fill(g2, ImageFromBlocksVis.this.imageWidth + 16, 114, ImageFromBlocksVis.this.imageWidth / 3, 18, (double)ImageFromBlocksVis.this.discarded / (double)ImageFromBlocksVis.this.maxDiscard);
                g2.setColor(Color.black);
                g2.setFont(this.fontBold);
                this.ds(g2, "Score", ImageFromBlocksVis.this.imageWidth + 16, 8, ImageFromBlocksVis.this.imageWidth / 3, 18, 0);
                this.ds(g2, "Filled", ImageFromBlocksVis.this.imageWidth + 16, 52, ImageFromBlocksVis.this.imageWidth / 3, 18, 0);
                this.ds(g2, "Discarded", ImageFromBlocksVis.this.imageWidth + 16, 96, ImageFromBlocksVis.this.imageWidth / 3, 18, 0);
                g2.setFont(this.fontPlain);
                this.ds(g2, this.df.format(ImageFromBlocksVis.this.score), ImageFromBlocksVis.this.imageWidth + 16, 26, ImageFromBlocksVis.this.imageWidth / 3, 18, 0);
                this.ds(g2, String.valueOf(ImageFromBlocksVis.this.filled) + " / " + ImageFromBlocksVis.this.boardHeight * ImageFromBlocksVis.this.boardWidth, ImageFromBlocksVis.this.imageWidth + 16, 70, ImageFromBlocksVis.this.imageWidth / 3, 18, 0);
                this.ds(g2, String.valueOf(ImageFromBlocksVis.this.discarded) + " / " + ImageFromBlocksVis.this.maxDiscard, ImageFromBlocksVis.this.imageWidth + 16, 114, ImageFromBlocksVis.this.imageWidth / 3, 18, 0);
                this.paintBoard(g2, 8, 8, ImageFromBlocksVis.this.imageWidth, ImageFromBlocksVis.this.imageHeight + 5 * ImageFromBlocksVis.this.blockSize);
                this.paintImage(ImageFromBlocksVis.this.image, g2, ImageFromBlocksVis.this.imageWidth + 16, ImageFromBlocksVis.this.imageHeight + 5 * ImageFromBlocksVis.this.blockSize - 2 * ImageFromBlocksVis.this.imageHeight / 3, ImageFromBlocksVis.this.imageWidth / 3, ImageFromBlocksVis.this.imageHeight / 3);
                this.paintImage(ImageFromBlocksVis.this.errorImage, g2, ImageFromBlocksVis.this.imageWidth + 16, ImageFromBlocksVis.this.imageHeight + 5 * ImageFromBlocksVis.this.blockSize + 8 - ImageFromBlocksVis.this.imageHeight / 3, ImageFromBlocksVis.this.imageWidth / 3, ImageFromBlocksVis.this.imageHeight / 3);
                g2.dispose();
            }
            this.repaint();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = this.paint2.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            BufferedImage bufferedImage = this.paint1;
            synchronized (bufferedImage) {
                g2.drawImage((Image)this.paint1, 0, 0, null);
            }
            if (ImageFromBlocksVis.this.currPiece != null) {
                int im = this.yPreview < 0 ? 0 : 1;
                int[][] piece = ImageFromBlocksVis.getRotated(ImageFromBlocksVis.this.currPiece, this.rot);
                int r = 0;
                while (r < piece.length) {
                    int c = 0;
                    while (c < piece[0].length) {
                        int color = piece[r][c];
                        if (color != -1) {
                            if (coloredPieces) {
                                color = this.pieceColors[ImageFromBlocksVis.this.currPieceIdx];
                            }
                            int xr = 8 + (c + this.xPiece) * ImageFromBlocksVis.this.blockSize;
                            int i = 0;
                            while (i <= im) {
                                int yr = 8 + (r + (i == 0 ? this.yPiece : this.yPreview + 5)) * ImageFromBlocksVis.this.blockSize;
                                if (i == 0) {
                                    g2.setColor(new Color(color));
                                    g2.fillRect(xr, yr, ImageFromBlocksVis.this.blockSize, ImageFromBlocksVis.this.blockSize);
                                }
                                g2.setColor(i == 0 ? this.grid1 : this.grid3);
                                g2.drawLine(xr, yr, xr, yr + ImageFromBlocksVis.this.blockSize - 1);
                                g2.drawLine(xr, yr, xr + ImageFromBlocksVis.this.blockSize - 1, yr);
                                g2.setColor(i == 0 ? this.grid2 : this.grid4);
                                g2.drawLine(xr + ImageFromBlocksVis.this.blockSize - 1, yr, xr + ImageFromBlocksVis.this.blockSize - 1, yr + ImageFromBlocksVis.this.blockSize - 1);
                                g2.drawLine(xr, yr + ImageFromBlocksVis.this.blockSize - 1, xr + ImageFromBlocksVis.this.blockSize - 1, yr + ImageFromBlocksVis.this.blockSize - 1);
                                ++i;
                            }
                        }
                        ++c;
                    }
                    ++r;
                }
                g2.dispose();
            }
            g2 = (Graphics2D)g;
            g2.setColor(Color.lightGray);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            double zoomFactor = Math.min((double)this.getWidth() / (double)this.paint2.getWidth(), (double)this.getHeight() / (double)this.paint2.getHeight());
            int w = (int)((double)this.paint2.getWidth() * zoomFactor);
            int h = (int)((double)this.paint2.getHeight() * zoomFactor);
            g2.drawImage(this.paint2, (this.getWidth() - w) / 2, (this.getHeight() - h) / 2, w, h, null);
        }

        private void paintImage(BufferedImage img, Graphics2D g, int x, int y, int w, int h) {
            g.drawImage(img, x, y, w, h, null);
            g.setColor(Color.gray);
            g.drawRect(x, y, w, h);
        }

        private void paintBoard(Graphics2D g, int x, int y, int w, int h) {
            int off = ImageFromBlocksVis.this.blockSize * 5;
            if (coloredPieces) {
                g.setColor(Color.black);
                g.fillRect(x, y + off, w, h - off);
            } else {
                g.drawImage(ImageFromBlocksVis.this.image, x, y + off, w, h - off, null);
            }
            g.setColor(Color.gray);
            g.drawRect(x - 1, y + off - 1, w + 1, h - off + 1);
            int r = 0;
            while (r < ImageFromBlocksVis.this.boardHeight) {
                int c = 0;
                while (c < ImageFromBlocksVis.this.boardWidth) {
                    int color = ImageFromBlocksVis.this.boardColors[r][c];
                    if (color != -1) {
                        if (coloredPieces) {
                            color = this.pieceColors[ImageFromBlocksVis.this.boardPieces[r][c]];
                        }
                        int xr = x + c * ImageFromBlocksVis.this.blockSize;
                        int yr = y + off + r * ImageFromBlocksVis.this.blockSize;
                        g.setColor(new Color(color));
                        g.fillRect(xr, yr, ImageFromBlocksVis.this.blockSize, ImageFromBlocksVis.this.blockSize);
                        if (drawBorder) {
                            g.setColor(this.grid1);
                            g.drawLine(xr, yr, xr, yr + ImageFromBlocksVis.this.blockSize - 1);
                            g.drawLine(xr, yr, xr + ImageFromBlocksVis.this.blockSize - 1, yr);
                            g.setColor(this.grid2);
                            g.drawLine(xr + ImageFromBlocksVis.this.blockSize - 1, yr, xr + ImageFromBlocksVis.this.blockSize - 1, yr + ImageFromBlocksVis.this.blockSize - 1);
                            g.drawLine(xr, yr + ImageFromBlocksVis.this.blockSize - 1, xr + ImageFromBlocksVis.this.blockSize - 1, yr + ImageFromBlocksVis.this.blockSize - 1);
                        }
                    }
                    ++c;
                }
                ++r;
            }
        }

        private void ds(Graphics2D g, String s, int x, int y, int w, int h, int align) {
            FontMetrics metrics = g.getFontMetrics();
            Rectangle2D rect = metrics.getStringBounds(s, g);
            int th = (int)rect.getHeight();
            int tw = (int)rect.getWidth();
            if (align == 0) {
                x += (w - tw) / 2;
            } else if (align == 1) {
                x += w - tw;
            }
            y = y + (h - th) / 2 + metrics.getAscent();
            g.drawString(s, x, y);
        }

        private void fill(Graphics2D g, int x, int y, int w, int h, double pct) {
            g.setColor(this.fillColor);
            g.fillRect(x, y, (int)Math.round((double)w * pct), h);
            g.setColor(Color.gray);
            g.drawRect(x, y, w, h);
        }

        private void preview() {
            this.yPreview = ImageFromBlocksVis.this.currPiece == null ? -1 : ImageFromBlocksVis.this.canPlacePiece(this.xPiece, this.rot);
        }

        private void checkX() {
            while (this.xPiece > ImageFromBlocksVis.this.boardWidth - (this.rot % 2 == 0 ? ImageFromBlocksVis.this.currPiece[0].length : ImageFromBlocksVis.this.currPiece.length)) {
                --this.xPiece;
            }
        }

        private void animMove(int xt, int yt, int rott) {
            if (anim <= 0) {
                return;
            }
            int d = anim / Math.max(ImageFromBlocksVis.this.boardHeight, ImageFromBlocksVis.this.boardWidth);
            this.rot = rott;
            this.checkX();
            this.repaint();
            ImageFromBlocksVis.this.delay(delay);
            while (this.xPiece != xt) {
                this.xPiece = this.xPiece > xt ? --this.xPiece : ++this.xPiece;
                this.repaint();
                ImageFromBlocksVis.this.delay(d);
            }
            int i = -4;
            while (i < yt) {
                this.yPiece = i + 5;
                this.repaint();
                ImageFromBlocksVis.this.delay(d);
                ++i;
            }
        }

        private void reset() {
            this.yPiece = 0;
            this.rot = 0;
        }

        public Vis() {
            this.setFocusable(true);
            ImageFromBlocksVis.this.jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (proc != null) {
                        try {
                            proc.destroy();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                    System.exit(0);
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == 'b') {
                        drawBorder = !drawBorder;
                        Vis.this.fullRepaint();
                    }
                    if (e.getKeyChar() == 'c') {
                        coloredPieces = !coloredPieces;
                        Vis.this.fullRepaint();
                    }
                    if (e.getKeyChar() == ' ') {
                        if (paused == 0) {
                            paused = 1;
                        } else {
                            paused = 0;
                        }
                    }
                    if (e.getKeyChar() == 'n' && paused == 1) {
                        paused = 2;
                    }
                    if (ImageFromBlocksVis.this.currPiece == null || Vis.this.waiting.get() || exec != null) {
                        return;
                    }
                    if (e.getKeyChar() == 'd' && ImageFromBlocksVis.this.discardPiece()) {
                        Vis.this.rot = 0;
                        ImageFromBlocksVis.this.nextPiece();
                        Vis.this.checkX();
                        Vis.this.preview();
                        Vis.this.repaint();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int y;
                    if (Vis.this.waiting.get()) {
                        e.consume();
                        return;
                    }
                    if (ImageFromBlocksVis.this.currPiece == null || exec != null) {
                        return;
                    }
                    if (e.getKeyCode() == 37) {
                        if (Vis.this.xPiece > 0) {
                            Vis vis = Vis.this;
                            vis.xPiece = vis.xPiece - 1;
                        }
                        Vis.this.preview();
                        Vis.this.repaint();
                    }
                    if (e.getKeyCode() == 39) {
                        Vis vis = Vis.this;
                        vis.xPiece = vis.xPiece + 1;
                        Vis.this.checkX();
                        Vis.this.preview();
                        Vis.this.repaint();
                    }
                    if (e.getKeyCode() == 38) {
                        Vis vis = Vis.this;
                        int n = vis.rot + 1;
                        vis.rot = n;
                        if (n == 4) {
                            Vis.this.rot = 0;
                        }
                        Vis.this.checkX();
                        Vis.this.preview();
                        Vis.this.repaint();
                    }
                    if (e.getKeyCode() == 40 && (y = ImageFromBlocksVis.this.canPlacePiece(Vis.this.xPiece, Vis.this.rot)) >= 0) {
                        Thread tp = new Thread(){

                            @Override
                            public void run() {
                                Vis.this.waiting.set(true);
                                if (anim > 0) {
                                    int d = anim / ImageFromBlocksVis.this.boardHeight;
                                    int i = -4;
                                    while (i < y) {
                                        Vis.this.yPiece = i + 5;
                                        Vis.this.repaint();
                                        ImageFromBlocksVis.this.delay(d);
                                        ++i;
                                    }
                                }
                                ImageFromBlocksVis.this.doPlacePiece(Vis.this.xPiece, y, Vis.this.rot);
                                Vis.this.yPiece = 0;
                                Vis.this.rot = 0;
                                ImageFromBlocksVis.this.nextPiece();
                                Vis.this.checkX();
                                Vis.this.preview();
                                Vis.this.fullRepaint();
                                Vis.this.waiting.set(false);
                            }
                        };
                        tp.start();
                    }
                }
            });
        }

        static /* synthetic */ void access$9(Vis vis, int n, int n2, int n3) {
            vis.animMove(n, n2, n3);
        }

        static /* synthetic */ void access$10(Vis vis) {
            vis.reset();
        }
    }
}

