/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.helpers;

import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;

public class Loader {
    private static boolean java1;
    private static boolean ignoreTCL;

    public static URL getResource(String string) {
        ClassLoader classLoader = null;
        URL uRL = null;
        try {
            if (!java1 && !ignoreTCL && (classLoader = Loader.getTCL()) != null) {
                LogLog.debug("Trying to find [" + string + "] using context classloader " + classLoader + ".");
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
            }
            if ((classLoader = Loader.class.getClassLoader()) != null) {
                LogLog.debug("Trying to find [" + string + "] using " + classLoader + " class loader.");
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            LogLog.warn("Caught Exception while in Loader.getResource. This may be innocuous.", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof InterruptedException || invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
            LogLog.warn("Caught Exception while in Loader.getResource. This may be innocuous.", invocationTargetException);
        }
        catch (Throwable throwable) {
            LogLog.warn("Caught Exception while in Loader.getResource. This may be innocuous.", throwable);
        }
        LogLog.debug("Trying to find [" + string + "] using ClassLoader.getSystemResource().");
        return ClassLoader.getSystemResource(string);
    }

    private static ClassLoader getTCL() throws IllegalAccessException, InvocationTargetException {
        Method method = null;
        try {
            method = Thread.class.getMethod("getContextClassLoader", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        return (ClassLoader)method.invoke((Object)Thread.currentThread(), null);
    }

    public static Class loadClass(String string) throws ClassNotFoundException {
        if (java1 || ignoreTCL) {
            return Class.forName(string);
        }
        try {
            return Loader.getTCL().loadClass(string);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof InterruptedException || invocationTargetException.getTargetException() instanceof InterruptedIOException) {
                Thread.currentThread().interrupt();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(string);
    }

    static {
        String string;
        int n;
        java1 = true;
        ignoreTCL = false;
        String string2 = OptionConverter.getSystemProperty("java.version", null);
        if (string2 != null && (n = string2.indexOf(46)) != -1 && string2.charAt(n + 1) != '1') {
            java1 = false;
        }
        if ((string = OptionConverter.getSystemProperty("log4j.ignoreTCL", null)) != null) {
            ignoreTCL = OptionConverter.toBoolean(string, true);
        }
    }
}

