/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter.rules;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class RuleHelper {
    private RuleHelper() {
    }

    public static void checkNull(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("The parameter '" + string + "' should not be null.");
        }
    }

    public static String getNodeText(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Null node is illegal.");
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("The node must be an element node.");
        }
        String string = node.getNodeName();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            String string2 = node.getNodeValue();
            if (string2 == null || string2.trim().length() == 0) {
                throw new IllegalArgumentException("Value of property '" + string + "' is illegal.");
            }
            return string2;
        }
        throw new IllegalArgumentException("Text node cann't be found.");
    }

    public static String getNodeTextWithoutTrimEmptyCheck(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Null node is illegal.");
        }
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("The node must be an element node.");
        }
        String string = node.getNodeName();
        for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3) continue;
            String string2 = node.getNodeValue();
            if (string2 == null || string2.length() == 0) {
                throw new IllegalArgumentException("Value of property '" + string + "' cannot be found.");
            }
            return string2;
        }
        throw new IllegalArgumentException("Text node cann't be found.");
    }

    public static void checkNullEmptyParam(String string, String string2) {
        RuleHelper.checkNull(string, string2);
        if (string.length() == 0) {
            throw new IllegalArgumentException("Paramteter '" + string2 + "' should not be empty.");
        }
    }

    public static Element getSingleChildElementByName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            throw new IllegalArgumentException(element.getNodeName() + " have more than one " + string + " elements.");
        }
        if (nodeList.getLength() == 0) {
            throw new IllegalArgumentException(element.getNodeName() + " don't have " + string + " element.");
        }
        Node node = nodeList.item(0);
        if (node.getParentNode() == element) {
            return (Element)node;
        }
        throw new IllegalArgumentException(element.getNodeName() + " don't have child " + string + " element.");
    }
}

