/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter.rules;

import com.topcoder.util.syntaxhighlighter.HighlightedSequence;
import com.topcoder.util.syntaxhighlighter.RuleMatchException;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.RuleHelper;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PatternMatchRule
implements Rule {
    private static final String PATTERN_NODE_NAME = "pattern";
    private final Pattern pattern;

    public PatternMatchRule(Node node) {
        RuleHelper.checkNull(node, "node");
        if (node.getNodeType() != 1) {
            throw new IllegalArgumentException("node is not a element.");
        }
        String string = RuleHelper.getNodeTextWithoutTrimEmptyCheck(RuleHelper.getSingleChildElementByName((Element)node, PATTERN_NODE_NAME));
        try {
            this.pattern = Pattern.compile(string, 32);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Problems occurs in pattern's compile.");
        }
    }

    public PatternMatchRule(String string) {
        RuleHelper.checkNull(string, PATTERN_NODE_NAME);
        if (string.length() == 0) {
            throw new IllegalArgumentException("Paramteter 'pattern' should not be empty.");
        }
        try {
            this.pattern = Pattern.compile(string, 32);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Problems occurs in pattern's compile.");
        }
    }

    public void applyRule(HighlightedSequence highlightedSequence, TextStyle textStyle) throws RuleMatchException {
        RuleHelper.checkNull(highlightedSequence, "sequence");
        Matcher matcher = this.pattern.matcher(highlightedSequence);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (matcher.find()) {
            arrayList.add(new Integer(matcher.start()));
            arrayList2.add(new Integer(matcher.end()));
        }
        highlightedSequence.highlight(arrayList, arrayList2, textStyle);
    }

    public Rule.Point getToken(HighlightedSequence highlightedSequence) {
        Matcher matcher = this.pattern.matcher(highlightedSequence);
        return matcher.find() ? new Rule.Point(matcher.start(), matcher.end()) : null;
    }
}

