/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.Category;
import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.awt.Color;
import java.awt.Font;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Language {
    private static final String CATEGORY_ROOT_NODE_NAME = "categories";
    private static final String CATEGORY_NODE_NAME = "category";
    private static final String STYLE_ROOT_NODE_NAME = "styles";
    private static final String STYLE_NODE_NAME = "style";
    private static final String STYLE_NAME_ATTRIBUTE_NAME = "name";
    private static final String FONT_NODE_NAME = "font";
    private static final String BGCOLOR_NODE_NAME = "bgcolor";
    private static final String COLOR_NODE_NAME = "color";
    private static final String FONT_FAMILY_NODE_NAME = "family";
    private static final String FONT_STYLE_NODE_NAME = "style";
    private static final String FONT_SIZE_NODE_NAME = "size";
    private static final String COLOR_RED_NODE_NAME = "red";
    private static final String COLOR_BLUE_NODE_NAME = "blue";
    private static final String COLOR_GREEN_NODE_NAME = "green";
    private static final String FONT_BOLD = "BOLD";
    private static final String FONT_PLAIN = "PLAIN";
    private static final String FONT_ITALIC = "ITALIC";
    private static final int MAX_COLOR_VALUE = 255;
    private final Map styles;
    private final Map categories;
    private final String name;

    Language(Document document) throws ConfigurationException {
        Element element = document.getDocumentElement();
        this.name = element.getAttribute(STYLE_NAME_ATTRIBUTE_NAME);
        SHHelper.checkConfigString(this.name, "language-name");
        this.styles = Language.getStylesFromLanguageNode(element);
        this.categories = Language.getCategoriesFromLanguageNode(element, this.styles);
    }

    public TextStyle[] getStyles() {
        return this.styles.values().toArray(new TextStyle[this.styles.size()]);
    }

    public Category[] getCategories() {
        Object[] objectArray = this.categories.values().toArray(new Category[this.categories.size()]);
        Arrays.sort(objectArray);
        return (Category[])objectArray;
    }

    public void addStyle(TextStyle textStyle) {
        SHHelper.checkNull(textStyle, "style");
        if (this.styles.containsKey(textStyle.getName())) {
            throw new IllegalArgumentException("'" + textStyle.getName() + "'is already contained in the Map.");
        }
        this.styles.put(textStyle.getName(), textStyle);
    }

    public void addStyleToCategory(String string, String string2) {
        SHHelper.checkString(string, "categoryName");
        SHHelper.checkString(string2, "styleName");
        TextStyle textStyle = (TextStyle)this.styles.get(string2);
        Category category = (Category)this.categories.get(string);
        if (textStyle == null) {
            throw new IllegalArgumentException("styleName cannot be found in their respective maps.");
        }
        if (category == null) {
            throw new IllegalArgumentException("categoryName cannot be found in their respective maps.");
        }
        category.setStyle(textStyle);
    }

    public void removeStyleFromCategory(String string) {
        SHHelper.checkString(string, "categoryName");
        Category category = this.getCategory(string);
        if (category == null) {
            throw new IllegalArgumentException("Category doesn't exist.");
        }
        category.setStyle(null);
    }

    public String getName() {
        return this.name;
    }

    public Category getCategory(String string) {
        SHHelper.checkString(string, "categoryName");
        return (Category)this.categories.get(string);
    }

    private static Map getCategoriesFromLanguageNode(Node node, Map map) throws ConfigurationException {
        HashMap<String, Category> hashMap = new HashMap<String, Category>();
        Element element = Language.getSingleChildElementByName((Element)node, CATEGORY_ROOT_NODE_NAME);
        NodeList nodeList = element.getElementsByTagName(CATEGORY_NODE_NAME);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getParentNode() != element) {
                throw new ConfigurationException("some category nodes are not the categories's children");
            }
            Category category = new Category(node2, map);
            hashMap.put(category.getName(), category);
        }
        if (hashMap.size() <= 0) {
            throw new ConfigurationException("No categories defined.");
        }
        return hashMap;
    }

    private static Map getStylesFromLanguageNode(Node node) throws ConfigurationException {
        HashMap<String, TextStyle> hashMap = new HashMap<String, TextStyle>();
        Element element = Language.getSingleChildElementByName((Element)node, STYLE_ROOT_NODE_NAME);
        NodeList nodeList = element.getElementsByTagName("style");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getParentNode() != element) continue;
            String string = ((Element)node2).getAttribute(STYLE_NAME_ATTRIBUTE_NAME);
            SHHelper.checkConfigString(string, "style-name");
            Color color = null;
            Color color2 = null;
            Font font = null;
            for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                if (node3.getNodeType() != 1) continue;
                if (node3.getNodeName().equals(COLOR_NODE_NAME)) {
                    if (color != null) {
                        throw new ConfigurationException("color for style is duplicate.");
                    }
                    color = Language.parseColor(node3);
                    continue;
                }
                if (node3.getNodeName().equals(BGCOLOR_NODE_NAME)) {
                    if (color2 != null) {
                        throw new ConfigurationException("bgcolor for style is duplicate.");
                    }
                    color2 = Language.parseColor(node3);
                    continue;
                }
                if (!node3.getNodeName().equals(FONT_NODE_NAME)) continue;
                if (font != null) {
                    throw new ConfigurationException("font for style is duplicate.");
                }
                font = Language.parseFont(node3);
            }
            if (color == null) {
                throw new ConfigurationException("color for style must be contained.");
            }
            hashMap.put(string, new TextStyle(string, font, color, color2));
        }
        if (hashMap.size() <= 0) {
            throw new ConfigurationException("No styles defined.");
        }
        return hashMap;
    }

    private static Color parseColor(Node node) throws ConfigurationException {
        int n = SHHelper.getNodeInteger(Language.getSingleChildElementByName((Element)node, COLOR_RED_NODE_NAME));
        int n2 = SHHelper.getNodeInteger(Language.getSingleChildElementByName((Element)node, COLOR_GREEN_NODE_NAME));
        int n3 = SHHelper.getNodeInteger(Language.getSingleChildElementByName((Element)node, COLOR_BLUE_NODE_NAME));
        Language.checkColorValue(n);
        Language.checkColorValue(n2);
        Language.checkColorValue(n3);
        return new Color(n, n2, n3);
    }

    private static Font parseFont(Node node) throws ConfigurationException {
        String string = SHHelper.getNodeText(Language.getSingleChildElementByName((Element)node, FONT_FAMILY_NODE_NAME));
        int n = SHHelper.getNodeInteger(Language.getSingleChildElementByName((Element)node, FONT_SIZE_NODE_NAME));
        int n2 = 0;
        NodeList nodeList = ((Element)node).getElementsByTagName("style");
        if (nodeList.getLength() > 0) {
            if (nodeList.getLength() > 1) {
                throw new ConfigurationException("font-style property is duplicate.");
            }
            Node node2 = nodeList.item(0);
            if (node2.getParentNode() != node) {
                throw new ConfigurationException("font-style property should be right under the font node.");
            }
            String string2 = SHHelper.getNodeText(node2);
            String[] stringArray = string2.split("\\|");
            for (int i = 0; i < stringArray.length; ++i) {
                n2 |= Language.getFontType(stringArray[i]);
            }
        }
        if (n <= 0) {
            throw new ConfigurationException("Property 'size' in font must be larger than 0.");
        }
        return new Font(string, n2, n);
    }

    private static void checkColorValue(int n) throws ConfigurationException {
        if (n >= 0 && n <= 255) {
            return;
        }
        if (n < 0) {
            throw new ConfigurationException("Color with negative value is illegal.");
        }
        if (n > 255) {
            throw new ConfigurationException("Color value is too large.");
        }
    }

    private static int getFontType(String string) throws ConfigurationException {
        if ((string = string.trim()).equalsIgnoreCase(FONT_PLAIN)) {
            return 0;
        }
        if (string.equalsIgnoreCase(FONT_ITALIC)) {
            return 2;
        }
        if (string.equalsIgnoreCase(FONT_BOLD)) {
            return 1;
        }
        throw new ConfigurationException("Font-type not found.");
    }

    private static Element getSingleChildElementByName(Element element, String string) throws ConfigurationException {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() > 1) {
            throw new ConfigurationException(element.getNodeName() + " have more than one " + string + " elements.");
        }
        if (nodeList.getLength() == 0) {
            throw new ConfigurationException(element.getNodeName() + " don't have " + string + " element.");
        }
        Node node = nodeList.item(0);
        if (node.getParentNode() == element) {
            return (Element)node;
        }
        throw new ConfigurationException(element.getNodeName() + " don't have child " + string + " element.");
    }
}

