/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.ContentSegment;
import com.topcoder.util.syntaxhighlighter.PointIndexer;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.Segment;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public class HighlightedSequence
implements CharSequence {
    private final String originalString;
    private StringBuffer buffer;
    private PointIndexer indexer;
    private final List segments;
    private int lastIndex = 0;
    private String bufferContent;

    public HighlightedSequence(String string) {
        SHHelper.checkString(string, "original");
        this.originalString = string;
        this.buffer = new StringBuffer(string);
        this.segments = new ArrayList();
        this.indexer = new PointIndexer(0, string.length());
    }

    public char charAt(int n) {
        return this.buffer.charAt(n);
    }

    public int length() {
        return this.buffer.length();
    }

    public CharSequence subSequence(int n, int n2) {
        return this.buffer.substring(n, n2);
    }

    public String toString() {
        if (this.bufferContent == null) {
            this.bufferContent = this.buffer.toString();
        }
        return this.bufferContent;
    }

    public void highlight(List list, List list2, TextStyle textStyle) {
        SHHelper.checkList(list, "startPosList", Integer.class);
        SHHelper.checkList(list2, "endPosList", Integer.class);
        if (list.size() != list2.size()) {
            throw new IllegalArgumentException("startPosList and endPosList must be of the same size.");
        }
        StringBuffer stringBuffer = new StringBuffer(this.buffer.length());
        Iterator iterator = list.iterator();
        Iterator iterator2 = list2.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            int n4 = (Integer)iterator2.next();
            if (n3 < 0 || n4 < 0 || n4 > this.buffer.length() || n3 >= n4) {
                throw new IndexOutOfBoundsException("Some start-end pair was not properly specified.");
            }
            if (n < n3) {
                stringBuffer.append(this.buffer.substring(n, n3));
            }
            int n5 = this.indexer.get(n3 - n2);
            int n6 = this.indexer.get(n4 - 1 - n2);
            this.segments.add(new Segment(n5, n6, textStyle));
            this.indexer.remove(n3 - n2, n4 - 1 - n2);
            if (n4 - n2 < this.lastIndex) {
                this.lastIndex -= n4 - n3;
            } else if (n3 - n2 < this.lastIndex) {
                this.lastIndex = n3 - n2;
            }
            n = n4;
            n2 += n4 - n3;
        }
        if (n < this.buffer.length()) {
            stringBuffer.append(this.buffer.substring(n));
        }
        this.buffer = stringBuffer;
        this.bufferContent = null;
    }

    public void highlight(int n, int n2, TextStyle textStyle) {
        if (n < 0 || n2 < 0 || n2 > this.buffer.length() || n >= n2) {
            throw new IndexOutOfBoundsException("The startPos or endPos was not properly specified.");
        }
        int n3 = this.indexer.get(n);
        int n4 = this.indexer.get(n2 - 1);
        this.segments.add(new Segment(n3, n4, textStyle));
        this.buffer = this.buffer.delete(n, n2);
        this.bufferContent = null;
        this.indexer.remove(n, n2 - 1);
        if (n2 < this.lastIndex) {
            this.lastIndex -= n2 - n;
        } else if (n < this.lastIndex) {
            this.lastIndex = n;
        }
    }

    public ContentSegment[] getOrderedSegments() {
        TreeSet<Segment> treeSet = new TreeSet<Segment>();
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        Object object = this.segments.iterator();
        while (object.hasNext()) {
            Segment segment = (Segment)object.next();
            int n = segment.getStart();
            int n2 = segment.getEnd();
            TextStyle textStyle = segment.getStyle();
            SortedSet<Segment> sortedSet = treeSet.headSet(new Segment(n, n, null));
            if (sortedSet.size() > 0) {
                int n3 = sortedSet.last().getEnd() + 1;
                n = n3 > n ? n3 : n;
            }
            SortedSet<Segment> sortedSet2 = treeSet.tailSet(new Segment(n, n, null));
            Iterator iterator = sortedSet2.iterator();
            while (iterator.hasNext() && n <= n2) {
                Segment segment2 = (Segment)iterator.next();
                int n4 = segment2.getStart();
                if (n4 > n2) {
                    arrayList.add(new Segment(n, n2, textStyle));
                    n = n2 + 1;
                    break;
                }
                if (n < n4) {
                    arrayList.add(new Segment(n, n4 - 1, textStyle));
                }
                n = segment2.getEnd() + 1;
            }
            if (n <= n2) {
                arrayList.add(new Segment(n, n2, textStyle));
            }
            treeSet.addAll(arrayList);
            arrayList.clear();
        }
        object = this.fillBlanks(treeSet);
        return object.toArray(new ContentSegment[object.size()]);
    }

    private List fillBlanks(SortedSet sortedSet) {
        ArrayList<ContentSegment> arrayList = new ArrayList<ContentSegment>();
        int n = 0;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext()) {
            Segment segment = (Segment)iterator.next();
            if (segment.getStart() > n) {
                arrayList.add(this.getContentSegment(n, segment.getStart() - 1, null));
            }
            arrayList.add(this.getContentSegment(segment.getStart(), segment.getEnd(), segment.getStyle()));
            n = segment.getEnd() + 1;
        }
        if (n < this.originalString.length()) {
            arrayList.add(this.getContentSegment(n, this.originalString.length() - 1, null));
        }
        return arrayList;
    }

    public void reset() {
        this.lastIndex = 0;
    }

    public ContentSegment getNextToken() {
        int n;
        int n2;
        for (n2 = this.lastIndex; n2 < this.buffer.length() && !Character.isJavaIdentifierStart(this.buffer.charAt(n2)); ++n2) {
        }
        if (n2 >= this.buffer.length()) {
            this.lastIndex = this.buffer.length();
            return null;
        }
        for (n = n2 + 1; n < this.buffer.length() && Character.isJavaIdentifierPart(this.buffer.charAt(n)); ++n) {
        }
        this.lastIndex = n;
        return new ContentSegment(n2, n, null, this.buffer.substring(n2, n));
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        int n2;
        SHHelper.checkNull(string, "str");
        if (string.length() == 0) {
            return -1;
        }
        do {
            if ((n2 = this.buffer.indexOf(string, n)) < 0) {
                return -1;
            }
            if (string.length() >= 2) continue;
            return n2;
        } while ((n = this.indexer.findBreakPoint(n2, n2 + string.length() - 1)) != -1);
        return n2;
    }

    private ContentSegment getContentSegment(int n, int n2, TextStyle textStyle) {
        return new ContentSegment(n, n2, textStyle, this.originalString.substring(n, n2 + 1));
    }
}

