/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.syntaxhighlighter;

import com.topcoder.util.syntaxhighlighter.ConfigurationException;
import com.topcoder.util.syntaxhighlighter.SHHelper;
import com.topcoder.util.syntaxhighlighter.TextStyle;
import com.topcoder.util.syntaxhighlighter.rules.BlockMatchRule;
import com.topcoder.util.syntaxhighlighter.rules.PatternMatchRule;
import com.topcoder.util.syntaxhighlighter.rules.Rule;
import com.topcoder.util.syntaxhighlighter.rules.WordMatchRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Category
implements Comparable {
    private static final String CATEGORY_PRECEDENCE_ATTRIBUTE_NAME = "precedence";
    private static final String CATEGORY_NAME_ATTRIBUTE_NAME = "name";
    private static final String CATEGORY_STYLE_ATTRIBUTE_NAME = "style";
    private static final String BLOCK_MATCH_RULE_NODE_NAME = "blockMatchRule";
    private static final String PATTERN_MATCH_RULE_NODE_NAME = "patternMatchRule";
    private static final String WORD_MATCH_RULE_NODE_NAME = "wordMatchRule";
    private final List rules;
    private TextStyle style;
    private int precedence;
    private final String name;

    Category(Node node, Map map) throws ConfigurationException {
        this.name = ((Element)node).getAttribute(CATEGORY_NAME_ATTRIBUTE_NAME);
        SHHelper.checkConfigString(this.name, "category_name");
        try {
            this.precedence = Integer.parseInt(((Element)node).getAttribute(CATEGORY_PRECEDENCE_ATTRIBUTE_NAME));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Illegal precedence:" + ((Element)node).getAttribute(CATEGORY_PRECEDENCE_ATTRIBUTE_NAME));
        }
        if (this.precedence < 0) {
            throw new ConfigurationException("Illegal precedence:" + this.precedence);
        }
        this.style = (TextStyle)map.get(((Element)node).getAttribute(CATEGORY_STYLE_ATTRIBUTE_NAME));
        if (this.style == null) {
            throw new ConfigurationException("Required style not found in style map.");
        }
        this.rules = new ArrayList();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            try {
                if (string.equals(BLOCK_MATCH_RULE_NODE_NAME)) {
                    this.rules.add(new BlockMatchRule(node2));
                    continue;
                }
                if (string.equals(PATTERN_MATCH_RULE_NODE_NAME)) {
                    this.rules.add(new PatternMatchRule(node2));
                    continue;
                }
                if (string.equals(WORD_MATCH_RULE_NODE_NAME)) {
                    this.rules.add(new WordMatchRule(node2));
                    continue;
                }
                throw new ConfigurationException("'blockMatchRule' or 'patternMatchRule' or 'wordMatchRule' expected.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ConfigurationException("There are some errors in the config:" + illegalArgumentException.getMessage());
            }
        }
    }

    public Category(String string, List list, TextStyle textStyle, int n) {
        SHHelper.checkString(string, CATEGORY_NAME_ATTRIBUTE_NAME);
        SHHelper.checkNegative(n, CATEGORY_PRECEDENCE_ATTRIBUTE_NAME);
        SHHelper.checkList(list, "rules", Rule.class);
        if (list.size() == 0) {
            throw new IllegalArgumentException("Parameter 'rules' is empty.");
        }
        this.name = string;
        this.rules = new ArrayList(list);
        this.style = textStyle;
        this.precedence = n;
    }

    public Rule[] getRules() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    void setStyle(TextStyle textStyle) {
        this.style = textStyle;
    }

    public void addRule(Rule rule) {
        SHHelper.checkNull(rule, "rule");
        this.rules.add(rule);
    }

    public void clearRules() {
        this.rules.clear();
    }

    public int compareTo(Object object) {
        SHHelper.checkNull(object, "obj");
        return this.precedence - ((Category)object).getPrecedence();
    }

    public void setPrecedence(int n) {
        SHHelper.checkNegative(n, CATEGORY_PRECEDENCE_ATTRIBUTE_NAME);
        this.precedence = n;
    }

    public String getName() {
        return this.name;
    }
}

