/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.errorhandling;

import java.io.PrintStream;
import java.io.PrintWriter;

public class BaseException
extends Exception {
    private Throwable cause;
    private boolean isCauseInitialized = false;

    public BaseException() {
    }

    public BaseException(String string) {
        super(string);
    }

    public BaseException(String string, Throwable throwable) {
        super(string);
        this.cause = throwable;
        this.isCauseInitialized = true;
    }

    public BaseException(Throwable throwable) {
        super(throwable == null ? null : throwable.toString());
        this.cause = throwable;
        this.isCauseInitialized = true;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public Throwable initCause(Throwable throwable) {
        if (throwable == this) {
            throw new IllegalArgumentException("this cannot be its own cause");
        }
        if (this.isCauseInitialized) {
            throw new IllegalStateException("cause was previously initialized or set");
        }
        this.isCauseInitialized = true;
        this.cause = throwable;
        return this;
    }

    public String getMessage() {
        String string = super.getMessage();
        if (this.cause != null) {
            string = string + ", caused by " + this.cause.getMessage();
        }
        return string;
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        if (printStream == null) {
            throw new NullPointerException("PrintStream cannot be null");
        }
        super.printStackTrace(printStream);
        if (this.cause != null) {
            printStream.print("Caused by:");
            this.cause.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (printWriter == null) {
            throw new NullPointerException("PrintWriter cannot be null");
        }
        super.printStackTrace(printWriter);
        if (this.cause != null) {
            printWriter.print("Caused by:");
            this.cause.printStackTrace(printWriter);
        }
    }
}

