/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigParserException;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.PropConfigProperties;
import com.topcoder.util.config.Property;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class XMLConfigProperties
extends ConfigProperties
implements ErrorHandler {
    private Document document = null;
    private URL source = null;
    private String namespace = null;
    private PrintWriter writer = null;

    private XMLConfigProperties() {
    }

    XMLConfigProperties(URL uRL, String string) throws ConfigParserException, IOException {
        this.source = uRL;
        this.namespace = string;
        this.load();
    }

    XMLConfigProperties(URL uRL) throws ConfigParserException, IOException {
        this.source = uRL;
        this.load();
    }

    static Enumeration getNamespaces(URL uRL) throws ConfigParserException {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigParserException("Error occurred obtaining Document Builder Factory: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigParserException("The underlying parser does not support the requested features: " + parserConfigurationException.getMessage());
        }
        Document document = null;
        try {
            object = new InputSource(uRL.openStream());
            document = documentBuilder.parse((InputSource)object);
        }
        catch (SAXException sAXException) {
            throw new ConfigParserException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new ConfigParserException(iOException.getMessage());
        }
        object = new Vector();
        XMLConfigProperties.traverseToGetNamespaceNodes(document, (Vector)object);
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = ((Vector)object).elements();
        while (enumeration.hasMoreElements()) {
            Attr attr = ((Element)enumeration.nextElement()).getAttributeNode("name");
            if (attr == null) {
                throw new ConfigParserException("incorrect xml format");
            }
            vector.add(attr.getNodeValue());
        }
        return vector.elements();
    }

    protected static void traverseToGetNamespaceNodes(Node node, Vector vector) {
        if (node.getNodeType() == 1 && node.getNodeName().equals("Config")) {
            vector.add(node);
        } else {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                XMLConfigProperties.traverseToGetNamespaceNodes(nodeList.item(i), vector);
            }
        }
    }

    private void updateProperty(Node node, Property property) {
        String[] stringArray;
        List list = property.getComments();
        if (list != null) {
            stringArray = list.iterator();
            while (stringArray.hasNext()) {
                node.appendChild(this.document.createComment((String)stringArray.next()));
            }
        }
        stringArray = property.getValues();
        List list2 = property.list();
        if (stringArray != null && stringArray.length > 0 || !list2.isEmpty()) {
            Element element = this.document.createElement("Property");
            element.setAttribute("name", property.getName());
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    Element element2 = this.document.createElement("Value");
                    element2.appendChild(this.document.createTextNode(stringArray[i]));
                    element.appendChild(element2);
                }
            }
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                this.updateProperty(element, (Property)iterator.next());
            }
            node.appendChild(element);
        }
    }

    private void writeNormalized(String string) {
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.writer.print("&lt;");
                    continue block7;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block7;
                }
                case '&': {
                    this.writer.print("&amp;");
                    continue block7;
                }
                case '\"': {
                    this.writer.print("&quot;");
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    this.writer.print("&#");
                    this.writer.print(Integer.toString(c));
                    this.writer.print(';');
                    continue block7;
                }
                default: {
                    this.writer.print(c);
                }
            }
        }
    }

    private void writeProperty(Node node, int n) {
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node;
                this.writer.println("<?xml version=\"1.0\"?>");
                if (document.getDoctype() != null) {
                    this.writeProperty(document.getDoctype(), 0);
                }
                if (document.getDocumentElement() == null) break;
                this.writeProperty(document.getDocumentElement(), 0);
                break;
            }
            case 10: {
                DocumentType documentType = (DocumentType)node;
                this.writer.print("<!DOCTYPE ");
                this.writer.print(documentType.getName());
                String string = documentType.getPublicId();
                String string2 = documentType.getSystemId();
                if (string != null) {
                    this.writer.print(" PUBLIC '");
                    this.writer.print(string);
                    this.writer.print("' '");
                    this.writer.print(string2);
                    this.writer.print('\'');
                } else {
                    this.writer.print(" SYSTEM '");
                    this.writer.print(string2);
                    this.writer.print('\'');
                }
                String string3 = documentType.getInternalSubset();
                if (string3 != null) {
                    this.writer.println(" [");
                    this.writer.print(string3);
                    this.writer.print(']');
                }
                this.writer.println('>');
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    this.writer.print("    ");
                }
                this.writer.print('<');
                this.writer.print(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Attr attr = (Attr)namedNodeMap.item(i);
                    this.writer.print(' ');
                    this.writer.print(attr.getNodeName());
                    this.writer.print("=\"");
                    this.writeNormalized(attr.getNodeValue());
                    this.writer.print('\"');
                }
                this.writer.print('>');
                if (!node.getNodeName().equals("Value") && !node.getNodeName().equals("ListDelimiter")) {
                    this.writer.println();
                }
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    this.writeProperty(node2, n + 1);
                }
                if (!node.getNodeName().equals("Value") && !node.getNodeName().equals("ListDelimiter")) {
                    for (int i = 0; i < n; ++i) {
                        this.writer.print("    ");
                    }
                }
                this.writer.print("</");
                this.writer.print(node.getNodeName());
                this.writer.println('>');
                break;
            }
            case 3: {
                Node node3 = node.getParentNode();
                if (node3.getNodeType() != 1 || !node3.getNodeName().equals("Value") && !node3.getNodeName().equals("ListDelimiter")) break;
                this.writer.print(node.getNodeValue());
                break;
            }
            case 8: {
                if (this.namespace == null) {
                    this.writer.print("    ");
                } else {
                    this.writer.print("        ");
                }
                this.writer.print("<!--");
                this.writer.print(((Comment)node).getData());
                this.writer.println("-->");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() throws IOException {
        Object object;
        if (!this.source.getProtocol().equals("file")) {
            throw new UnsupportedOperationException("source is not a physical file");
        }
        Node node = this.getNamespaceRootNode(this.document);
        while (node.getFirstChild() != null) {
            node.removeChild(node.getFirstChild());
        }
        if (this.getListDelimiter() != ';') {
            object = this.document.createElement("ListDelimiter");
            object.appendChild(this.document.createTextNode("" + this.getListDelimiter()));
            node.appendChild((Node)object);
        }
        object = this.getRoot().list().iterator();
        while (object.hasNext()) {
            this.updateProperty(node, (Property)object.next());
        }
        try {
            this.writer = new PrintWriter(new FileWriter(ConfigManager.decodeURL(this.source.getFile())));
            this.writeProperty(this.document, 0);
        }
        finally {
            if (this.writer != null) {
                this.writer.close();
                this.writer = null;
            }
        }
    }

    private Node getNamespaceRootNode(Node node) throws ConfigParserException {
        Object object;
        if (node.getNodeType() == 1) {
            if (this.namespace == null) {
                if (node.getNodeName().equals("CMConfig")) {
                    return node;
                }
            } else if (node.getNodeName().equals("Config")) {
                object = ((Element)node).getAttributeNode("name");
                if (object == null) {
                    throw new ConfigParserException("incorrect xml format");
                }
                if (object.getNodeValue().equals(this.namespace)) {
                    return node;
                }
            }
        }
        object = node.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Node node2 = this.getNamespaceRootNode(object.item(i));
            if (node2 == null) continue;
            return node2;
        }
        return null;
    }

    private void loadNode(Property property, Node node, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object object;
            node = nodeList.item(i);
            if (node.getNodeType() == 8) {
                arrayList.add(((Comment)node).getData());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getNodeName().equals("Property")) {
                Object object2;
                boolean bl = false;
                object = ((Element)node).getAttributeNode("name");
                if (object == null) {
                    throw new ConfigParserException("incorrect xml format");
                }
                String string2 = string + object.getNodeValue();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                NodeList nodeList2 = node.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    object2 = nodeList2.item(j);
                    if (object2.getNodeType() == 8) {
                        arrayList.add(((Comment)object2).getData());
                        continue;
                    }
                    if (object2.getNodeType() != 1) continue;
                    if (object2.getNodeName().equals("Property")) {
                        bl = true;
                        continue;
                    }
                    if (object2.getNodeName().equals("Value")) {
                        Node node2 = object2.getFirstChild();
                        if (node2 == null) {
                            arrayList2.add("");
                        } else if (node2.getNodeType() == 3) {
                            arrayList2.addAll(PropConfigProperties.parseValueString(((Text)node2).getData(), this.getListDelimiter()));
                        } else {
                            throw new ConfigParserException("invalid subnode");
                        }
                        if (node2 == null || node2.getNextSibling() == null) continue;
                        throw new ConfigParserException("invalid subnode");
                    }
                    throw new ConfigParserException("unrecognized element " + object2.getNodeName());
                }
                if (arrayList2.size() > 0) {
                    Property property2 = property.find(string2);
                    if (property2 != null && property2.getValue() != null) {
                        throw new ConfigParserException("contains duplicate property " + string2);
                    }
                    property.setProperty(string2, arrayList2.toArray(new String[arrayList2.size()]));
                    if (arrayList.size() > 0) {
                        property2 = property.find(string2);
                        object2 = arrayList.iterator();
                        while (object2.hasNext()) {
                            property2.addComment((String)object2.next());
                        }
                        arrayList.clear();
                    }
                }
                if (!bl) continue;
                this.loadNode(property, node, string2 + ".");
                continue;
            }
            if (node.getNodeName().equals("ListDelimiter")) {
                Node node3 = node.getFirstChild();
                if (node3 == null) {
                    throw new ConfigParserException("invalid delimiter");
                }
                if (node3.getNodeType() == 3) {
                    object = ((Text)node3).getData();
                    if (object == null || ((String)object).length() != 1) {
                        throw new ConfigParserException("invalid delimiter");
                    }
                } else {
                    throw new ConfigParserException("invalid delimiter");
                }
                this.setListDelimiter(((String)object).charAt(0));
                if (node3.getNextSibling() == null) continue;
                throw new ConfigParserException("invalid subnode");
            }
            if (node.getNodeName().equals("Value")) continue;
            throw new ConfigParserException("unrecognized element " + node.getNodeName());
        }
    }

    protected void load() throws IOException {
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ConfigParserException("Error occurred obtaining Document Builder Factory: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ConfigParserException("The underlying parser does not support the requested features: " + parserConfigurationException.getMessage());
        }
        documentBuilder.setErrorHandler(this);
        InputSource inputSource = new InputSource(this.source.openStream());
        try {
            this.document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw new ConfigParserException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new ConfigParserException(iOException.getMessage());
        }
        Node node = this.getNamespaceRootNode(this.document);
        if (node == null) {
            throw new ConfigParserException("can not locate namespace " + this.namespace);
        }
        try {
            Property property = new Property();
            this.loadNode(property, node, "");
            this.setRoot(property);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new ConfigParserException(exception.getMessage());
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        System.err.println("warning : " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        System.err.println("error : " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("fatal error : " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    public Object clone() {
        XMLConfigProperties xMLConfigProperties = new XMLConfigProperties();
        xMLConfigProperties.source = this.source;
        xMLConfigProperties.namespace = this.namespace;
        xMLConfigProperties.document = this.document;
        xMLConfigProperties.setRoot((Property)this.getRoot().clone());
        return xMLConfigProperties;
    }
}

