/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigLockedException;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigProperties;
import com.topcoder.util.config.UnknownNamespaceException;
import java.net.URL;
import java.util.Iterator;

class Namespace {
    private String name = null;
    private String format = null;
    private URL file = null;
    private int exceptionLevel = 0;
    private ConfigProperties properties = null;
    private boolean lock = false;
    private String user = null;

    Namespace(String string, URL uRL, String string2, int n, ConfigProperties configProperties) {
        this.name = string;
        this.file = uRL;
        this.format = string2;
        this.exceptionLevel = n;
        this.properties = configProperties;
    }

    URL getFile() {
        return this.file;
    }

    ConfigProperties getProperties() {
        return this.properties;
    }

    void lock(String string) throws ConfigLockedException, UnknownNamespaceException {
        if (this.lock && !this.user.equals(string)) {
            throw new ConfigLockedException(string + " can not lock namespace " + this.name);
        }
        ConfigManager configManager = ConfigManager.getInstance();
        Iterator iterator = configManager.getAllNamespaces();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = configManager.getConfigFilename(string2);
            if (!this.file.getFile().equals(string3) || configManager.canLock(string2, string)) continue;
            throw new ConfigLockedException("the source of " + this.name + " is already locked");
        }
        this.lock = true;
        this.user = string;
    }

    void releaseLock() {
        this.lock = false;
        this.user = null;
    }

    boolean canLock(String string) {
        return !this.lock || this.user.equals(string);
    }
}

