/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.util.config;

import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.ConfigManagerInterface;
import com.topcoder.util.config.DefaultConfigManager;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownNamespaceException;
import com.topcoder.util.config.XMLConfigProperties;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;

public abstract class ConfigManager
implements ConfigManagerInterface {
    private static ConfigManager defaultConfigManager = null;

    static URL getURL(String string) throws ConfigManagerException {
        if (new File(string).isAbsolute()) {
            try {
                return new URL("file:" + string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ConfigManagerException(string + " is invalid");
            }
        }
        try {
            URL uRL = ConfigManager.class.getClassLoader().getResource(string);
            if (uRL != null) {
                return uRL;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        throw new ConfigManagerException("can not locate " + string);
    }

    static String decodeURL(String string) throws ConfigManagerException {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ConfigManagerException("The URL is not encoded with UTF-8.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigManager getInstance() {
        if (defaultConfigManager != null) return defaultConfigManager;
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            Object object;
            if (defaultConfigManager != null) return defaultConfigManager;
            defaultConfigManager = new DefaultConfigManager();
            try {
                object = ConfigManager.class.getClassLoader().getResource("com/topcoder/util/config/ConfigManager.properties");
                if (object == null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return defaultConfigManager;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultConfigManager;
            }
            try {
                object = ConfigManager.getURL("com/topcoder/util/config/ConfigManager.properties").openStream();
                Properties properties = new Properties();
                try {
                    properties.load((InputStream)object);
                }
                finally {
                    ((InputStream)object).close();
                }
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    try {
                        if (string2 == null || string2.length() == 0) {
                            defaultConfigManager.add(string, ".xml");
                            continue;
                        }
                        String string3 = string2.toLowerCase();
                        if (string3.endsWith(".properties")) {
                            defaultConfigManager.add(string, string2, ".properties");
                            continue;
                        }
                        if (string3.endsWith(".config")) {
                            defaultConfigManager.add(string, string2, ".config");
                            continue;
                        }
                        if (string3.endsWith(".xml")) {
                            Enumeration enumeration2 = XMLConfigProperties.getNamespaces(ConfigManager.getURL(string2));
                            if (enumeration2 != null && enumeration2.hasMoreElements()) {
                                defaultConfigManager.add(string, string2, "MXML");
                                continue;
                            }
                            defaultConfigManager.add(string, string2, ".xml");
                            continue;
                        }
                        System.err.println("unrecognized file type : " + string2);
                    }
                    catch (Exception exception) {
                        System.err.println("encounter exception loading " + string2 + " : " + exception.getMessage());
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return defaultConfigManager;
        }
    }

    public abstract void add(String var1, String var2, String var3) throws ConfigManagerException;

    public abstract void add(String var1, String var2) throws ConfigManagerException;

    public abstract void add(URL var1) throws ConfigManagerException;

    public abstract Property getPropertyObject(String var1, String var2) throws UnknownNamespaceException;

    public abstract String getString(String var1, String var2) throws UnknownNamespaceException;

    public abstract String[] getStringArray(String var1, String var2) throws UnknownNamespaceException;

    public abstract boolean existsNamespace(String var1);

    public abstract String getConfigFilename(String var1) throws UnknownNamespaceException;

    public abstract Iterator getAllNamespaces();

    public abstract void commit(String var1, String var2) throws ConfigManagerException;

    public abstract boolean canLock(String var1, String var2) throws UnknownNamespaceException;

    public abstract void createTemporaryProperties(String var1) throws UnknownNamespaceException;

    public abstract void setProperty(String var1, String var2, String var3) throws UnknownNamespaceException;

    public abstract void removeProperty(String var1, String var2) throws UnknownNamespaceException;
}

