/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.InvalidTypeException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;

public class SimpleDataTypeFactory {
    protected static HashMap types = new HashMap();
    protected static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        try {
            Method method = Class.forName("com.topcoder.shared.problem.DataTypeFactory").getDeclaredMethod("initializeFromDB", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static DataType getDataType(String string) throws InvalidTypeException {
        SimpleDataTypeFactory.initialize();
        DataType dataType = (DataType)types.get(string);
        if (dataType == null) {
            throw new InvalidTypeException(string);
        }
        return dataType.cloneDataType();
    }

    public static DataType getDataType(int n) throws InvalidTypeException {
        SimpleDataTypeFactory.initialize();
        DataType dataType = (DataType)types.get(new Integer(n));
        if (dataType == null) {
            throw new InvalidTypeException(new String("" + n));
        }
        return dataType.cloneDataType();
    }

    static void registerDataType(DataType dataType) {
        initialized = true;
        if (types.containsKey(dataType.getDescription())) {
            return;
        }
        types.put(dataType.getDescription(), dataType.cloneDataType());
        types.put(new Integer(dataType.getID()), dataType.cloneDataType());
    }

    public static Collection getDataTypes() {
        SimpleDataTypeFactory.initialize();
        return types.values();
    }
}

