/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.ProblemCustomSettings;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;

public class SimpleComponent
implements Serializable,
CustomSerializable {
    int problemID;
    int componentID;
    int componentTypeID;
    int roundType;
    String className;
    String methodName;
    DataType[] paramTypes;
    DataType returnType;
    Long[] webServiceDependencies = null;
    private ProblemCustomSettings problemCustomSettings = new ProblemCustomSettings();

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeString(this.className);
        cSWriter.writeString(this.methodName);
        cSWriter.writeObject(this.returnType);
        cSWriter.writeObjectArray(this.paramTypes);
        cSWriter.writeInt(this.componentID);
        cSWriter.writeInt(this.componentTypeID);
        cSWriter.writeInt(this.problemID);
        cSWriter.writeInt(this.roundType);
        cSWriter.writeObject(this.problemCustomSettings);
        cSWriter.writeObjectArray(this.webServiceDependencies);
    }

    public void customReadObject(CSReader cSReader) throws IOException {
        this.className = cSReader.readString();
        this.methodName = cSReader.readString();
        this.returnType = (DataType)cSReader.readObject();
        Object[] objectArray = cSReader.readObjectArray();
        this.componentID = cSReader.readInt();
        this.componentTypeID = cSReader.readInt();
        this.problemID = cSReader.readInt();
        this.roundType = cSReader.readInt();
        this.problemCustomSettings = (ProblemCustomSettings)cSReader.readObject();
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        this.paramTypes = new DataType[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.paramTypes[i] = (DataType)objectArray[i];
        }
        this.webServiceDependencies = (Long[])cSReader.readObjectArray(Long.class);
    }

    public int getProblemID() {
        return this.problemID;
    }

    public void setProblemID(int n) {
        this.problemID = n;
    }

    public int getComponentID() {
        return this.componentID;
    }

    public void setComponentID(int n) {
        this.componentID = n;
    }

    public int getComponentTypeID() {
        return this.componentTypeID;
    }

    public void setComponentTypeID(int n) {
        this.componentTypeID = n;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String string) {
        this.className = string;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String string) {
        this.methodName = string;
    }

    public DataType[] getParamTypes() {
        return this.paramTypes;
    }

    public void setParamTypes(DataType[] dataTypeArray) {
        this.paramTypes = dataTypeArray;
    }

    public DataType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(DataType dataType) {
        this.returnType = dataType;
    }

    public static String getCacheKey(int n) {
        return "SimpleProblemComponent." + n;
    }

    public String getCacheKey() {
        return SimpleComponent.getCacheKey(this.componentID);
    }

    public String getReturnType(int n) {
        return this.returnType.getDescriptor(n);
    }

    public boolean hasWebServiceDependencies() {
        return this.webServiceDependencies != null && this.webServiceDependencies.length > 0;
    }

    public Long[] getWebServiceDependencies() {
        return this.webServiceDependencies;
    }

    public void setWebServiceDependencies(Long[] longArray) {
        this.webServiceDependencies = longArray;
    }

    public int getRoundType() {
        return this.roundType;
    }

    public void setRoundType(int n) {
        this.roundType = n;
    }

    public ProblemCustomSettings getProblemCustomSettings() {
        return this.problemCustomSettings;
    }

    public void setProblemCustomSettings(ProblemCustomSettings problemCustomSettings) {
        this.problemCustomSettings = problemCustomSettings;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.shared.problem.SimpleComponent) [");
        stringBuffer.append("problemID = ");
        stringBuffer.append(this.problemID);
        stringBuffer.append(", ");
        stringBuffer.append("componentID = ");
        stringBuffer.append(this.componentID);
        stringBuffer.append(", ");
        stringBuffer.append("componentTypeID = ");
        stringBuffer.append(this.componentTypeID);
        stringBuffer.append(", ");
        stringBuffer.append("roundType = ");
        stringBuffer.append(this.roundType);
        stringBuffer.append(", ");
        stringBuffer.append("executionTimeLimit = ");
        stringBuffer.append(this.problemCustomSettings.getExecutionTimeLimit());
        stringBuffer.append(", ");
        stringBuffer.append("memLimit = ");
        stringBuffer.append(this.problemCustomSettings.getMemLimit());
        stringBuffer.append(", ");
        stringBuffer.append("stackLimit = ");
        stringBuffer.append(this.problemCustomSettings.getStackLimit());
        stringBuffer.append(", ");
        stringBuffer.append("gccBuildCommand = ");
        stringBuffer.append(this.problemCustomSettings.getGccBuildCommand());
        stringBuffer.append(", ");
        stringBuffer.append("cppApprovedPath = ");
        stringBuffer.append(this.problemCustomSettings.getCppApprovedPath());
        stringBuffer.append(", ");
        stringBuffer.append("pythonCommand = ");
        stringBuffer.append(this.problemCustomSettings.getPythonCommand());
        stringBuffer.append(", ");
        stringBuffer.append("pythonApprovedPath = ");
        stringBuffer.append(this.problemCustomSettings.getPythonApprovedPath());
        stringBuffer.append(", ");
        stringBuffer.append("className = ");
        if (this.className == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.className.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("methodName = ");
        if (this.methodName == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.methodName.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("paramTypes = ");
        if (this.paramTypes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("{");
            for (int i = 0; i < this.paramTypes.length; ++i) {
                stringBuffer.append(this.paramTypes[i].toString() + ",");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(", ");
        stringBuffer.append("returnType = ");
        if (this.returnType == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.returnType.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("webServiceDependencies = ");
        if (this.webServiceDependencies == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(Arrays.asList(this.webServiceDependencies));
        }
        stringBuffer.append(", ");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

