/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.apache.log4j.Category;

public class ProblemMessage
implements Serializable,
Cloneable,
CustomSerializable {
    public static short WARNING = 0;
    public static short ERROR = 1;
    public static short FATAL_ERROR = (short)2;
    private int type;
    private int line;
    private int column;
    private String message;

    public ProblemMessage() {
    }

    public ProblemMessage(int n, String string, int n2, int n3) {
        if (string == null) {
            string = "";
        }
        this.type = n;
        this.message = string;
        this.line = n2;
        this.column = n3;
    }

    public ProblemMessage(int n, String string) {
        if (string == null) {
            string = "";
        }
        this.type = n;
        this.message = string;
        this.column = 0;
        this.line = 0;
    }

    public int getType() {
        return this.type;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getMessage() {
        return this.message;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.type);
        cSWriter.writeInt(this.line);
        cSWriter.writeInt(this.column);
        cSWriter.writeString(this.message);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.type = cSReader.readInt();
        this.line = cSReader.readInt();
        this.column = cSReader.readInt();
        this.message = cSReader.readString();
    }

    public void log(Category category) {
        String string = this.toString();
        if (this.type == WARNING) {
            category.warn(string);
        } else if (this.type == ERROR) {
            category.error(string);
        } else if (this.type == FATAL_ERROR) {
            category.fatal(string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.message.length() + 32);
        if (this.line != 0) {
            stringBuffer.append("Line ");
            stringBuffer.append(this.line);
            stringBuffer.append(": ");
        }
        if (this.column != 0) {
            stringBuffer.append("Column ");
            stringBuffer.append(this.column);
            stringBuffer.append(": ");
        }
        stringBuffer.append(this.message);
        return stringBuffer.toString();
    }
}

