/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import com.topcoder.shared.problem.ProblemComponent;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class ProblemCustomSettings
implements Serializable,
CustomSerializable {
    private int compileTimeLimit;
    private String gccBuildCommand;
    private String pythonCommand;
    private String cppApprovedPath;
    private String pythonApprovedPath;
    private int executionTimeLimit;
    private int memLimit;
    private int stackLimit;

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.compileTimeLimit);
        cSWriter.writeString(this.gccBuildCommand);
        cSWriter.writeString(this.pythonCommand);
        cSWriter.writeString(this.cppApprovedPath);
        cSWriter.writeString(this.pythonApprovedPath);
        cSWriter.writeInt(this.executionTimeLimit);
        cSWriter.writeInt(this.memLimit);
        cSWriter.writeInt(this.stackLimit);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.compileTimeLimit = cSReader.readInt();
        this.gccBuildCommand = cSReader.readString();
        this.pythonCommand = cSReader.readString();
        this.cppApprovedPath = cSReader.readString();
        this.pythonApprovedPath = cSReader.readString();
        this.executionTimeLimit = cSReader.readInt();
        this.memLimit = cSReader.readInt();
        this.stackLimit = cSReader.readInt();
    }

    public int getExecutionTimeLimit() {
        return this.executionTimeLimit;
    }

    public void setExecutionTimeLimit(int n) {
        this.executionTimeLimit = n;
    }

    public int getMemLimit() {
        return this.memLimit;
    }

    public void setMemLimit(int n) {
        this.memLimit = n <= 0 ? ProblemComponent.DEFAULT_MEM_LIMIT : n;
    }

    public int getStackLimit() {
        return this.stackLimit;
    }

    public void setStackLimit(int n) {
        this.stackLimit = n <= 0 ? ProblemComponent.DEFAULT_SRM_STACK_LIMIT : n;
    }

    public int getCompileTimeLimit() {
        return this.compileTimeLimit;
    }

    public void setCompileTimeLimit(int n) {
        this.compileTimeLimit = n;
    }

    public String getGccBuildCommand() {
        return this.gccBuildCommand;
    }

    public void setGccBuildCommand(String string) {
        this.gccBuildCommand = string;
    }

    public String getPythonCommand() {
        return this.pythonCommand;
    }

    public void setPythonCommand(String string) {
        this.pythonCommand = string;
    }

    public String getPythonApprovedPath() {
        return this.pythonApprovedPath;
    }

    public void setPythonApprovedPath(String string) {
        this.pythonApprovedPath = string;
    }

    public String getCppApprovedPath() {
        return this.cppApprovedPath;
    }

    public void setCppApprovedPath(String string) {
        this.cppApprovedPath = string;
    }

    public static ProblemCustomSettings getDefaultInstance() {
        ProblemCustomSettings problemCustomSettings = new ProblemCustomSettings();
        problemCustomSettings.setMemLimit(ProblemComponent.DEFAULT_MEM_LIMIT);
        problemCustomSettings.setStackLimit(ProblemComponent.DEFAULT_SRM_STACK_LIMIT);
        problemCustomSettings.setCompileTimeLimit(ProblemComponent.DEFAULT_COMPILE_TIME_LIMIT);
        problemCustomSettings.setExecutionTimeLimit(ProblemComponent.DEFAULT_EXECUTION_TIME_LIMIT);
        return problemCustomSettings;
    }
}

