/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.CustomSerializable;
import com.topcoder.shared.problem.BaseElement;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ProblemComponent;
import com.topcoder.shared.problem.ProblemConstants;
import com.topcoder.shared.problem.WebService;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public class Problem
extends BaseElement
implements Element,
Serializable,
CustomSerializable {
    private ProblemComponent[] problemComponents = new ProblemComponent[0];
    private int problemId = -1;
    private String name = "";
    private int problemTypeID = -1;
    private String problemText = "";
    private WebService[] webServices = new WebService[0];

    public final String getCacheKey() {
        return "Problem." + this.problemId;
    }

    public static String getCacheKey(int n) {
        return "Problem." + n;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.problemComponents.length);
        for (int i = 0; i < this.problemComponents.length; ++i) {
            cSWriter.writeObject(this.problemComponents[i]);
        }
        cSWriter.writeInt(this.problemId);
        cSWriter.writeString(this.name);
        cSWriter.writeInt(this.problemTypeID);
        cSWriter.writeString(this.problemText);
        cSWriter.writeObjectArray(this.webServices);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        int n = cSReader.readInt();
        this.problemComponents = new ProblemComponent[n];
        for (int i = 0; i < n; ++i) {
            this.problemComponents[i] = (ProblemComponent)cSReader.readObject();
        }
        this.problemId = cSReader.readInt();
        this.name = cSReader.readString();
        this.problemTypeID = cSReader.readInt();
        this.problemText = cSReader.readString();
        Object[] objectArray = cSReader.readObjectArray();
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        this.webServices = new WebService[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            this.webServices[i] = (WebService)objectArray[i];
        }
    }

    public void setProblemId(int n) {
        this.problemId = n;
    }

    public int getProblemId() {
        return this.problemId;
    }

    public Object clone() {
        Problem problem = new Problem();
        problem.setProblemId(this.problemId);
        problem.setProblemText(this.problemText);
        problem.setProblemComponents(this.problemComponents);
        return problem;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getProblemText() {
        return this.problemText;
    }

    public void setProblemText(String string) {
        this.problemText = string;
    }

    public ProblemComponent[] getProblemComponents() {
        return this.problemComponents;
    }

    public void setProblemComponents(ProblemComponent[] problemComponentArray) {
        this.problemComponents = problemComponentArray;
    }

    public ProblemComponent getPrimaryComponent() {
        for (int i = 0; i < this.problemComponents.length; ++i) {
            if (this.problemComponents[i].getComponentTypeID() != ProblemConstants.MAIN_COMPONENT) continue;
            return this.problemComponents[i];
        }
        return null;
    }

    public int getProblemTypeID() {
        return this.problemTypeID;
    }

    public void setProblemTypeID(int n) {
        this.problemTypeID = n;
    }

    public ProblemComponent getComponent(int n) {
        if (n >= this.problemComponents.length) {
            return null;
        }
        return this.problemComponents[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("(com.topcoder.shared.problem.Problem) [");
        stringBuffer.append("problemComponents = ");
        if (this.problemComponents == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append("{");
            for (int i = 0; i < this.problemComponents.length; ++i) {
                stringBuffer.append(this.problemComponents[i].toString() + ",");
            }
            stringBuffer.append("}");
        }
        stringBuffer.append(", ");
        stringBuffer.append("problemId = ");
        stringBuffer.append(this.problemId);
        stringBuffer.append(", ");
        stringBuffer.append("name = ");
        if (this.name == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.name.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("problemTypeID = ");
        stringBuffer.append(this.problemTypeID);
        stringBuffer.append(", ");
        stringBuffer.append("problemText = ");
        if (this.problemText == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.problemText.toString());
        }
        stringBuffer.append(", ");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isValid() {
        boolean bl = true;
        for (int i = 0; i < this.problemComponents.length; ++i) {
            bl = bl && this.problemComponents[i].isValid();
        }
        return bl;
    }

    public void setWebServices(WebService[] webServiceArray) {
        this.webServices = webServiceArray;
    }

    public WebService[] getWebServices() {
        return this.webServices;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }
}

