/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.BaseElement;
import com.topcoder.shared.problem.Element;
import com.topcoder.shared.problem.ProblemComponent;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class NodeElement
extends BaseElement {
    private String name;
    private HashMap attributes;
    private ArrayList children;
    private String text;

    public NodeElement() {
    }

    public NodeElement(String string, HashMap hashMap, ArrayList arrayList, String string2) {
        this.name = string;
        this.attributes = hashMap;
        this.children = arrayList;
        this.text = string2;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeString(this.name);
        cSWriter.writeHashMap(this.attributes);
        cSWriter.writeArrayList(this.children);
        cSWriter.writeString(this.text);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.name = cSReader.readString();
        this.attributes = cSReader.readHashMap();
        this.children = cSReader.readArrayList();
        this.text = cSReader.readString();
    }

    public String getText() {
        return this.text;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public String toXML() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(64 * this.children.size());
        stringBuffer.append('<');
        stringBuffer.append(this.name);
        Iterator iterator = this.attributes.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringBuffer.append(' ');
            stringBuffer.append((String)object);
            stringBuffer.append("=\"");
            stringBuffer.append(ProblemComponent.encodeHTML((String)this.attributes.get(object)));
            stringBuffer.append('\"');
        }
        stringBuffer.append('>');
        for (int i = 0; i < this.children.size(); ++i) {
            object = (Element)this.children.get(i);
            stringBuffer.append(object.toXML());
        }
        stringBuffer.append("</");
        stringBuffer.append(this.name);
        stringBuffer.append('>');
        return stringBuffer.toString();
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(64 * this.children.size());
        boolean bl = USER_ONLY_TAGS_LIST.contains(this.name);
        if (bl) {
            stringBuffer.append('<');
            stringBuffer.append(this.name);
            Iterator iterator = this.attributes.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                stringBuffer.append(' ');
                stringBuffer.append((String)object);
                stringBuffer.append("=\"");
                stringBuffer.append(ProblemComponent.encodeHTML((String)this.attributes.get(object)));
                stringBuffer.append('\"');
            }
            stringBuffer.append('>');
        }
        for (int i = 0; i < this.children.size(); ++i) {
            object = (Element)this.children.get(i);
            stringBuffer.append(object.toString());
        }
        if (bl) {
            stringBuffer.append("</");
            stringBuffer.append(this.name);
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }
}

