/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.language.Language;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.BaseElement;
import com.topcoder.shared.problem.InvalidTypeException;
import com.topcoder.shared.problem.ProblemComponent;
import com.topcoder.shared.problem.SimpleDataTypeFactory;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.HashMap;

public class DataType
extends BaseElement {
    private HashMap typeMapping = new HashMap();
    private int id = -1;
    private String description = "";
    private String baseName;
    private int dim;

    public DataType() {
    }

    public DataType(String string) {
        this(-1, string, new HashMap());
    }

    public DataType(int n, String string) {
        this(n, string, new HashMap());
    }

    public DataType(int n, String string, HashMap hashMap) {
        this.id = n;
        this.description = string;
        this.typeMapping = hashMap;
        this.parseDescription();
        SimpleDataTypeFactory.registerDataType(this);
    }

    public void setTypeMapping(HashMap hashMap) {
        this.typeMapping = hashMap;
    }

    public HashMap getTypeMapping() {
        return this.typeMapping;
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.id);
        cSWriter.writeString(this.description);
        cSWriter.writeHashMap(this.typeMapping);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.id = cSReader.readInt();
        this.description = cSReader.readString();
        this.typeMapping = cSReader.readHashMap();
        this.parseDescription();
        SimpleDataTypeFactory.registerDataType(this);
    }

    private void parseDescription() {
        int n = this.description.indexOf(91);
        if (n == -1) {
            this.baseName = this.description;
            this.dim = 0;
            return;
        }
        this.baseName = this.description.substring(0, n);
        this.dim = 0;
        while (n != -1) {
            ++this.dim;
            n = this.description.indexOf(91, n + 1);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptor(Language language) {
        String string = (String)this.typeMapping.get(new Integer(language.getId()));
        return string == null ? this.getDescription() : string;
    }

    public String getDescriptor(int n) {
        String string = (String)this.typeMapping.get(new Integer(n));
        return string == null ? this.getDescription() : string;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public int getDimension() {
        return this.dim;
    }

    public DataType reduceDimension() throws InvalidTypeException {
        StringBuffer stringBuffer = new StringBuffer(this.description);
        int n = this.description.indexOf("[]");
        if (n == -1) {
            throw new InvalidTypeException("Attempt to reduce dimension of type " + this.description);
        }
        stringBuffer.delete(n, n + 2);
        return SimpleDataTypeFactory.getDataType(stringBuffer.toString());
    }

    public String toXML() {
        return "<type>" + ProblemComponent.encodeHTML(this.description) + "</type>";
    }

    public boolean equals(Object object) {
        return object != null && object instanceof DataType && this.description.equals(((DataType)object).getDescription());
    }

    DataType cloneDataType() {
        try {
            return (DataType)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getID() {
        return this.id;
    }

    public String toString() {
        return this.toXML();
    }
}

