/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.problem;

import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.problem.DataType;
import com.topcoder.shared.problem.DataValue;
import com.topcoder.shared.problem.DataValueParseException;
import com.topcoder.shared.problem.DataValueReader;
import java.io.IOException;
import java.io.ObjectStreamException;

public class CharacterValue
extends DataValue {
    private char value;

    public CharacterValue() {
    }

    public CharacterValue(char c) {
        this.value = c;
    }

    public void parse(DataValueReader dataValueReader, DataType dataType) throws IOException, DataValueParseException {
        dataValueReader.expect('\'', true);
        int n = dataValueReader.read(true);
        switch ((char)n) {
            case '\'': {
                dataValueReader.exception("Missing character");
            }
            case '\\': {
                this.value = (char)dataValueReader.read(true);
                break;
            }
            default: {
                this.value = (char)n;
            }
        }
        dataValueReader.expect('\'', true);
    }

    public void customWriteObject(CSWriter cSWriter) throws IOException {
        cSWriter.writeInt(this.value);
    }

    public void customReadObject(CSReader cSReader) throws IOException, ObjectStreamException {
        this.value = (char)cSReader.readInt();
    }

    public String encode() {
        if (this.value == '\\' || this.value == '\'') {
            return "'\\" + this.value + "'";
        }
        return "'" + this.value + "'";
    }

    public char getChar() {
        return this.value;
    }

    public Object getValue() {
        return new Character(this.value);
    }
}

