/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.netCommon;

import com.topcoder.shared.netCommon.SealedSerializable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;

public class MessageEncryptionHandler {
    private byte[] requestKey;
    private byte[] replyKey;
    private static final KeyGenerator keygen;
    private static final Cipher cipher;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object unsealObject(SealedSerializable sealedSerializable, Key key) throws GeneralSecurityException {
        try {
            Cipher cipher = MessageEncryptionHandler.cipher;
            synchronized (cipher) {
                MessageEncryptionHandler.cipher.init(2, key);
                return sealedSerializable.getObject(MessageEncryptionHandler.cipher);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new GeneralSecurityException("Decryption failed.", classNotFoundException);
        }
        catch (IOException iOException) {
            throw new GeneralSecurityException("Decryption failed.", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SealedSerializable sealObject(Object object, Key key) throws GeneralSecurityException {
        try {
            Cipher cipher = MessageEncryptionHandler.cipher;
            synchronized (cipher) {
                MessageEncryptionHandler.cipher.init(1, key);
                return new SealedSerializable(object, MessageEncryptionHandler.cipher);
            }
        }
        catch (IOException iOException) {
            throw new GeneralSecurityException("Encryption failed.", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] generateKey() {
        KeyGenerator keyGenerator = keygen;
        synchronized (keyGenerator) {
            return keygen.generateKey().getEncoded();
        }
    }

    public byte[] generateRequestKey() {
        this.requestKey = this.generateKey();
        return this.requestKey;
    }

    public void setReplyKey(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("The reply key must be 16 bytes.");
        }
        this.replyKey = byArray;
    }

    public Key getFinalKey() {
        if (this.requestKey == null || this.replyKey == null) {
            throw new IllegalStateException("Either request key or reply key is missing.");
        }
        byte[] byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = (byte)(this.requestKey[i] + this.replyKey[i]);
        }
        return new SecretKeySpec(byArray, "AES");
    }

    static {
        try {
            keygen = KeyGenerator.getInstance("AES");
            keygen.init(128);
            cipher = Cipher.getInstance("AES");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UnsupportedOperationException("AES 128-bit is not supported by Java.", generalSecurityException);
        }
    }
}

