/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.shared.netCommon;

import com.topcoder.io.serialization.basictype.BasicTypeDataInput;
import com.topcoder.io.serialization.basictype.BasicTypeDataOutput;
import com.topcoder.io.serialization.basictype.MemoryUsageLimitExceededException;
import com.topcoder.shared.netCommon.CSReader;
import com.topcoder.shared.netCommon.CSWriter;
import com.topcoder.shared.netCommon.ClassCache;
import com.topcoder.shared.netCommon.CustomSerializable;
import com.topcoder.shared.netCommon.ReflectUtils;
import com.topcoder.shared.netCommon.ResolvedCustomSerializable;
import com.topcoder.shared.netCommon.SealedSerializable;
import com.topcoder.shared.netCommon.customserializer.CustomSerializer;
import com.topcoder.shared.netCommon.customserializer.CustomSerializerProvider;
import com.topcoder.shared.netCommon.customserializer.NullCustomSerializerProvider;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Array;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;

public abstract class CSHandler
implements CSReader,
CSWriter {
    private BasicTypeDataOutput output;
    private BasicTypeDataInput input;
    private CustomSerializerProvider customSerializer;
    private Cipher encryptor;
    private Cipher decryptor;

    public CSHandler() {
        this(new NullCustomSerializerProvider());
    }

    public CSHandler(CustomSerializerProvider customSerializerProvider) {
        this(customSerializerProvider, null);
    }

    public CSHandler(Key key) {
        this(new NullCustomSerializerProvider(), key);
    }

    public CSHandler(CustomSerializerProvider customSerializerProvider, Key key) {
        this.customSerializer = customSerializerProvider;
        if (key != null) {
            try {
                this.encryptor = Cipher.getInstance(key.getAlgorithm());
                this.encryptor.init(1, key);
                this.decryptor = Cipher.getInstance(key.getAlgorithm());
                this.decryptor.init(2, key);
            }
            catch (GeneralSecurityException generalSecurityException) {
                this.encryptor = null;
                this.decryptor = null;
            }
        }
    }

    public final void setMemoryUsageLimit(long l) {
        this.resetMemoryUsage();
        try {
            this.input.setMemoryUsageLimit(l);
        }
        catch (MemoryUsageLimitExceededException memoryUsageLimitExceededException) {
            // empty catch block
        }
    }

    public final void resetMemoryUsage() {
        this.input.resetMemoryUsageCounter();
    }

    public final void setDataInput(BasicTypeDataInput basicTypeDataInput) {
        this.input = basicTypeDataInput;
    }

    public final void setDataOutput(BasicTypeDataOutput basicTypeDataOutput) {
        this.output = basicTypeDataOutput;
    }

    public final void writeByte(byte by) throws IOException {
        this.output.writeByte(by);
    }

    public final byte readByte() throws IOException {
        return this.input.readByte();
    }

    private boolean isNull(byte by) throws IOException {
        byte by2 = this.readByte();
        if (by2 == 1) {
            return true;
        }
        if (by2 != by) {
            throw new RuntimeException("unexpected, b=" + by2 + ", expected=" + by);
        }
        return false;
    }

    private boolean isNull(byte by, byte by2) throws IOException {
        byte by3 = this.readByte();
        if (by3 == 1) {
            return true;
        }
        if (by3 != by && by3 != by2) {
            throw new RuntimeException("unexpected, b=" + by3 + ", expected=" + by + " or " + by2);
        }
        return false;
    }

    private void writeNull() throws IOException {
        this.writeByte((byte)1);
    }

    public final int readInt() throws IOException {
        return this.input.readInt();
    }

    public final void writeInt(int n) throws IOException {
        this.output.writeInt(n);
    }

    public final long readLong() throws IOException {
        return this.input.readLong();
    }

    public final void writeLong(long l) throws IOException {
        this.output.writeLong(l);
    }

    public final boolean readBoolean() throws IOException {
        return this.input.readBoolean();
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.output.writeBoolean(bl);
    }

    public final ArrayList readArrayList() throws IOException {
        if (this.isNull((byte)33, (byte)35)) {
            return null;
        }
        return this.readJustArrayList();
    }

    private ArrayList readJustArrayList() throws IOException {
        int n = this.readInt();
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.readObject());
        }
        return arrayList;
    }

    public final void writeCollection(Collection collection) throws IOException {
        this.writeCollection(collection, (byte)37);
    }

    public final void writeArrayList(ArrayList arrayList) throws IOException {
        this.writeCollection(arrayList, (byte)33);
    }

    public void writeList(List list) throws IOException {
        this.writeCollection(list, (byte)35);
    }

    public void writeCollection(Collection collection, byte by) throws IOException {
        if (collection == null) {
            this.writeNull();
            return;
        }
        int n = collection.size();
        this.writeByte(by);
        this.writeInt(n);
        try {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.writeObject(iterator.next());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.throwConcurrentModificationException(concurrentModificationException, collection);
        }
    }

    private Object[] readJustObjectArray(Class clazz) throws IOException {
        int n = this.readInt();
        Object[] objectArray = (Object[])Array.newInstance(clazz, n);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readObject();
        }
        return objectArray;
    }

    private Object[] readJustObjectArray() throws IOException {
        int n = this.readInt();
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readObject();
        }
        return objectArray;
    }

    public final Object[] readObjectArray() throws IOException {
        if (this.isNull((byte)9)) {
            return null;
        }
        return this.readJustObjectArray();
    }

    public final Object[] readObjectArray(Class clazz) throws IOException {
        if (this.isNull((byte)9)) {
            return null;
        }
        return this.readJustObjectArray(clazz);
    }

    private void writeJustObjectArray(Object[] objectArray) throws IOException {
        int n = objectArray.length;
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeObject(objectArray[i]);
        }
    }

    public final void writeObjectArray(Object[] objectArray) throws IOException {
        if (objectArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)9);
        this.writeJustObjectArray(objectArray);
    }

    public final Object[][] readObjectArrayArray(Class clazz) throws IOException {
        if (this.isNull((byte)14)) {
            return null;
        }
        int n = this.readInt();
        Object[][] objectArray = (Object[][])Array.newInstance(clazz, n, 0);
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readJustObjectArray(clazz);
        }
        return objectArray;
    }

    private Object[][] readJustObjectArrayArray() throws IOException {
        int n = this.readInt();
        Object[][] objectArray = new Object[n][];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.readJustObjectArray();
        }
        return objectArray;
    }

    public final void writeObjectArrayArray(Object[][] objectArray) throws IOException {
        if (objectArray == null) {
            this.writeNull();
            return;
        }
        int n = objectArray.length;
        this.writeByte((byte)14);
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeJustObjectArray(objectArray[i]);
        }
    }

    private double[][] readJustDoubleArrayArray() throws IOException {
        int n = this.readInt();
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = this.readJustDoubleArray();
        }
        return dArrayArray;
    }

    public final void writeDoubleArrayArray(double[][] dArray) throws IOException {
        if (dArray == null) {
            this.writeNull();
            return;
        }
        int n = dArray.length;
        this.writeByte((byte)18);
        this.writeInt(n);
        for (int i = 0; i < n; ++i) {
            this.writeJustDoubleArray(dArray[i]);
        }
    }

    private void writeJustDoubleArray(double[] dArray) throws IOException {
        this.output.writeDoubleArray(dArray);
    }

    private int[] readJustIntArray() throws IOException {
        return this.input.readIntArray();
    }

    private long[] readJustLongArray() throws IOException {
        return this.input.readLongArray();
    }

    private void writeIntArray(int[] nArray) throws IOException {
        if (nArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)10);
        this.output.writeIntArray(nArray);
    }

    private void writeLongArray(long[] lArray) throws IOException {
        if (lArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)19);
        this.output.writeLongArray(lArray);
    }

    private double[] readJustDoubleArray() throws IOException {
        return this.input.readDoubleArray();
    }

    private void writeDoubleArray(double[] dArray) throws IOException {
        if (dArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)16);
        this.output.writeDoubleArray(dArray);
    }

    private String[] readJustStringArray() throws IOException {
        return this.input.readStringArray();
    }

    public void writeStringArray(String[] stringArray) throws IOException {
        if (stringArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)12);
        this.output.writeStringArray(stringArray, null);
    }

    public final HashMap readHashMap() throws IOException {
        if (this.isNull((byte)34, (byte)36)) {
            return null;
        }
        return this.readJustHashMap();
    }

    private HashMap readJustHashMap() throws IOException {
        int n = this.readInt();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(n);
        for (int i = 0; i < n; ++i) {
            Object object = this.readObject();
            Object object2 = this.readObject();
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    public final void writeHashMap(HashMap hashMap) throws IOException {
        this.doWriteMap(hashMap, (byte)34);
    }

    public final void writeMap(Map map) throws IOException {
        this.doWriteMap(map, (byte)36);
    }

    private void doWriteMap(Map map, byte by) throws IOException {
        if (map == null) {
            this.writeNull();
            return;
        }
        int n = map.size();
        this.writeByte(by);
        this.writeInt(n);
        try {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.writeObject(entry.getKey());
                this.writeObject(entry.getValue());
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            this.throwConcurrentModificationException(concurrentModificationException, map);
        }
    }

    private void throwConcurrentModificationException(ConcurrentModificationException concurrentModificationException, Object object) {
        throw new ConcurrentModificationException(concurrentModificationException + ", object=" + object);
    }

    public String readUTF() throws IOException {
        return this.input.readString();
    }

    public void writeUTF(String string) throws IOException {
        this.output.writeString(string, null);
    }

    public final String readString() throws IOException {
        if (this.isNull((byte)2)) {
            return null;
        }
        return this.input.readString();
    }

    public final void writeString(String string) throws IOException {
        if (string == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)2);
        this.output.writeString(string, null);
    }

    private byte[] readJustByteArray() throws IOException {
        return this.input.readByteArray();
    }

    public final byte[] readByteArray() throws IOException {
        if (this.isNull((byte)8)) {
            return null;
        }
        return this.readJustByteArray();
    }

    public final void writeByteArray(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)8);
        this.output.writeByteArray(byArray);
    }

    private char[] readJustCharArray() throws IOException {
        return this.input.readCharArray();
    }

    public final void writeCharArray(char[] cArray) throws IOException {
        if (cArray == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)5);
        this.output.writeCharArray(cArray);
    }

    private char readChar() throws IOException {
        return this.input.readChar();
    }

    private void writeChar(char c) throws IOException {
        this.output.writeChar(c);
    }

    public double readDouble() throws IOException {
        return this.input.readDouble();
    }

    public void writeDouble(double d) throws IOException {
        this.output.writeDouble(d);
    }

    public void writeClass(Class clazz) throws IOException {
        if (clazz == null) {
            this.writeNull();
            return;
        }
        this.writeByte((byte)17);
        this.writeUTF(clazz.getName());
    }

    private Class readJustClass() throws IOException {
        String string = this.readUTF();
        try {
            return ClassCache.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage());
        }
    }

    protected final void customWriteObject(Object object) throws IOException {
        ((CustomSerializable)object).customWriteObject(this);
    }

    protected abstract boolean writeObjectOverride(Object var1) throws IOException;

    public final void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
            return;
        }
        CustomSerializer customSerializer = this.customSerializer.getSerializer(object.getClass());
        if (customSerializer != null) {
            this.writeByte((byte)64);
            this.writeUTF(object.getClass().getName());
            customSerializer.writeObject(this, object);
            return;
        }
        if (this.writeObjectOverride(object)) {
            return;
        }
        if (object instanceof ArrayList) {
            this.writeArrayList((ArrayList)object);
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof Integer) {
            this.writeByte((byte)4);
            this.writeInt((Integer)object);
        } else if (object instanceof HashMap) {
            this.writeHashMap((HashMap)object);
        } else if (object instanceof Boolean) {
            this.writeByte((byte)3);
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            this.writeByte((byte)7);
            this.writeByte((Byte)object);
        } else if (object instanceof Long) {
            this.writeByte((byte)13);
            this.writeLong((Long)object);
        } else if (object instanceof Character) {
            this.writeByte((byte)11);
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Double) {
            this.writeByte((byte)6);
            this.writeDouble((Double)object);
        } else if (object instanceof char[]) {
            this.writeCharArray((char[])object);
        } else if (object instanceof int[]) {
            this.writeIntArray((int[])object);
        } else if (object instanceof long[]) {
            this.writeLongArray((long[])object);
        } else if (object instanceof double[]) {
            this.writeDoubleArray((double[])object);
        } else if (object instanceof double[][]) {
            this.writeDoubleArrayArray((double[][])object);
        } else if (object instanceof String[]) {
            this.writeStringArray((String[])object);
        } else if (object instanceof byte[]) {
            this.writeByteArray((byte[])object);
        } else if (object instanceof CustomSerializable) {
            this.writeByte((byte)65);
            this.writeUTF(object.getClass().getName());
            this.customWriteObject(object);
        } else if (object instanceof Object[][]) {
            this.writeObjectArrayArray((Object[][])object);
        } else if (object instanceof Object[]) {
            this.writeObjectArray((Object[])object);
        } else if (object instanceof Class) {
            this.writeClass((Class)object);
        } else if (object instanceof List) {
            this.writeList((List)object);
        } else if (object instanceof Map) {
            this.writeMap((Map)object);
        } else if (object instanceof Collection) {
            this.writeCollection((Collection)object);
        } else {
            this.writeUnhandledObject(object);
        }
    }

    protected void writeUnhandledObject(Object object) throws IOException {
        throw new RuntimeException("writeBaseObject, not implemented: " + object.getClass());
    }

    private static Boolean booleanValueOf(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public final Object readObject() throws IOException {
        Class clazz = null;
        byte by = this.readByte();
        switch (by) {
            case 1: {
                return null;
            }
            case 2: {
                return this.readUTF();
            }
            case 3: {
                return CSHandler.booleanValueOf(this.readBoolean());
            }
            case 4: {
                return new Integer(this.readInt());
            }
            case 13: {
                return new Long(this.readLong());
            }
            case 6: {
                return new Double(this.readDouble());
            }
            case 7: {
                return new Byte(this.readByte());
            }
            case 11: {
                return new Character(this.readChar());
            }
            case 33: {
                return this.readJustArrayList();
            }
            case 8: {
                return this.readJustByteArray();
            }
            case 5: {
                return this.readJustCharArray();
            }
            case 10: {
                return this.readJustIntArray();
            }
            case 19: {
                return this.readJustLongArray();
            }
            case 16: {
                return this.readJustDoubleArray();
            }
            case 18: {
                return this.readJustDoubleArrayArray();
            }
            case 12: {
                return this.readJustStringArray();
            }
            case 65: {
                clazz = this.findClassGuarded(this.readUTF());
                return this.readCustomSerializable(clazz);
            }
            case 34: {
                return this.readJustHashMap();
            }
            case 9: {
                return this.readJustObjectArray();
            }
            case 14: {
                return this.readJustObjectArrayArray();
            }
            case 17: {
                return this.readJustClass();
            }
            case 35: {
                return this.readJustArrayList();
            }
            case 36: {
                return this.readJustHashMap();
            }
            case 37: {
                return this.readJustArrayList();
            }
            case 64: {
                clazz = this.findClassGuarded(this.readUTF());
                CustomSerializer customSerializer = this.customSerializer.getSerializer(clazz);
                if (customSerializer != null) {
                    return customSerializer.readObject(this);
                }
                throw new StreamCorruptedException("Custom serializer can't handle class=" + clazz.getName());
            }
        }
        return this.readObjectOverride(by);
    }

    protected Class findClassGuarded(String string) {
        try {
            return ClassCache.findClass(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Object readCustomSerializable(Class clazz) throws IOException, ObjectStreamException {
        CustomSerializable customSerializable = (CustomSerializable)ReflectUtils.newInstance(clazz);
        customSerializable.customReadObject(this);
        if (customSerializable instanceof ResolvedCustomSerializable) {
            return ((ResolvedCustomSerializable)customSerializable).readResolve();
        }
        return customSerializable;
    }

    protected Object readObjectOverride(byte by) throws IOException {
        throw new StreamCorruptedException("readObjectOverride, type=" + by);
    }

    public Object readEncrypt() throws IOException {
        if (this.decryptor == null) {
            throw new UnsupportedOperationException("No encryption algorithm/key provided.");
        }
        try {
            return ((SealedSerializable)this.readObject()).getObject(this.decryptor);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (IOException)new IOException("Encrypted data corrupted.").initCause(generalSecurityException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw (IOException)new IOException("Encrypted data corrupted.").initCause(classNotFoundException);
        }
    }

    public void writeEncrypt(Object object) throws IOException {
        if (this.encryptor == null) {
            throw new UnsupportedOperationException("No encryption algorithm/key provided.");
        }
        try {
            this.writeObject(new SealedSerializable((Serializable)object, this.encryptor));
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw (IOException)new IOException("Encryption failed for the input data.").initCause(generalSecurityException);
        }
    }
}

